/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.BeanDescriptor;
import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.FieldOperator;
import cn.featherfly.common.db.FieldValueOperator;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperate<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String sql;
    protected Jdbc jdbc;
    protected JdbcClassMapping<T> classMapping;
    protected BeanDescriptor<T> beanDescriptor;
    protected SqlTypeMappingManager sqlTypeMappingManager;
    protected DatabaseMetadata meta;
    protected Map<Integer, JdbcPropertyMapping> propertyPositions = new HashMap<Integer, JdbcPropertyMapping>(0);
    protected List<BeanProperty<T, Serializable>> pkProperties = new ArrayList<BeanProperty<T, Serializable>>();

    public AbstractOperate(Jdbc jdbc, JdbcClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata) {
        this.jdbc = jdbc;
        this.classMapping = classMapping;
        this.meta = databaseMetadata;
        this.sqlTypeMappingManager = sqlTypeMappingManager;
        this.init();
    }

    private void init() {
        this.beanDescriptor = BeanDescriptor.getBeanDescriptor((Class)this.classMapping.getType());
        for (JdbcPropertyMapping pm : this.classMapping.getPrivaryKeyPropertyMappings()) {
            this.pkProperties.add(BeanDescriptor.getBeanDescriptor((Class)this.classMapping.getType()).getBeanProperty(pm.getPropertyFullName()));
        }
        this.initSql();
    }

    public String getSql() {
        return this.sql;
    }

    public Object[] getParameters(T entity) {
        return this.getParameters(entity, this.propertyPositions);
    }

    protected Object[] getParameters(T entity, Map<Integer, JdbcPropertyMapping> propertyPositions) {
        int i = 0;
        Object[] operators = new FieldOperator[propertyPositions.size()];
        for (Map.Entry<Integer, JdbcPropertyMapping> propertyPosition : propertyPositions.entrySet()) {
            operators[i] = FieldValueOperator.create((JdbcPropertyMapping)propertyPosition.getValue(), (Object)BeanUtils.getProperty(entity, (String)propertyPosition.getValue().getPropertyFullName()));
            ++i;
        }
        return operators;
    }

    protected abstract void initSql();

    protected boolean isDebug() {
        return this.logger.isDebugEnabled();
    }
}

