/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractExecuteOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.BatchExecuteOperate;
import java.util.List;
import java.util.Map;

public abstract class AbstractBatchExecuteOperate<T>
extends AbstractExecuteOperate<T>
implements BatchExecuteOperate<T> {
    public AbstractBatchExecuteOperate(Jdbc jdbc, JdbcClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, sqlTypeMappingManager, databaseMetadata);
    }

    @Override
    public int[] executeBatch(List<T> entities, int batchSize) {
        if (Lang.isEmpty(entities)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        if (this.supportBatch()) {
            return this.doExecuteBatch(entities, batchSize);
        }
        if (this.meta.getFeatures().supportsBatchUpdates()) {
            return this.doExecute(entities, batchSize);
        }
        int[] results = new int[entities.size()];
        for (int i = 0; i < entities.size(); ++i) {
            results[i] = this.execute(entities.get(i));
        }
        return results;
    }

    protected abstract boolean supportBatch();

    protected abstract int doExecuteBatch(List<T> var1);

    protected int[] doExecuteBatch(List<T> entities, int batchSize) {
        if (entities.size() <= batchSize) {
            return new int[]{this.doExecuteBatch(entities)};
        }
        int times = entities.size() / batchSize;
        if (entities.size() % batchSize != 0) {
            ++times;
        }
        int[] results = new int[times];
        for (int i = 0; i < times; ++i) {
            int start;
            int end = (start = i * batchSize) + batchSize;
            results[i] = this.doExecuteBatch(entities.subList(start, end > entities.size() ? entities.size() : end));
        }
        return results;
    }

    protected int[] doExecute(List<T> entities, int batchSize) {
        if (entities.size() <= batchSize) {
            return this.doExecute(entities);
        }
        int times = entities.size() / batchSize;
        if (entities.size() % batchSize != 0) {
            ++times;
        }
        int[] results = new int[entities.size()];
        for (int i = 0; i < times; ++i) {
            int start;
            int end = (start = i * batchSize) + batchSize;
            int[] rs = this.doExecute(entities.subList(start, end > entities.size() ? entities.size() : end));
            for (int j = 0; j < rs.length; ++j) {
                results[i * batchSize + j] = rs[j];
            }
        }
        return results;
    }

    protected abstract int[] doExecute(List<T> var1);

    protected Object[] getBatchParameters(List<T> entities, Map<Integer, JdbcPropertyMapping> propertyPositions) {
        Object[] params = new Object[propertyPositions.size() * entities.size()];
        for (int i = 0; i < entities.size(); ++i) {
            T entity = entities.get(i);
            int index = 0;
            for (Map.Entry<Integer, JdbcPropertyMapping> propertyPosition : propertyPositions.entrySet()) {
                params[i * propertyPositions.size() + index] = BeanUtils.getProperty(entity, (String)propertyPosition.getValue().getPropertyFullName());
                ++index;
            }
        }
        return params;
    }
}

