/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.mapping.SqlResultSet;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.repository.mapping.RowMapper;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class SingleColumnRowMapper<T>
implements RowMapper<T> {
    private Class<?> requiredType;
    private SqlTypeMappingManager manager;
    private String prefix;
    private int matchIndex = 1;

    public SingleColumnRowMapper(Class<T> requiredType, SqlTypeMappingManager manager) {
        this(requiredType, manager, null);
    }

    public SingleColumnRowMapper(@Nonnull Class<T> requiredType, @Nonnull SqlTypeMappingManager manager, String prefix) {
        AssertIllegalArgument.isNotNull(requiredType, (String)"requiredType");
        AssertIllegalArgument.isNotNull((Object)manager, (String)"sqlTypeMappingManager");
        this.setRequiredType(requiredType);
        this.manager = manager;
        this.prefix = prefix;
    }

    public void setRequiredType(Class<T> requiredType) {
        this.requiredType = ClassUtils.resolvePrimitiveIfNecessary(requiredType);
    }

    public T mapRow(cn.featherfly.common.repository.mapping.ResultSet res, int rowNum) {
        ResultSet rs = null;
        if (!(res instanceof SqlResultSet)) {
            throw new JdbcException("ResultSet is not type of SqlResultSet");
        }
        SqlResultSet sqlrs = (SqlResultSet)res;
        rs = sqlrs.getResultSet();
        AssertIllegalArgument.isNotNull((Object)rs, (String)"java.sql.ResultSet");
        try {
            return this.mapRow(rs, rowNum);
        }
        catch (SQLException e) {
            throw new JdbcException((Throwable)e);
        }
    }

    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        if (rowNum == 0) {
            this.check(rs);
            this.setType(rs);
        }
        return (T)this.getColumnValue(rs, this.matchIndex, this.requiredType);
    }

    private void check(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        if (this.prefix == null) {
            int nrOfColumns = rsmd.getColumnCount();
            if (nrOfColumns != 1) {
                throw new JdbcException("Incorrect column count: expected 1, actual " + nrOfColumns);
            }
            this.matchIndex = 1;
        } else {
            int columnCount = rsmd.getColumnCount();
            String matchFiled = null;
            for (int index = 1; index <= columnCount; ++index) {
                String fieldName = JdbcUtils.getColumnName((ResultSet)rs, (int)index);
                if (!fieldName.startsWith(this.prefix)) continue;
                if (matchFiled != null) {
                    throw new JdbcException(Strings.format((String)"there is more than one column name [{0},{1}] with prefix {2}", (Object[])new Object[]{matchFiled, fieldName, this.prefix}));
                }
                matchFiled = fieldName;
                this.matchIndex = index;
            }
            if (this.matchIndex == -1) {
                throw new JdbcException("there is no column name with prefix " + this.prefix);
            }
        }
    }

    private void setType(ResultSet rs) {
        Class type;
        if (this.requiredType == Object.class && (type = this.manager.getJavaType(JdbcUtils.getResultSetType((ResultSet)rs, (int)this.matchIndex))) != null) {
            this.requiredType = type;
        }
    }

    @Nullable
    protected Object getColumnValue(ResultSet rs, int index, @Nullable Class<?> requiredType) {
        return this.manager.get(rs, index, requiredType);
    }
}

