/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.mapping.SqlResultSet;
import cn.featherfly.common.repository.mapping.ResultSet;
import cn.featherfly.common.repository.mapping.RowMapper;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

public class RowIterable<T>
implements Iterable<T> {
    @Nonnull
    private ResultSet res;
    @Nonnull
    private RowMapper<T> mapper;

    public RowIterable(ResultSet res, RowMapper<T> mapper) {
        this.res = res;
        this.mapper = mapper;
    }

    @Override
    public Iterator<T> iterator() {
        return new MapRowLazyIterator(this.res, this.mapper);
    }

    private static class MapRowLazyIterator<T>
    implements Iterator<T> {
        @Nonnull
        private ResultSet res;
        @Nonnull
        private RowMapper<T> mapper;
        private int index;
        private boolean forward;
        private boolean hasNext;

        private MapRowLazyIterator(ResultSet res, RowMapper<T> mapper) {
            this.res = res;
            this.mapper = mapper;
        }

        @Override
        public boolean hasNext() {
            if (this.res == null) {
                return false;
            }
            if (this.forward) {
                return this.hasNext;
            }
            try {
                this.forward = true;
                this.hasNext = ((SqlResultSet)this.res).getResultSet().next();
                return this.hasNext;
            }
            catch (SQLException e) {
                throw new JdbcException((Throwable)e);
            }
        }

        @Override
        public T next() {
            if (this.res == null) {
                throw new NoSuchElementException();
            }
            if (!this.forward) {
                this.hasNext();
            }
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.forward = false;
            return (T)this.mapper.mapRow(this.res, this.index++);
        }
    }
}

