/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.mapping.JdbcMappingException;
import cn.featherfly.common.db.mapping.SqlResultSet;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.repository.builder.AliasManager;
import cn.featherfly.common.repository.mapping.RowMapper;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapRowMapper
implements RowMapper<Map<String, Object>> {
    private SqlTypeMappingManager manager;
    private final Map<String, Class<?>> mappingMap = new LinkedHashMap();
    private static final AliasManager.AliasGeneretor ALIAS_GENERETOR = (name, no) -> name + "(" + no + ")";

    public MapRowMapper(SqlTypeMappingManager manager) {
        this.manager = manager;
    }

    public Map<String, Object> mapRow(cn.featherfly.common.repository.mapping.ResultSet res, int rowNum) {
        ResultSet rs = null;
        if (!(res instanceof SqlResultSet)) {
            throw new JdbcMappingException("ResultSet is not type of SqlResultSet");
        }
        SqlResultSet sqlrs = (SqlResultSet)res;
        rs = sqlrs.getResultSet();
        AssertIllegalArgument.isNotNull((Object)rs, (String)"java.sql.ResultSet");
        try {
            return this.mapRow(rs, rowNum);
        }
        catch (SQLException e) {
            throw new JdbcException((Throwable)e);
        }
    }

    public Map<String, Object> mapRow(ResultSet res, int rowNum) throws SQLException {
        if (rowNum == 0) {
            AliasManager aliasManager = new AliasManager(ALIAS_GENERETOR);
            ResultSetMetaData metaData = res.getMetaData();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                String name = JdbcUtils.lookupColumnName((ResultSetMetaData)metaData, (int)i, (boolean)true);
                if (this.mappingMap.containsKey(name)) {
                    name = aliasManager.put(name);
                }
                this.mappingMap.put(name, this.manager.getJavaType(JdbcUtils.getResultSetType((ResultSet)res, (int)i)));
            }
        }
        int columnIndex = 1;
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Class<?>> entry : this.mappingMap.entrySet()) {
            resultMap.put(entry.getKey(), this.manager.get(res, columnIndex, entry.getValue()));
            ++columnIndex;
        }
        return resultMap;
    }
}

