/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.hammer.sqldb.jdbc.AbstractJdbc;
import cn.featherfly.hammer.sqldb.jdbc.JdbcSession;
import cn.featherfly.hammer.sqldb.jdbc.transaction.Isolation;
import cn.featherfly.hammer.sqldb.jdbc.transaction.JdbcTransaction;
import cn.featherfly.hammer.sqldb.jdbc.transaction.JdbcTransactionImpl;
import java.sql.Connection;
import java.sql.SQLException;

public class JdbcImpl
extends AbstractJdbc
implements JdbcSession {
    private Connection connection;
    private Isolation defaultIsolation = Isolation.READ_COMMITTED;

    public JdbcImpl(Connection connection, Dialect dialect, DatabaseMetadata metadata, SqlTypeMappingManager manager) {
        this(connection, null, dialect, metadata, manager);
    }

    public JdbcImpl(Connection connection, Isolation defaultIsolation, Dialect dialect, DatabaseMetadata metadata, SqlTypeMappingManager manager) {
        super(dialect, metadata, manager);
        this.connection = connection;
        if (defaultIsolation != null) {
            this.defaultIsolation = defaultIsolation;
        }
    }

    @Override
    protected void releaseConnection(Connection connection) {
    }

    @Override
    protected Connection getConnection() {
        return this.connection;
    }

    @Override
    public JdbcTransaction beginTransation() {
        return this.beginTransation(this.defaultIsolation);
    }

    @Override
    public JdbcTransaction beginTransation(Isolation isolation) {
        try {
            this.connection.setTransactionIsolation(isolation.value());
            this.connection.setAutoCommit(false);
            return new JdbcTransactionImpl(this.connection.setSavepoint(), this.connection);
        }
        catch (SQLException e) {
            throw new JdbcException((Throwable)e);
        }
    }

    @Override
    public void close() {
        JdbcUtils.close((Connection)this.connection);
    }
}

