/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.hammer.sqldb.jdbc.GeneratedKeyHolder;
import cn.featherfly.hammer.sqldb.jdbc.JdbcProcedure;
import cn.featherfly.hammer.sqldb.jdbc.JdbcQuery;
import cn.featherfly.hammer.sqldb.jdbc.JdbcQueryProcessSingle;
import cn.featherfly.hammer.sqldb.jdbc.JdbcUpdate;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public interface Jdbc
extends JdbcQuery,
JdbcProcedure,
JdbcUpdate,
JdbcQueryProcessSingle {
    public Dialect getDialect();

    public SqlTypeMappingManager getSqlTypeMappingManager();

    default public int insert(String tableName, String[] columnNames, Object ... args) {
        return this.insert(tableName, columnNames, null, args);
    }

    public <T extends Serializable> int insert(String var1, String[] var2, GeneratedKeyHolder<T> var3, Object ... var4);

    default public int insert(String tableName, Map<String, Object> columnParams) {
        return this.insert(tableName, columnParams, null);
    }

    default public <T extends Serializable> int insert(String tableName, Map<String, Object> columnParams, GeneratedKeyHolder<T> keyHolder) {
        int i = 0;
        String[] columns = new String[columnParams.size()];
        Object[] params = new Object[columnParams.size()];
        for (Map.Entry<String, Object> entry : columnParams.entrySet()) {
            columns[i] = entry.getKey();
            params[i] = entry.getValue();
            ++i;
        }
        return this.insert(tableName, columns, keyHolder, params);
    }

    default public int insertBatch(String tableName, String[] columnNames, Object ... args) {
        if (args.length % columnNames.length != 0) {
            throw new JdbcException("batch size is not explicit (args.length % columnNames.length != 0)");
        }
        return this.insertBatch(tableName, columnNames, args.length / columnNames.length, args);
    }

    default public int insertBatch(String tableName, List<Map<String, Object>> columnParams) {
        if (Lang.isEmpty(columnParams)) {
            return 0;
        }
        int columnLen = columnParams.get(0).size();
        int paramLen = columnLen * columnParams.size();
        String[] columns = new String[columnLen];
        Object[] params = new Object[paramLen];
        Lang.each(columnParams.get(0).entrySet(), (entry, index) -> {
            columns[index] = (String)entry.getKey();
        });
        int i = 0;
        for (Map<String, Object> cp : columnParams) {
            for (Map.Entry<String, Object> entry2 : cp.entrySet()) {
                params[i] = entry2.getValue();
                ++i;
            }
        }
        return this.insertBatch(tableName, columns, columnParams.size(), params);
    }

    public int insertBatch(String var1, String[] var2, int var3, Object ... var4);

    default public int upsert(String tableName, String[] columnNames, String uniqueColumn, Object ... args) {
        return this.upsert(tableName, columnNames, new String[]{uniqueColumn}, args);
    }

    public int upsert(String var1, String[] var2, String[] var3, Object ... var4);

    default public int upsert(String tableName, String uniqueColumn, Map<String, Object> params) {
        return this.upsert(tableName, new String[]{uniqueColumn}, params);
    }

    default public int upsert(String tableName, String[] uniqueColumns, Map<String, Object> params) {
        Object[] ps = new Object[params.size()];
        String[] columnNames = new String[params.size()];
        int i = 0;
        for (Map.Entry<String, Object> e : params.entrySet()) {
            columnNames[i] = e.getKey();
            ps[i] = e.getValue();
            ++i;
        }
        return this.upsert(tableName, columnNames, uniqueColumns, ps);
    }
}

