/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.repository.query.relation;

import cn.featherfly.common.db.Column;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.repository.AliasRepository;
import cn.featherfly.common.repository.Repository;
import cn.featherfly.hammer.dsl.repository.RepositoryOnExpression;
import cn.featherfly.hammer.expression.repository.query.RepositoryQueryRelateExpression;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.dsl.repository.RepositorySqlQueryRelation;
import cn.featherfly.hammer.sqldb.dsl.repository.RepositorySqlRelation;
import java.util.List;
import java.util.function.Consumer;

public class AbstractRepositorySqlQueryOn<Q extends RepositoryQueryRelateExpression<F>, F>
implements RepositoryOnExpression<Q> {
    protected final Q queryRelate;
    protected final RepositorySqlQueryRelation queryRelation;
    protected final String joinRepository;
    protected final String joinRepositoryAlias;
    protected final Consumer<Q> onConsumer;

    public AbstractRepositorySqlQueryOn(Q queryRelate, RepositorySqlQueryRelation queryRelation, String joinRepository) {
        this(queryRelate, queryRelation, joinRepository, null);
    }

    public AbstractRepositorySqlQueryOn(Q queryRelate, RepositorySqlQueryRelation queryRelation, String joinRepository, Consumer<Q> onConsumer) {
        this(queryRelate, queryRelation, joinRepository, null, onConsumer);
    }

    public AbstractRepositorySqlQueryOn(Q queryRelate, RepositorySqlQueryRelation queryRelation, Repository repository, Consumer<Q> onConsumer) {
        this(queryRelate, queryRelation, repository.name(), repository instanceof AliasRepository ? ((AliasRepository)repository).alias() : null, onConsumer);
    }

    public AbstractRepositorySqlQueryOn(Q queryRelate, RepositorySqlQueryRelation queryRelation, String joinRepository, String joinRepositoryAlias, Consumer<Q> onConsumer) {
        this.queryRelation = queryRelation;
        this.queryRelate = queryRelate;
        this.joinRepository = joinRepository;
        this.joinRepositoryAlias = joinRepositoryAlias;
        this.onConsumer = onConsumer == null ? q -> {} : onConsumer;
    }

    public Q on(String joinRepositoryField, String sourceRepositoryField) {
        AssertIllegalArgument.isNotNull((Object)joinRepositoryField, (String)"joinRepositoryField");
        if (Lang.isEmpty((String)sourceRepositoryField)) {
            RepositorySqlRelation.RepositoryRelation relation = this.queryRelation.getRepositoryRelation(0);
            List pkList = this.queryRelation.getMetadata().getTable(relation.getRepository()).getPrimaryColumns();
            if (pkList.size() == 1) {
                return this.on(joinRepositoryField, ((Column)pkList.get(0)).getName());
            }
            throw new SqldbHammerException(Strings.format((String)"only support one primary key, but more than one primary key found {0}", (Object)pkList.size()));
        }
        this.queryRelation.join(0, sourceRepositoryField, this.joinRepository, this.joinRepositoryAlias, joinRepositoryField);
        this.onConsumer.accept(this.queryRelate);
        return this.queryRelate;
    }
}

