/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.repository.query;

import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.db.builder.dml.SqlSortBuilder;
import cn.featherfly.common.db.builder.dml.basic.SqlSelectBasicBuilder;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.operator.AggregateFunction;
import cn.featherfly.common.repository.builder.dml.SortBuilder;
import cn.featherfly.common.repository.mapping.RowMapper;
import cn.featherfly.common.structure.page.Limit;
import cn.featherfly.common.structure.page.PaginationResults;
import cn.featherfly.common.structure.page.SimplePaginationResults;
import cn.featherfly.hammer.config.dsl.QueryConditionConfig;
import cn.featherfly.hammer.dsl.repository.query.RepositoryQueryValueConditionsGroup;
import cn.featherfly.hammer.dsl.repository.query.RepositoryQueryValueConditionsGroupLogic;
import cn.featherfly.hammer.expression.query.QueryValueLimitExecutor;
import cn.featherfly.hammer.expression.repository.query.RepositoryQueryValueSortExpression;
import cn.featherfly.hammer.expression.repository.query.RepositoryQueryValueSortedExpression;
import cn.featherfly.hammer.sqldb.dsl.repository.AbstractMulitiRepositorySqlConditionsGroupExpressionBase;
import cn.featherfly.hammer.sqldb.dsl.repository.RepositorySqlQueryRelation;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.SqlPageFactory;
import com.speedment.common.tuple.Tuple1;
import com.speedment.common.tuple.Tuples;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class AbstractMulitiRepositorySqlQueryValueConditionsGroupExpression
extends AbstractMulitiRepositorySqlConditionsGroupExpressionBase<RepositoryQueryValueConditionsGroup, RepositoryQueryValueConditionsGroupLogic, Tuple1<Integer>, QueryConditionConfig, RepositorySqlQueryRelation, SqlSelectBasicBuilder>
implements RepositoryQueryValueConditionsGroup,
RepositoryQueryValueConditionsGroupLogic,
RepositoryQueryValueSortExpression,
RepositoryQueryValueSortedExpression {
    private SqlSortBuilder sortBuilder;
    private Limit limit;
    protected SqlPageFactory sqlPageFactory;
    protected final Jdbc jdbc;

    protected AbstractMulitiRepositorySqlQueryValueConditionsGroupExpression(int index, RepositorySqlQueryRelation queryRelation, SqlPageFactory sqlPageFactory) {
        this(null, index, queryRelation, sqlPageFactory);
    }

    protected AbstractMulitiRepositorySqlQueryValueConditionsGroupExpression(RepositoryQueryValueConditionsGroupLogic parent, int index, RepositorySqlQueryRelation queryRelation, SqlPageFactory sqlPageFactory) {
        super(parent, index, queryRelation);
        this.jdbc = queryRelation.getJdbc();
        this.sqlPageFactory = sqlPageFactory;
        if (parent == null) {
            this.sortBuilder = new SqlSortBuilder(this.dialect, this.repositoryAlias);
        }
    }

    public QueryValueLimitExecutor limit(Limit limit) {
        this.limit = limit;
        return this;
    }

    public long count() {
        ((RepositorySqlQueryRelation)this.repositoryRelation).getBuilder().clearColumns().addColumn(AggregateFunction.COUNT, "*");
        return ((RepositorySqlQueryRelation)this.repositoryRelation).getJdbc().queryLong(this.getRoot().expression(), this.getRoot().getParams().toArray());
    }

    public <E> List<E> list() {
        return this.list(Object.class);
    }

    public <E> List<E> list(Class<E> type) {
        String sql = this.getRoot().expression();
        Object[] params = this.getRoot().getParams().toArray();
        if (this.limit != null) {
            SqlPageFactory.SqlPageQuery<Object[]> pageQuery = this.sqlPageFactory.toPage(this.dialect, sql, (int)this.limit.getOffset(), (int)this.limit.getLimit(), params);
            sql = pageQuery.getSql();
            params = pageQuery.getParams();
        }
        return this.jdbc.query(sql, type, params);
    }

    public PaginationResults<Map<String, Object>> pagination() {
        String sql = this.getRoot().expression();
        String countSql = SqlUtils.convertSelectToCount((String)sql);
        Object[] params = this.getRoot().getParams().toArray();
        SimplePaginationResults pagination = new SimplePaginationResults(this.limit);
        if (this.limit != null) {
            SqlPageFactory.SqlPageQuery<Object[]> pageQuery = this.sqlPageFactory.toPage(this.dialect, sql, (int)this.limit.getOffset(), (int)this.limit.getLimit(), params);
            List<Map<String, Object>> list = this.jdbc.query(pageQuery.getSql(), pageQuery.getParams());
            pagination.setPageResults(list);
            int total = this.jdbc.queryInt(countSql, params);
            pagination.setTotal(Integer.valueOf(total));
        } else {
            List<Map<String, Object>> list = this.jdbc.query(sql, params);
            pagination.setPageResults(list);
            pagination.setTotal(Integer.valueOf(list.size()));
        }
        return pagination;
    }

    public <E> PaginationResults<E> pagination(Class<E> type) {
        String sql = this.getRoot().expression();
        String countSql = SqlUtils.convertSelectToCount((String)sql);
        Object[] params = this.getRoot().getParams().toArray();
        SimplePaginationResults pagination = new SimplePaginationResults(this.limit);
        if (this.limit != null) {
            SqlPageFactory.SqlPageQuery<Object[]> pageQuery = this.sqlPageFactory.toPage(this.dialect, sql, (int)this.limit.getOffset(), (int)this.limit.getLimit(), params);
            List<E> list = this.jdbc.query(pageQuery.getSql(), type, pageQuery.getParams());
            pagination.setPageResults(list);
            int total = this.jdbc.queryInt(countSql, params);
            pagination.setTotal(Integer.valueOf(total));
        } else {
            List<E> list = this.jdbc.query(sql, type, params);
            pagination.setPageResults(list);
            pagination.setTotal(Integer.valueOf(list.size()));
        }
        return pagination;
    }

    public <E> PaginationResults<E> pagination(RowMapper<E> rowMapper) {
        String sql = this.getRoot().expression();
        String countSql = SqlUtils.convertSelectToCount((String)sql);
        Object[] params = this.getRoot().getParams().toArray();
        SimplePaginationResults pagination = new SimplePaginationResults(this.limit);
        if (this.limit != null) {
            SqlPageFactory.SqlPageQuery<Object[]> pageQuery = this.sqlPageFactory.toPage(this.dialect, sql, (int)this.limit.getOffset(), (int)this.limit.getLimit(), params);
            List<E> list = this.jdbc.query(pageQuery.getSql(), rowMapper, pageQuery.getParams());
            pagination.setPageResults(list);
            int total = this.jdbc.queryInt(countSql, params);
            pagination.setTotal(Integer.valueOf(total));
        } else {
            List<E> list = this.jdbc.query(sql, rowMapper, params);
            pagination.setPageResults(list);
            pagination.setTotal(Integer.valueOf(list.size()));
        }
        return pagination;
    }

    public String string() {
        return this.jdbc.queryString(this.getRoot().expression(), this.getRoot().getParams().toArray());
    }

    public Date date() {
        return this.jdbc.queryValue(this.getRoot().expression(), Date.class, this.getRoot().getParams().toArray());
    }

    public LocalDate localDate() {
        return this.jdbc.queryValue(this.getRoot().expression(), LocalDate.class, this.getRoot().getParams().toArray());
    }

    public LocalDateTime localDateTime() {
        return this.jdbc.queryValue(this.getRoot().expression(), LocalDateTime.class, this.getRoot().getParams().toArray());
    }

    public LocalTime localTime() {
        return this.jdbc.queryValue(this.getRoot().expression(), LocalTime.class, this.getRoot().getParams().toArray());
    }

    public Timestamp timestamp() {
        return this.jdbc.queryValue(this.getRoot().expression(), Timestamp.class, this.getRoot().getParams().toArray());
    }

    public byte[] bytes() {
        return this.jdbc.queryBytes(this.getRoot().expression(), this.getRoot().getParams().toArray());
    }

    public Clob clob() {
        return this.jdbc.queryValue(this.getRoot().expression(), Clob.class, this.getRoot().getParams().toArray());
    }

    public Blob blob() {
        return this.jdbc.queryValue(this.getRoot().expression(), Blob.class, this.getRoot().getParams().toArray());
    }

    public boolean bool() {
        return this.jdbc.queryBool(this.getRoot().expression(), this.getRoot().getParams().toArray());
    }

    public byte byteValue() {
        return this.jdbc.queryByte(this.getRoot().expression(), this.getRoot().getParams().toArray());
    }

    public short shortValue() {
        return this.jdbc.queryShort(this.getRoot().expression(), this.getRoot().getParams().toArray());
    }

    public int intValue() {
        return this.jdbc.queryInt(this.getRoot().expression(), this.getRoot().getParams().toArray());
    }

    public long longValue() {
        return this.jdbc.queryLong(this.getRoot().expression(), this.getRoot().getParams().toArray());
    }

    public double doubleValue() {
        return this.jdbc.queryDouble(this.getRoot().expression(), this.getRoot().getParams().toArray());
    }

    public <T> T value(Class<T> type) {
        return this.jdbc.queryValue(this.getRoot().expression(), type, this.getRoot().getParams().toArray());
    }

    public <T> T value() {
        return this.jdbc.queryValue(this.getRoot().expression(), this.getRoot().getParams().toArray());
    }

    public <T> T single(Class<T> type) {
        return this.jdbc.querySingle(this.getRoot().expression(), type, this.getRoot().getParams().toArray());
    }

    public <T> T single() {
        return (T)this.single(Object.class);
    }

    public <T> T unique(Class<T> type) {
        return this.jdbc.queryUnique(this.getRoot().expression(), type, this.getRoot().getParams().toArray());
    }

    public <T> T unique() {
        return (T)this.unique(Object.class);
    }

    public RepositoryQueryValueSortExpression sort() {
        return this;
    }

    public RepositoryQueryValueSortedExpression asc(String ... names) {
        this.getRootSortBuilder().asc(names);
        return this;
    }

    public RepositoryQueryValueSortedExpression desc(String ... names) {
        this.getRootSortBuilder().desc(names);
        return this;
    }

    @Override
    protected Tuple1<Integer> createTuple() {
        return Tuples.of((Object)0);
    }

    protected SortBuilder getRootSortBuilder() {
        return ((AbstractMulitiRepositorySqlQueryValueConditionsGroupExpression)this.getRoot()).sortBuilder;
    }

    @Override
    public String expression() {
        String condition = super.expression();
        if (this.parent == null) {
            String result = ((RepositorySqlQueryRelation)this.repositoryRelation).buildSelectSql();
            String sort = this.getRootSortBuilder().build();
            if (Lang.isEmpty((String)condition)) {
                return result + " " + sort;
            }
            return result + " " + this.dialect.getKeywords().where() + " " + condition + " " + sort;
        }
        return condition;
    }
}

