/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.repository.condition.field;

import cn.featherfly.common.db.builder.model.ColumnElement;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.Field;
import cn.featherfly.hammer.expression.condition.ConditionExpression;
import cn.featherfly.hammer.expression.condition.Expression;
import cn.featherfly.hammer.expression.condition.LogicExpression;
import cn.featherfly.hammer.expression.condition.field.FieldExpression;
import cn.featherfly.hammer.sqldb.dsl.condition.InternalMulitiCondition;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractMulitiRepositoryFieldExpression<C extends ConditionExpression, L extends LogicExpression<C, L>>
implements Expression {
    protected AtomicInteger index;
    protected String name;
    protected InternalMulitiCondition<L> expression;

    protected AbstractMulitiRepositoryFieldExpression(int index, String name, InternalMulitiCondition<L> expression) {
        this(new AtomicInteger(index), name, expression);
    }

    protected AbstractMulitiRepositoryFieldExpression(AtomicInteger index, String name, InternalMulitiCondition<L> expression) {
        this.index = index;
        this.name = name;
        this.expression = expression;
    }

    public String expression() {
        String expr = this.expression.expression();
        if (Lang.isEmpty((String)expr) && this.name != null) {
            return new ColumnElement(this.expression.getJdbc().getDialect(), this.name, this.expression.getAlias(this.index.intValue())).toSql();
        }
        return expr;
    }

    public L eq(Field field) {
        return (L)((LogicExpression)this.expression.eq(this.index, this.name, field, this.expression.getIgnoreStrategy()));
    }

    public L eq(FieldExpression fieldExpression) {
        return (L)((LogicExpression)this.expression.eq(this.index, this.name, fieldExpression, this.expression.getIgnoreStrategy()));
    }
}

