/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.repository;

import cn.featherfly.common.db.Column;
import cn.featherfly.common.db.builder.dml.basic.SqlJoinOnBuilder;
import cn.featherfly.common.db.builder.dml.basic.SqlSelectBasicBuilder;
import cn.featherfly.common.db.builder.dml.basic.SqlSelectJoinOnBasicBuilder;
import cn.featherfly.common.db.dialect.Join;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.exception.NotImplementedException;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.operator.AggregateFunction;
import cn.featherfly.common.repository.builder.AliasManager;
import cn.featherfly.hammer.config.dsl.ConditionConfig;
import cn.featherfly.hammer.config.dsl.QueryConfig;
import cn.featherfly.hammer.expression.condition.Expression;
import cn.featherfly.hammer.sqldb.dsl.repository.RepositorySqlRelation;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class RepositorySqlQueryRelation
extends RepositorySqlRelation<RepositorySqlQueryRelation, SqlSelectBasicBuilder> {
    private SqlSelectBasicBuilder selectBuilder;
    private Map<Integer, RepositorySqlRelation.RepositoryRelation> repositoryQueryFetchMapping = new HashMap<Integer, RepositorySqlRelation.RepositoryRelation>();
    private Set<String> queryFetchAlias = new HashSet<String>();

    public RepositorySqlQueryRelation(Jdbc jdbc, AliasManager aliasManager, DatabaseMetadata metadata, QueryConfig queryConfig) {
        super(jdbc, aliasManager, metadata, (ConditionConfig<?>)queryConfig);
    }

    public RepositorySqlQueryRelation query(String repository) {
        return (RepositorySqlQueryRelation)this.addFilterable(repository);
    }

    public RepositorySqlQueryRelation query(String repository, String alias) {
        return (RepositorySqlQueryRelation)this.addFilterable(repository, alias);
    }

    @Override
    public RepositorySqlQueryRelation join(String joinRepository, Supplier<Expression> onExpression) {
        SqlSelectJoinOnBasicBuilder selectJoinOnBasicBuilder;
        AssertIllegalArgument.isNotNull((Object)joinRepository, (String)"joinRepository");
        this.addFilterable(joinRepository);
        RepositorySqlRelation.RepositoryRelation jerm = this.getRepositoryRelation(this.index - 1);
        jerm.selectJoinOnBasicBuilder = selectJoinOnBasicBuilder = this.join0(jerm.getRepository(), jerm.getRepositoryAlias(), onExpression.get().expression());
        return this;
    }

    @Override
    public RepositorySqlQueryRelation join(int sourceIndex, String sourceField, String joinRepository, String joinRepositoryAlias, String joinField) {
        SqlSelectJoinOnBasicBuilder selectJoinOnBasicBuilder;
        AssertIllegalArgument.isNotNull((Object)joinRepository, (String)"joinRepository");
        if (Lang.isEmpty((String)joinField)) {
            List pks = this.metadata.getTable(joinRepository).getPrimaryColumns();
            if (pks.size() == 1) {
                joinField = ((Column)pks.get(0)).getName();
            } else {
                AssertIllegalArgument.isNotNull((Object)joinField, (String)"joinField");
            }
        }
        RepositorySqlRelation.RepositoryRelation erm = this.getRepositoryRelation(sourceIndex);
        if (Lang.isEmpty((String)sourceField)) {
            List pks = this.metadata.getTable(erm.getRepository()).getPrimaryColumns();
            if (pks.size() == 1) {
                sourceField = ((Column)pks.get(0)).getName();
            } else {
                AssertIllegalArgument.isNotNull((Object)sourceField, (String)"sourceField");
            }
        }
        this.addFilterable(sourceIndex, sourceField, joinRepository, joinRepositoryAlias, joinField);
        RepositorySqlRelation.RepositoryRelation jerm = this.getRepositoryRelation(this.index - 1);
        jerm.selectJoinOnBasicBuilder = selectJoinOnBasicBuilder = this.join0(erm.getRepositoryAlias(), sourceField, jerm.getRepository(), jerm.getRepositoryAlias(), jerm.getField());
        return this;
    }

    private SqlSelectJoinOnBasicBuilder join0(String sourceTableAlias, String sourceColumn, String joinTable, String joinTableAlias, String joinTableColumn) {
        return this.getBuilder().join(Join.INNER_JOIN, this.metadata.getTable(joinTable), joinTableAlias, joinTableColumn, sourceTableAlias, sourceColumn);
    }

    private SqlSelectJoinOnBasicBuilder join0(String joinTable, String joinTableAlias, String onSql) {
        return this.getBuilder().join(Join.INNER_JOIN, this.metadata.getTable(joinTable), joinTableAlias, onSql);
    }

    @Override
    protected RepositorySqlQueryRelation join(SqlJoinOnBuilder joinOnBuilder) {
        throw new NotImplementedException();
    }

    public RepositorySqlQueryRelation fetch(int index) {
        this.checkIndex(index);
        RepositorySqlRelation.RepositoryRelation erm = this.getRepositoryRelation(index);
        this.repositoryQueryFetchMapping.put(this.repositoryQueryFetchMapping.size(), erm);
        this.queryFetchAlias.add(erm.getRepositoryAlias());
        if (index > 0) {
            erm.selectJoinOnBasicBuilder.fetch();
        }
        return this;
    }

    public RepositorySqlQueryRelation fetch(int index, String ... fields) {
        this.checkIndex(index);
        RepositorySqlRelation.RepositoryRelation erm = this.getRepositoryRelation(index);
        this.repositoryQueryFetchMapping.put(this.repositoryQueryFetchMapping.size(), erm);
        this.queryFetchAlias.add(erm.getRepositoryAlias());
        if (index > 0) {
            erm.selectJoinOnBasicBuilder.addColumns(fields);
        }
        return this;
    }

    public RepositorySqlQueryRelation fetch(int index, Map<String, String> fields) {
        this.checkIndex(index);
        RepositorySqlRelation.RepositoryRelation erm = this.getRepositoryRelation(index);
        this.repositoryQueryFetchMapping.put(this.repositoryQueryFetchMapping.size(), erm);
        this.queryFetchAlias.add(erm.getRepositoryAlias());
        if (index > 0) {
            for (Map.Entry<String, String> entry : fields.entrySet()) {
                erm.selectJoinOnBasicBuilder.addColumn(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public RepositorySqlQueryRelation fetch(int index, String field) {
        return this.fetch(index, false, field);
    }

    public RepositorySqlQueryRelation fetch(int index, boolean distinct, String field) {
        return this.fetch(index, distinct, field, null);
    }

    public RepositorySqlQueryRelation fetch(int index, boolean distinct, String field, String alias) {
        this.checkIndex(index);
        RepositorySqlRelation.RepositoryRelation erm = this.getRepositoryRelation(index);
        this.repositoryQueryFetchMapping.put(this.repositoryQueryFetchMapping.size(), erm);
        this.queryFetchAlias.add(erm.getRepositoryAlias());
        if (index > 0) {
            erm.selectJoinOnBasicBuilder.addColumn(distinct, field, alias);
        }
        return this;
    }

    public RepositorySqlQueryRelation fetch(int index, AggregateFunction aggregateFunction, String field) {
        return this.fetch(index, aggregateFunction, field, null);
    }

    public RepositorySqlQueryRelation fetch(int index, AggregateFunction aggregateFunction, String field, String alias) {
        return this.fetch(index, aggregateFunction, false, field, alias);
    }

    public RepositorySqlQueryRelation fetch(int index, AggregateFunction aggregateFunction, boolean distinct, String field, String alias) {
        this.checkIndex(index);
        RepositorySqlRelation.RepositoryRelation erm = this.getRepositoryRelation(index);
        this.repositoryQueryFetchMapping.put(this.repositoryQueryFetchMapping.size(), erm);
        this.queryFetchAlias.add(erm.getRepositoryAlias());
        if (index > 0) {
            erm.selectJoinOnBasicBuilder.addColumn(aggregateFunction, distinct, field, alias);
        }
        return this;
    }

    public boolean isReturnTuple() {
        return this.repositoryQueryFetchMapping.size() > 1;
    }

    public String buildSelectSql() {
        return this.selectBuilder.setColumnAliasPrefixTableAlias(this.isReturnTuple()).build((tableName, tableAlias) -> this.queryFetchAlias.contains(tableAlias));
    }

    @Override
    protected void initBuilder(RepositorySqlRelation.RepositoryRelation erm) {
        this.selectBuilder = new SqlSelectBasicBuilder(this.jdbc.getDialect(), this.metadata.getTable(erm.getRepository()), erm.getRepositoryAlias());
    }

    @Override
    public SqlSelectBasicBuilder getBuilder() {
        return this.selectBuilder;
    }

    @Override
    public QueryConfig getConfig() {
        return (QueryConfig)this.conditionConfig;
    }
}

