/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.query;

import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.AliasRepository;
import cn.featherfly.common.repository.Repository;
import cn.featherfly.common.repository.builder.AliasManager;
import cn.featherfly.hammer.config.dsl.QueryConfig;
import cn.featherfly.hammer.dsl.entity.query.EntityQueryFetch;
import cn.featherfly.hammer.dsl.query.Query;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.dsl.entity.EntitySqlQueryRelation;
import cn.featherfly.hammer.sqldb.dsl.entity.query.EntitySqlQueryFetch;
import cn.featherfly.hammer.sqldb.dsl.repository.RepositorySqlQueryRelation;
import cn.featherfly.hammer.sqldb.dsl.repository.query.RepositorySqlQueryFetch;
import cn.featherfly.hammer.sqldb.dsl.repository.query.RepositorySqlQueryFetchImpl;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.SqlPageFactory;

public class SqlQuery
implements Query {
    private Jdbc jdbc;
    private DatabaseMetadata databaseMetadata;
    private JdbcMappingFactory mappingFactory;
    private SqlPageFactory sqlPageFactory;
    private QueryConfig queryConfig;

    public SqlQuery(Jdbc jdbc, DatabaseMetadata databaseMetadata, SqlPageFactory sqlPageFactory, QueryConfig queryConfig) {
        this.jdbc = jdbc;
        this.databaseMetadata = databaseMetadata;
        this.sqlPageFactory = sqlPageFactory;
        this.queryConfig = queryConfig;
    }

    public SqlQuery(Jdbc jdbc, JdbcMappingFactory mappingFactory, SqlPageFactory sqlPageFactory, QueryConfig queryConfig) {
        this.jdbc = jdbc;
        this.mappingFactory = mappingFactory;
        this.databaseMetadata = mappingFactory.getMetadata();
        this.sqlPageFactory = sqlPageFactory;
        this.queryConfig = queryConfig;
    }

    public RepositorySqlQueryFetch find(Repository repository) {
        if (repository instanceof AliasRepository) {
            return this.find((AliasRepository)repository);
        }
        AssertIllegalArgument.isNotNull((Object)repository, (String)"repository");
        return this.find(repository.name());
    }

    public RepositorySqlQueryFetch find(AliasRepository repository) {
        AssertIllegalArgument.isNotNull((Object)repository, (String)"repository");
        return this.find(repository.name(), repository.alias());
    }

    public RepositorySqlQueryFetch find(String tableName) {
        return this.find(tableName, null);
    }

    public RepositorySqlQueryFetch find(String tableName, String tableAlias) {
        AssertIllegalArgument.isNotNull((Object)tableName, (String)"tableName");
        AliasManager aliasManager = new AliasManager();
        if (Lang.isNotEmpty((String)tableAlias)) {
            aliasManager.put(tableName, tableAlias);
        } else {
            tableAlias = aliasManager.put(tableName);
        }
        return new RepositorySqlQueryFetchImpl(new RepositorySqlQueryRelation(this.jdbc, aliasManager, this.databaseMetadata, (QueryConfig)this.queryConfig.clone()).query(tableName, tableAlias).fetch(0), this.sqlPageFactory);
    }

    public <E> EntityQueryFetch<E> find(Class<E> entity) {
        if (this.mappingFactory == null) {
            throw new SqldbHammerException("mappingFactory is null");
        }
        JdbcClassMapping mapping = this.mappingFactory.getClassMapping(entity);
        EntitySqlQueryRelation queryRelation = new EntitySqlQueryRelation(this.jdbc, new AliasManager(), (QueryConfig)this.queryConfig.clone());
        return new EntitySqlQueryFetch(this.mappingFactory, this.sqlPageFactory, queryRelation, mapping);
    }
}

