/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.query;

import cn.featherfly.common.db.builder.dml.basic.SqlSelectBasicBuilder;
import cn.featherfly.common.db.builder.dml.basic.SqlSelectJoinOnBasicBuilder;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.hammer.sqldb.SqldbHammerException;

public class EntitySqlQueryRelationPart<R1, R2> {
    private SqlSelectBasicBuilder selectBuilder;
    protected String conditionTableAlias;
    protected String conditionTableColumn;
    protected String joinTableAlias;
    protected String joinTableColumn;
    protected SqlSelectJoinOnBasicBuilder selectJoinOnBasicBuilder;
    protected JdbcClassMapping<R1> conditionTypeClassMapping;
    protected JdbcClassMapping<R2> joinTypeClassMapping;
    protected String fetchProperty;

    public EntitySqlQueryRelationPart(SqlSelectBasicBuilder selectBuilder, JdbcClassMapping<R1> conditionTypeClassMapping, String conditionTableAlias, String conditionTableColumn, JdbcClassMapping<R2> joinTypeClassMapping, String joinTableColumn, String joinTableAlias, String fetchProperty) {
        AssertIllegalArgument.isNotNull((Object)selectBuilder, (String)"selectBuilder");
        this.selectBuilder = selectBuilder;
        this.conditionTypeClassMapping = conditionTypeClassMapping;
        this.conditionTableAlias = conditionTableAlias;
        this.conditionTableColumn = conditionTableColumn;
        this.joinTableAlias = joinTableAlias;
        this.joinTableColumn = joinTableColumn;
        this.joinTypeClassMapping = joinTypeClassMapping;
        this.fetchProperty = fetchProperty;
        this.on();
    }

    public EntitySqlQueryRelationPart<R1, R2> on() {
        this.selectJoinOnBasicBuilder = this.selectBuilder.join(this.conditionTableAlias, this.conditionTableColumn, this.joinTypeClassMapping, this.joinTableAlias, this.joinTableColumn);
        return this;
    }

    public void fetch() {
        if (Lang.isEmpty((String)this.fetchProperty)) {
            throw new SqldbHammerException("can not fetch because there is no relation for find type");
        }
        block4: for (JdbcPropertyMapping pm : this.joinTypeClassMapping.getPropertyMappings()) {
            if (pm.isPrimaryKey()) continue;
            switch (pm.getMode()) {
                case EMBEDDED: {
                    for (JdbcPropertyMapping spm : pm.getPropertyMappings()) {
                        this.selectJoinOnBasicBuilder.addColumn(spm.getRepositoryFieldName(), this.fetchProperty + "." + spm.getPropertyFullName());
                    }
                    continue block4;
                }
                case MANY_TO_ONE: {
                    for (JdbcPropertyMapping spm : pm.getPropertyMappings()) {
                        this.selectJoinOnBasicBuilder.addColumn(pm.getRepositoryFieldName(), this.fetchProperty + "." + spm.getPropertyFullName());
                    }
                    continue block4;
                }
                default: {
                    this.selectJoinOnBasicBuilder.addColumn(pm.getRepositoryFieldName(), this.fetchProperty + "." + pm.getPropertyFullName());
                }
            }
        }
    }
}

