/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.execute;

import cn.featherfly.common.db.Table;
import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.common.repository.AliasRepository;
import cn.featherfly.common.repository.Repository;
import cn.featherfly.hammer.config.dsl.DeleteConfig;
import cn.featherfly.hammer.dsl.entity.execute.EntityDelete;
import cn.featherfly.hammer.dsl.execute.Deleter;
import cn.featherfly.hammer.dsl.repository.execute.RepositoryDelete;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.dsl.entity.execute.EntitySqlDelete;
import cn.featherfly.hammer.sqldb.dsl.repository.execute.RepositorySqlDelete;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;

public class SqlDeleter
implements Deleter {
    private Jdbc jdbc;
    private JdbcMappingFactory mappingFactory;
    private DeleteConfig deleteConfig;

    public SqlDeleter(Jdbc jdbc, JdbcMappingFactory mappingFactory, DeleteConfig deleteConfig) {
        this.jdbc = jdbc;
        this.mappingFactory = mappingFactory;
        this.deleteConfig = deleteConfig;
    }

    public RepositoryDelete delete(Table table) {
        return this.delete(table.getName());
    }

    public RepositoryDelete delete(Repository repository) {
        if (repository instanceof AliasRepository) {
            return new RepositorySqlDelete(this.jdbc, (AliasRepository)repository, this.mappingFactory.getMetadata(), this.deleteConfig);
        }
        return new RepositorySqlDelete(this.jdbc, repository, this.mappingFactory.getMetadata(), this.deleteConfig);
    }

    public RepositoryDelete delete(String repository) {
        return new RepositorySqlDelete(this.jdbc, repository, this.mappingFactory.getMetadata(), this.deleteConfig);
    }

    public <E> EntityDelete<E> delete(Class<E> entityType) {
        if (this.mappingFactory == null) {
            throw new SqldbHammerException("mappingFactory is null");
        }
        return new EntitySqlDelete(this.jdbc, this.mappingFactory, this.mappingFactory.getClassMapping(entityType), this.deleteConfig);
    }
}

