/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.entity.query;

import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.db.builder.dml.SqlSortBuilder;
import cn.featherfly.common.db.builder.dml.basic.SqlSelectBasicBuilder;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.common.function.serializable.SerializableFunction;
import cn.featherfly.common.lang.LambdaUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.operator.AggregateFunction;
import cn.featherfly.common.repository.Execution;
import cn.featherfly.common.repository.SimpleExecution;
import cn.featherfly.common.repository.builder.dml.SortBuilder;
import cn.featherfly.common.structure.page.Limit;
import cn.featherfly.common.structure.page.PaginationResults;
import cn.featherfly.common.structure.page.SimplePaginationResults;
import cn.featherfly.hammer.config.dsl.QueryConditionConfig;
import cn.featherfly.hammer.expression.entity.query.EntityQueryValueConditionGroupExpression;
import cn.featherfly.hammer.expression.entity.query.EntityQueryValueConditionGroupLogicExpression;
import cn.featherfly.hammer.expression.entity.query.EntityQueryValueLimitExecutor;
import cn.featherfly.hammer.expression.entity.query.EntityQueryValueSortExpression;
import cn.featherfly.hammer.expression.entity.query.EntityQueryValueSortedExpression;
import cn.featherfly.hammer.sqldb.dsl.entity.AbstractMulitiEntitySqlConditionsGroupExpressionBase;
import cn.featherfly.hammer.sqldb.dsl.entity.EntitySqlQueryRelation;
import cn.featherfly.hammer.sqldb.dsl.entity.EntitySqlRelation;
import cn.featherfly.hammer.sqldb.jdbc.SqlPageFactory;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractMulitiEntitySqlQueryValueConditionsGroupExpression<E, V, C extends EntityQueryValueConditionGroupExpression<E, V, C, L, EntityQueryValueSortExpression<E, V>>, L extends EntityQueryValueConditionGroupLogicExpression<E, V, C, L, EntityQueryValueSortExpression<E, V>>>
extends AbstractMulitiEntitySqlConditionsGroupExpressionBase<E, C, L, QueryConditionConfig, EntitySqlQueryRelation, SqlSelectBasicBuilder>
implements EntityQueryValueConditionGroupExpression<E, V, C, L, EntityQueryValueSortExpression<E, V>>,
EntityQueryValueConditionGroupLogicExpression<E, V, C, L, EntityQueryValueSortExpression<E, V>>,
EntityQueryValueSortExpression<E, V>,
EntityQueryValueSortedExpression<E, V> {
    private Limit limit;
    private SqlSortBuilder sortBuilder;
    protected SqlPageFactory sqlPageFactory;
    protected final Class<E> queryType;
    protected final Class<V> valueType;

    protected AbstractMulitiEntitySqlQueryValueConditionsGroupExpression(L parent, JdbcMappingFactory factory, SqlPageFactory sqlPageFactory, EntitySqlQueryRelation queryRelation, Class<V> valueType) {
        super(parent, factory, queryRelation);
        this.sqlPageFactory = sqlPageFactory;
        this.valueType = valueType;
        this.queryType = ((EntitySqlRelation.EntityRelation)queryRelation.getEntityRelationTuple().get0().get()).getClassMapping().getType();
        this.sortBuilder = new SqlSortBuilder(this.dialect, queryRelation.getEntityRelation(0).getTableAlias());
    }

    @Override
    public String expression() {
        StringBuilder result = new StringBuilder(super.expression());
        String sort = this.sortBuilder.build();
        if (result.length() > 0) {
            if (Lang.isNotEmpty((String)sort)) {
                return result.append(" ").append(sort).toString();
            }
            return result.toString();
        }
        return sort;
    }

    public EntityQueryValueLimitExecutor<E, V> limit(Limit limit) {
        this.limit = limit;
        return this;
    }

    public long count() {
        ((EntitySqlQueryRelation)this.entityRelation).getBuilder().clearColumns().addColumn(AggregateFunction.COUNT, "*");
        return ((EntitySqlQueryRelation)this.entityRelation).getJdbc().queryLong(this.getRoot().expression(), this.getRoot().getParams().toArray());
    }

    public List<E> list() {
        Execution execution = this.getExecution();
        return ((EntitySqlQueryRelation)this.entityRelation).getJdbc().query(execution.getExecution(), this.queryType, execution.getParams());
    }

    public PaginationResults<E> pagination() {
        String sql = this.getRoot().expression();
        String countSql = SqlUtils.convertSelectToCount((String)sql);
        Object[] params = this.getRoot().getParams().toArray();
        SimplePaginationResults pagination = new SimplePaginationResults(this.limit);
        if (this.limit != null) {
            SqlPageFactory.SqlPageQuery<Object[]> pageQuery = this.sqlPageFactory.toPage(this.dialect, sql, (int)this.limit.getOffset(), (int)this.limit.getLimit(), params);
            List<E> list = ((EntitySqlQueryRelation)this.entityRelation).getJdbc().query(pageQuery.getSql(), this.queryType, pageQuery.getParams());
            pagination.setPageResults(list);
            int total = ((EntitySqlQueryRelation)this.entityRelation).getJdbc().queryInt(countSql, params);
            pagination.setTotal(Integer.valueOf(total));
        } else {
            List<E> list = ((EntitySqlQueryRelation)this.entityRelation).getJdbc().query(sql, this.queryType, params);
            pagination.setPageResults(list);
            pagination.setTotal(Integer.valueOf(list.size()));
        }
        return pagination;
    }

    public E single() {
        Execution execution = this.getExecution();
        return ((EntitySqlQueryRelation)this.entityRelation).getJdbc().querySingle(execution.getExecution(), this.queryType, execution.getParams());
    }

    public E unique() {
        Execution execution = this.getExecution();
        return ((EntitySqlQueryRelation)this.entityRelation).getJdbc().queryUnique(execution.getExecution(), this.queryType, execution.getParams());
    }

    public PaginationResults<V> valuePagination() {
        String sql = this.getRoot().expression();
        String countSql = SqlUtils.convertSelectToCount((String)sql);
        Object[] params = this.getRoot().getParams().toArray();
        SimplePaginationResults pagination = new SimplePaginationResults(this.limit);
        if (this.limit != null) {
            SqlPageFactory.SqlPageQuery<Object[]> pageQuery = this.sqlPageFactory.toPage(this.dialect, sql, (int)this.limit.getOffset(), (int)this.limit.getLimit(), params);
            List<V> list = ((EntitySqlQueryRelation)this.entityRelation).getJdbc().query(pageQuery.getSql(), this.valueType, pageQuery.getParams());
            pagination.setPageResults(list);
            int total = ((EntitySqlQueryRelation)this.entityRelation).getJdbc().queryInt(countSql, params);
            pagination.setTotal(Integer.valueOf(total));
        } else {
            List<V> list = ((EntitySqlQueryRelation)this.entityRelation).getJdbc().query(sql, this.valueType, params);
            pagination.setPageResults(list);
            pagination.setTotal(Integer.valueOf(list.size()));
        }
        return pagination;
    }

    public V value() {
        Execution execution = this.getExecution();
        return ((EntitySqlQueryRelation)this.entityRelation).getJdbc().querySingle(execution.getExecution(), this.valueType, execution.getParams());
    }

    public List<V> valueList() {
        Execution execution = this.getExecution();
        return ((EntitySqlQueryRelation)this.entityRelation).getJdbc().query(execution.getExecution(), this.valueType, execution.getParams());
    }

    public EntityQueryValueSortExpression<E, V> sort() {
        return this;
    }

    public EntityQueryValueSortedExpression<E, V> asc(String ... names) {
        this.getRootSortBuilder().asc(ClassMappingUtils.getColumnNames((JdbcClassMapping)this.classMapping, (String[])names));
        return this;
    }

    public EntityQueryValueSortedExpression<E, V> asc(List<String> names) {
        this.getRootSortBuilder().asc(ClassMappingUtils.getColumnNames((JdbcClassMapping)this.classMapping, names));
        return this;
    }

    public <R> EntityQueryValueSortedExpression<E, V> asc(SerializableFunction<E, R> name) {
        return this.asc(this.getPropertyName(name));
    }

    public EntityQueryValueSortedExpression<E, V> asc(SerializableFunction<E, ?> ... names) {
        String[] nameArray = (String[])Arrays.stream(names).map(LambdaUtils::getLambdaPropertyName).toArray(String[]::new);
        return this.asc(nameArray);
    }

    public EntityQueryValueSortedExpression<E, V> desc(String ... names) {
        this.getRootSortBuilder().desc(ClassMappingUtils.getColumnNames((JdbcClassMapping)this.classMapping, (String[])names));
        return this;
    }

    public EntityQueryValueSortedExpression<E, V> desc(List<String> names) {
        this.getRootSortBuilder().desc(ClassMappingUtils.getColumnNames((JdbcClassMapping)this.classMapping, names));
        return this;
    }

    public <R> EntityQueryValueSortedExpression<E, V> desc(SerializableFunction<E, R> name) {
        return this.desc(this.getPropertyName(name));
    }

    public EntityQueryValueSortedExpression<E, V> desc(SerializableFunction<E, ?> ... names) {
        String[] nameArray = (String[])Arrays.stream(names).map(LambdaUtils::getLambdaPropertyName).toArray(String[]::new);
        return this.desc(nameArray);
    }

    private SortBuilder getRootSortBuilder() {
        return ((AbstractMulitiEntitySqlQueryValueConditionsGroupExpression)this.getRoot()).sortBuilder;
    }

    private Execution getExecution() {
        String sql = this.getRoot().expression();
        Object[] params = this.getRoot().getParams().toArray();
        if (this.limit != null) {
            SqlPageFactory.SqlPageQuery<Object[]> pageQuery = this.sqlPageFactory.toPage(this.dialect, sql, (int)this.limit.getOffset(), (int)this.limit.getLimit(), params);
            sql = pageQuery.getSql();
            params = pageQuery.getParams();
        }
        return new SimpleExecution(sql, params);
    }
}

