/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.entity.query;

import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.repository.builder.AliasManager;
import cn.featherfly.common.structure.page.Limit;
import cn.featherfly.common.structure.page.PaginationResults;
import cn.featherfly.hammer.expression.entity.query.EntityQueryConditionLimit;
import cn.featherfly.hammer.expression.entity.query.EntityQueryLimitExecutor;
import cn.featherfly.hammer.expression.query.QueryCountExecutor;
import cn.featherfly.hammer.sqldb.dsl.entity.EntitySqlQueryRelation;
import cn.featherfly.hammer.sqldb.dsl.entity.query.EntitySqlQueryExpression;
import cn.featherfly.hammer.sqldb.dsl.repository.RepositorySqlQueryRelation;
import cn.featherfly.hammer.sqldb.dsl.repository.query.RepositorySqlQueryValueExpression;
import cn.featherfly.hammer.sqldb.jdbc.SqlPageFactory;
import java.util.List;

public abstract class AbstractEntitySqlQueryBase<E, L>
implements EntityQueryConditionLimit<L>,
EntityQueryLimitExecutor<E>,
QueryCountExecutor {
    protected final JdbcMappingFactory factory;
    protected final SqlPageFactory sqlPageFactory;
    protected final EntitySqlQueryRelation queryRelation;
    protected Limit limit;

    protected AbstractEntitySqlQueryBase(JdbcMappingFactory factory, SqlPageFactory sqlPageFactory, EntitySqlQueryRelation entitySqlQueryRelation) {
        AssertIllegalArgument.isNotNull((Object)entitySqlQueryRelation, (String)"entitySqlQueryRelation");
        this.queryRelation = entitySqlQueryRelation;
        this.factory = factory;
        this.sqlPageFactory = sqlPageFactory;
    }

    public L limit(Limit limit) {
        this.limit = limit;
        return (L)this;
    }

    public List<E> list() {
        return new EntitySqlQueryExpression(this.factory, this.sqlPageFactory, this.queryRelation).limit(this.limit).list();
    }

    public E single() {
        return (E)new EntitySqlQueryExpression(this.factory, this.sqlPageFactory, this.queryRelation).limit(this.limit).single();
    }

    public E unique() {
        return (E)new EntitySqlQueryExpression(this.factory, this.sqlPageFactory, this.queryRelation).limit(this.limit).unique();
    }

    public PaginationResults<E> pagination() {
        return new EntitySqlQueryExpression(this.factory, this.sqlPageFactory, this.queryRelation).limit(this.limit).pagination();
    }

    public long count() {
        return new RepositorySqlQueryValueExpression(new RepositorySqlQueryRelation(this.queryRelation.getJdbc(), new AliasManager(), this.factory.getMetadata(), this.queryRelation.getConfig()).query(this.queryRelation.getEntityRelation(0).getClassMapping().getRepositoryName()).fetch(0), this.sqlPageFactory).count();
    }
}

