/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.entity.condition;

import cn.featherfly.common.db.builder.model.ColumnElement;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.exception.NotImplementedException;
import cn.featherfly.common.exception.UnsupportedException;
import cn.featherfly.common.lang.LambdaUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.repository.Field;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.PropertyMapping;
import cn.featherfly.hammer.expression.condition.ConditionExpression;
import cn.featherfly.hammer.expression.condition.Expression;
import cn.featherfly.hammer.expression.condition.LogicExpression;
import cn.featherfly.hammer.expression.condition.field.FieldExpression;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.dsl.entity.EntitySqlRelation;
import cn.featherfly.hammer.sqldb.dsl.entity.condition.InternalMulitiEntityCondition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractMulitiEntityPropertyExpression<E, C extends ConditionExpression, L extends LogicExpression<C, L>>
implements Expression {
    protected AtomicInteger index;
    protected InternalMulitiEntityCondition<L> expression;
    protected JdbcMappingFactory factory;
    protected List<Serializable> propertyList = new ArrayList<Serializable>();
    protected EntitySqlRelation<?, ?> queryRelation;

    protected AbstractMulitiEntityPropertyExpression(AtomicInteger index, Serializable name, InternalMulitiEntityCondition<L> expression, JdbcMappingFactory factory, EntitySqlRelation<?, ?> queryRelation) {
        this(index, Lang.list((Object[])new Serializable[]{name}), expression, factory, queryRelation);
    }

    protected AbstractMulitiEntityPropertyExpression(AtomicInteger index, List<Serializable> propertyList, InternalMulitiEntityCondition<L> expression, JdbcMappingFactory factory, EntitySqlRelation<?, ?> queryRelation) {
        this.index = index;
        this.expression = expression;
        this.propertyList.addAll(propertyList);
        this.factory = factory;
        this.queryRelation = queryRelation;
    }

    public L eq(Field field) {
        return (L)((LogicExpression)this.expression.eq(this.index, this.getPropertyMapping(field), field, this.expression.getIgnoreStrategy()));
    }

    public L eq(FieldExpression expr) {
        return (L)((LogicExpression)this.expression.eq(this.index, this.getPropertyMapping(expr), expr, this.expression.getIgnoreStrategy()));
    }

    public String expression() {
        String expr = this.expression.expression();
        if (Lang.isEmpty((String)expr) && !this.propertyList.isEmpty()) {
            return new ColumnElement(this.expression.getJdbc().getDialect(), this.getPropertyMapping(this).getRepositoryFieldName(), this.expression.getAlias(this.index.intValue())).toSql();
        }
        return expr;
    }

    protected PropertyMapping<?> getPropertyMapping(Object value) {
        int index = this.index.get();
        if (this.propertyList.size() == 1) {
            ClassMapping classMapping = this.expression.getClassMapping(index);
            return classMapping.getPropertyMapping(LambdaUtils.getLambdaPropertyName((Serializable)this.propertyList.get(0)));
        }
        if (this.propertyList.size() == 2) {
            ClassMapping classMapping = this.expression.getClassMapping(index);
            JdbcPropertyMapping pm = (JdbcPropertyMapping)classMapping.getPropertyMapping(LambdaUtils.getLambdaPropertyName((Serializable)this.propertyList.get(0)));
            if (value == null) {
                return pm;
            }
            LambdaUtils.SerializedLambdaInfo propertyInfo = LambdaUtils.getLambdaInfo((Serializable)this.propertyList.get(1));
            String pn = propertyInfo.getPropertyName();
            if (pm.getMode() == PropertyMapping.Mode.EMBEDDED) {
                JdbcPropertyMapping spm = (JdbcPropertyMapping)pm.getPropertyMapping(pn);
                if (spm == null) {
                    throw new SqldbHammerException(Strings.format((String)"no property mapping found for {0}.{1}.{2}", (Object[])new Object[]{classMapping.getType().getSimpleName(), pm.getPropertyFullName(), pn}));
                }
                return spm;
            }
            if (PropertyMapping.Mode.MANY_TO_ONE == pm.getMode() || PropertyMapping.Mode.MANY_TO_ONE == pm.getMode()) {
                JdbcPropertyMapping spm = (JdbcPropertyMapping)pm.getPropertyMapping(pn);
                if (spm != null) {
                    return spm;
                }
                JdbcClassMapping cm = this.factory.getClassMapping(pm.getPropertyType());
                spm = (JdbcPropertyMapping)cm.getPropertyMapping(pn);
                if (spm != null) {
                    this.queryRelation.join(index, pm.getPropertyName(), cm);
                    this.index.incrementAndGet();
                    return spm;
                }
                throw new SqldbHammerException(Strings.format((String)"no property mapping found for {0}.{1}", (Object[])new Object[]{cm.getType().getSimpleName(), pn}));
            }
            if (pm.getMode() == PropertyMapping.Mode.ONE_TO_MANY) {
                throw new NotImplementedException();
            }
            if (pm.getMode() == PropertyMapping.Mode.SINGLE) {
                throw new NotImplementedException();
            }
            throw new UnsupportedException();
        }
        throw new NotImplementedException();
    }
}

