/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.entity;

import cn.featherfly.common.db.builder.SqlBuilder;
import cn.featherfly.common.db.builder.dml.basic.SqlSelectJoinOnBasicBuilder;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.repository.builder.AliasManager;
import cn.featherfly.hammer.config.dsl.ConditionConfig;
import cn.featherfly.hammer.expression.condition.Expression;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.dsl.query.SqlRelation;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import com.speedment.common.tuple.MutableTuples;
import com.speedment.common.tuple.mutable.MutableTuple9;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class EntitySqlRelation<R extends EntitySqlRelation<R, B>, B extends SqlBuilder>
implements SqlRelation<B> {
    protected Jdbc jdbc;
    protected AliasManager aliasManager;
    protected ConditionConfig<?> conditionConfig;
    protected int index;
    protected MutableTuple9<EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>> entityFilterableMappingTuple = MutableTuples.create9();
    protected final Set<String> joinedRelations = new HashSet<String>();

    protected EntitySqlRelation(Jdbc jdbc, AliasManager aliasManager, ConditionConfig<?> conditionConfig) {
        AssertIllegalArgument.isNotNull((Object)jdbc, (String)"jdbc");
        AssertIllegalArgument.isNotNull((Object)aliasManager, (String)"aliasManager");
        AssertIllegalArgument.isNotNull(conditionConfig, (String)"conditionConfig");
        this.jdbc = jdbc;
        this.aliasManager = aliasManager;
        this.conditionConfig = conditionConfig;
    }

    public R addFilterable(JdbcClassMapping<?> classMapping) {
        return this.addFilterable(0, null, classMapping, null);
    }

    public R addFilterable(int sourceIndex, String propertyName, JdbcClassMapping<?> joinClassMapping, String joinPropertyName) {
        AssertIllegalArgument.isGe((Number)this.index, (Number)0, (String)"entity index");
        AssertIllegalArgument.isLt((Number)this.index, (Number)this.entityFilterableMappingTuple.degree(), (String)"entity index");
        switch (this.index) {
            case 0: {
                EntityRelation<?> eqm = this.createEntityRelationMapping(sourceIndex, propertyName, joinClassMapping, joinPropertyName);
                this.entityFilterableMappingTuple.set0(eqm);
                this.initBuilder(eqm);
                break;
            }
            case 1: {
                this.entityFilterableMappingTuple.set1(this.createEntityRelationMapping(sourceIndex, propertyName, joinClassMapping, joinPropertyName));
                break;
            }
            case 2: {
                this.entityFilterableMappingTuple.set2(this.createEntityRelationMapping(sourceIndex, propertyName, joinClassMapping, joinPropertyName));
                break;
            }
            case 3: {
                this.entityFilterableMappingTuple.set3(this.createEntityRelationMapping(sourceIndex, propertyName, joinClassMapping, joinPropertyName));
                break;
            }
            case 4: {
                this.entityFilterableMappingTuple.set4(this.createEntityRelationMapping(sourceIndex, propertyName, joinClassMapping, joinPropertyName));
                break;
            }
            case 5: {
                this.entityFilterableMappingTuple.set5(this.createEntityRelationMapping(sourceIndex, propertyName, joinClassMapping, joinPropertyName));
                break;
            }
            case 6: {
                this.entityFilterableMappingTuple.set6(this.createEntityRelationMapping(sourceIndex, propertyName, joinClassMapping, joinPropertyName));
                break;
            }
            case 7: {
                this.entityFilterableMappingTuple.set7(this.createEntityRelationMapping(sourceIndex, propertyName, joinClassMapping, joinPropertyName));
                break;
            }
            case 8: {
                this.entityFilterableMappingTuple.set8(this.createEntityRelationMapping(sourceIndex, propertyName, joinClassMapping, joinPropertyName));
                break;
            }
        }
        ++this.index;
        return (R)this;
    }

    public R join(int sourceIndex, String propertyName, JdbcClassMapping<?> joinClassMapping) {
        return this.join(sourceIndex, propertyName, joinClassMapping, false);
    }

    public R join(int sourceIndex, String propertyName, JdbcClassMapping<?> joinClassMapping, boolean returnType) {
        if (joinClassMapping.getPrivaryKeyPropertyMappings().size() == 1) {
            return this.join(sourceIndex, propertyName, joinClassMapping, ((JdbcPropertyMapping)joinClassMapping.getPrivaryKeyPropertyMappings().get(0)).getRepositoryFieldName(), returnType);
        }
        throw new SqldbHammerException(Strings.format((String)"only support one privary key, but more than one privary key found {0}", (Object)joinClassMapping.getPrivaryKeyPropertyMappings().size()));
    }

    public R join(int sourceIndex, JdbcClassMapping<?> joinClassMapping, String joinPropertyName, boolean returnType) {
        EntityRelation<?> erm = this.getEntityRelation(sourceIndex);
        return this.join(sourceIndex, erm.getIdName(), joinClassMapping, joinPropertyName, returnType);
    }

    public R join(int sourceIndex, String propertyName, JdbcClassMapping<?> joinClassMapping, String joinPropertyName) {
        return this.join(sourceIndex, propertyName, joinClassMapping, joinPropertyName, true);
    }

    public abstract R join(int var1, String var2, JdbcClassMapping<?> var3, String var4, boolean var5);

    public abstract <T> EntitySqlRelation<?, ?> join(JdbcClassMapping<T> var1, Supplier<Expression> var2);

    protected abstract void initBuilder(EntityRelation<?> var1);

    @Override
    public Jdbc getJdbc() {
        return this.jdbc;
    }

    @Override
    public AliasManager getAliasManager() {
        return this.aliasManager;
    }

    @Override
    public Predicate<Object> getIgnoreStrategy() {
        return this.conditionConfig.getIgnoreStrategy();
    }

    public MutableTuple9<EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>> getEntityRelationTuple() {
        return this.entityFilterableMappingTuple;
    }

    public EntityRelation<?> getEntityRelation(int index) {
        switch (index) {
            case 0: {
                return (EntityRelation)this.entityFilterableMappingTuple.getOrNull0();
            }
            case 1: {
                return (EntityRelation)this.entityFilterableMappingTuple.getOrNull1();
            }
            case 2: {
                return (EntityRelation)this.entityFilterableMappingTuple.getOrNull2();
            }
            case 3: {
                return (EntityRelation)this.entityFilterableMappingTuple.getOrNull3();
            }
            case 4: {
                return (EntityRelation)this.entityFilterableMappingTuple.getOrNull4();
            }
            case 5: {
                return (EntityRelation)this.entityFilterableMappingTuple.getOrNull5();
            }
            case 6: {
                return (EntityRelation)this.entityFilterableMappingTuple.getOrNull6();
            }
            case 7: {
                return (EntityRelation)this.entityFilterableMappingTuple.getOrNull7();
            }
            case 8: {
                return (EntityRelation)this.entityFilterableMappingTuple.getOrNull8();
            }
        }
        throw new SqldbHammerException("entity query mapping index must be 0-8");
    }

    public EntityRelation<?>[] getFilterableEntityRelations() {
        return (EntityRelation[])this.entityFilterableMappingTuple.streamOf(EntityRelation.class).filter(r -> r != null).toArray(n -> new EntityRelation[this.index]);
    }

    protected <E> EntityRelation<E> createEntityRelationMapping(int sourceIndex, String propertyName, JdbcClassMapping<E> joinClassMapping, String joinPropertyName) {
        return new EntityRelation<E>(joinClassMapping, joinPropertyName, sourceIndex, propertyName, this.aliasManager);
    }

    public static class EntityRelation<E> {
        SqlSelectJoinOnBasicBuilder selectJoinOnBasicBuilder;
        JdbcClassMapping<E> classMapping;
        String joinPropertyName;
        String tableAlias;
        String idName;
        int joinFromIndex;
        String joinFromPropertyName;

        public EntityRelation(JdbcClassMapping<E> classMapping, String joinPropertyName, int joinFromIndex, String joinFromPropertyName, AliasManager aliasManager) {
            this(classMapping, joinPropertyName, joinFromIndex, joinFromPropertyName, aliasManager, null);
        }

        public EntityRelation(JdbcClassMapping<E> classMapping, String joinPropertyName, int joinFromIndex, String joinFromPropertyName, AliasManager aliasManager, SqlSelectJoinOnBasicBuilder selectJoinOnBasicBuilder) {
            this.classMapping = classMapping;
            this.joinPropertyName = joinPropertyName;
            this.joinFromPropertyName = joinFromPropertyName;
            this.joinFromIndex = joinFromIndex;
            this.tableAlias = aliasManager.put(classMapping.getRepositoryName());
            if (classMapping.getPrivaryKeyPropertyMappings().size() == 1) {
                this.idName = ((JdbcPropertyMapping)classMapping.getPrivaryKeyPropertyMappings().get(0)).getRepositoryFieldName();
            }
            if (Lang.isEmpty((String)joinPropertyName)) {
                if (Lang.isEmpty((String)this.idName)) {
                    if (Lang.isNotEmpty((String)joinFromPropertyName)) {
                        throw new SqldbHammerException("joinPropertyName and idName are all empty");
                    }
                } else {
                    this.joinPropertyName = this.idName;
                }
            }
            this.selectJoinOnBasicBuilder = selectJoinOnBasicBuilder;
        }

        public JdbcClassMapping<E> getClassMapping() {
            return this.classMapping;
        }

        public String getTableAlias() {
            return this.tableAlias;
        }

        public String getRepositoryAlias() {
            return this.getTableAlias();
        }

        public String getIdName() {
            return this.idName;
        }

        public void setIdName(String idName) {
            this.idName = idName;
        }

        public String getJoinPropertyName() {
            return this.joinPropertyName;
        }

        public String getJoinFromPropertyName() {
            return this.joinFromPropertyName;
        }

        public int getJoinFromIndex() {
            return this.joinFromIndex;
        }
    }
}

