/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.entity;

import cn.featherfly.common.db.builder.dml.basic.SqlSelectBasicBuilder;
import cn.featherfly.common.db.builder.dml.basic.SqlSelectJoinOnBasicBuilder;
import cn.featherfly.common.db.dialect.Join;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.builder.AliasManager;
import cn.featherfly.hammer.config.dsl.ConditionConfig;
import cn.featherfly.hammer.config.dsl.QueryConfig;
import cn.featherfly.hammer.expression.condition.Expression;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.dsl.entity.EntitySqlRelation;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import com.speedment.common.tuple.Tuple2;
import com.speedment.common.tuple.Tuple3;
import com.speedment.common.tuple.Tuple4;
import com.speedment.common.tuple.Tuple5;
import com.speedment.common.tuple.Tuple6;
import com.speedment.common.tuple.Tuple7;
import com.speedment.common.tuple.Tuple8;
import com.speedment.common.tuple.Tuple9;
import com.speedment.common.tuple.Tuples;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class EntitySqlQueryRelation
extends EntitySqlRelation<EntitySqlQueryRelation, SqlSelectBasicBuilder> {
    private SqlSelectBasicBuilder selectBuilder;
    private Map<Integer, EntitySqlRelation.EntityRelation<?>> entityQueryFetchMapping = new HashMap();
    private Set<String> queryFetchAlias = new HashSet<String>();

    public EntitySqlQueryRelation(Jdbc jdbc, AliasManager aliasManager, QueryConfig queryConfig) {
        super(jdbc, aliasManager, (ConditionConfig<?>)queryConfig);
    }

    public EntitySqlQueryRelation query(JdbcClassMapping<?> classMapping) {
        return (EntitySqlQueryRelation)this.addFilterable(classMapping);
    }

    public <T> EntitySqlQueryRelation join(JdbcClassMapping<T> joinClassMapping, Supplier<Expression> onExpression) {
        SqlSelectJoinOnBasicBuilder selectJoinOnBasicBuilder;
        AssertIllegalArgument.isNotNull(joinClassMapping, (String)"joinClassMapping");
        this.addFilterable(joinClassMapping);
        EntitySqlRelation.EntityRelation<?> jerm = this.getEntityRelation(this.index - 1);
        jerm.selectJoinOnBasicBuilder = selectJoinOnBasicBuilder = this.getBuilder().join2(joinClassMapping, jerm.getTableAlias(), onExpression.get().expression());
        return this;
    }

    @Override
    public EntitySqlQueryRelation join(int sourceIndex, String propertyName, JdbcClassMapping<?> joinClassMapping, String joinPropertyName, boolean returnType) {
        AssertIllegalArgument.isNotNull((Object)propertyName, (String)"propertyName");
        AssertIllegalArgument.isNotNull(joinClassMapping, (String)"joinClassMapping");
        AssertIllegalArgument.isNotNull((Object)joinPropertyName, (String)"joinPropertyName");
        EntitySqlRelation.EntityRelation<?> erm = this.getEntityRelation(sourceIndex);
        if (returnType) {
            this.addFilterable(sourceIndex, null, joinClassMapping, joinPropertyName);
        } else if (Lang.isNotEmpty((String)erm.getJoinFromPropertyName())) {
            this.addFilterable(sourceIndex, erm.getJoinFromPropertyName() + "." + propertyName, joinClassMapping, joinPropertyName);
        } else {
            this.addFilterable(sourceIndex, propertyName, joinClassMapping, joinPropertyName);
        }
        EntitySqlRelation.EntityRelation<?> jerm = this.getEntityRelation(this.index - 1);
        String joinRelation = erm.getClassMapping().getType().getSimpleName() + "[" + erm.getTableAlias() + "]." + jerm.getJoinFromPropertyName();
        if (returnType || !this.joinedRelations.contains(joinRelation)) {
            SqlSelectJoinOnBasicBuilder selectJoinOnBasicBuilder;
            this.joinedRelations.add(joinRelation);
            jerm.selectJoinOnBasicBuilder = selectJoinOnBasicBuilder = this.join0(erm.getTableAlias(), ((JdbcPropertyMapping)erm.getClassMapping().getPropertyMapping(propertyName)).getRepositoryFieldName(), joinClassMapping, jerm.getTableAlias(), ((JdbcPropertyMapping)joinClassMapping.getPropertyMapping(joinPropertyName)).getRepositoryFieldName());
        }
        return this;
    }

    private SqlSelectJoinOnBasicBuilder join0(String tableAlias, String columnName, JdbcClassMapping<?> joinClassMapping, String joinTableAlias, String joinTableColumnName) {
        return this.getBuilder().join(Join.INNER_JOIN, tableAlias, columnName, joinClassMapping, joinTableAlias, joinTableColumnName);
    }

    public EntitySqlQueryRelation fetch(int index) {
        AssertIllegalArgument.isGe((Number)index, (Number)0, (String)"fetch entity index");
        AssertIllegalArgument.isLt((Number)index, (Number)this.entityFilterableMappingTuple.degree(), (String)"fetch entity index");
        EntitySqlRelation.EntityRelation<?> erm = this.getEntityRelation(index);
        this.entityQueryFetchMapping.put(this.entityQueryFetchMapping.size(), erm);
        this.queryFetchAlias.add(erm.getTableAlias());
        if (index > 0) {
            erm.selectJoinOnBasicBuilder.fetch();
        }
        return this;
    }

    public EntitySqlQueryRelation fetchProperty(int index) {
        AssertIllegalArgument.isGe((Number)index, (Number)0, (String)"fetch entity index");
        AssertIllegalArgument.isLt((Number)index, (Number)this.entityFilterableMappingTuple.degree(), (String)"fetch entity index");
        EntitySqlRelation.EntityRelation<?> erm = this.getEntityRelation(index);
        this.queryFetchAlias.add(erm.getTableAlias());
        if (index > 0) {
            erm.selectJoinOnBasicBuilder.fetch((prefixTableAlias, alias) -> {
                if (prefixTableAlias.booleanValue()) {
                    EntitySqlRelation.EntityRelation<?> jerm = this.getEntityRelation(erm.getJoinFromIndex());
                    return jerm.getTableAlias() + '.' + erm.getJoinFromPropertyName();
                }
                return erm.getJoinFromPropertyName();
            });
        }
        return this;
    }

    public boolean isReturnTuple() {
        return this.entityQueryFetchMapping.size() > 1;
    }

    public Class<?> getResultType() {
        switch (this.entityQueryFetchMapping.size()) {
            case 1: {
                return ((EntitySqlRelation.EntityRelation)this.entityFilterableMappingTuple.getOrNull0()).getClassMapping().getType();
            }
            case 2: {
                return Tuple2.class;
            }
            case 3: {
                return Tuple3.class;
            }
            case 4: {
                return Tuple4.class;
            }
            case 5: {
                return Tuple5.class;
            }
            case 6: {
                return Tuple6.class;
            }
            case 7: {
                return Tuple7.class;
            }
            case 8: {
                return Tuple8.class;
            }
            case 9: {
                return Tuple9.class;
            }
        }
        throw new SqldbHammerException("entity query fetch times must be 1-9");
    }

    public String buildSelectSql() {
        return this.selectBuilder.setColumnAliasPrefixTableAlias(this.isReturnTuple()).build((tableName, tableAlias) -> this.queryFetchAlias.contains(tableAlias));
    }

    public <R> R single(String sql, Object[] params) {
        switch (this.entityQueryFetchMapping.size()) {
            case 1: {
                return (R)this.jdbc.querySingle(sql, ((EntitySqlRelation.EntityRelation)this.entityFilterableMappingTuple.getOrNull0()).getClassMapping().getType(), params);
            }
            case 2: {
                return (R)this.jdbc.querySingle(sql, this.entityQueryFetchMapping.get(0).getClassMapping().getType(), this.entityQueryFetchMapping.get(1).getClassMapping().getType(), this.getFetchAliasTuple2(), params);
            }
            case 3: {
                return (R)this.jdbc.querySingle(sql, this.entityQueryFetchMapping.get(0).getClassMapping().getType(), this.entityQueryFetchMapping.get(1).getClassMapping().getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)2)).classMapping.getType(), this.getFetchAliasTuple3(), params);
            }
            case 4: {
                return (R)this.jdbc.querySingle(sql, this.entityQueryFetchMapping.get(0).getClassMapping().getType(), this.entityQueryFetchMapping.get(1).getClassMapping().getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)2)).classMapping.getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)3)).classMapping.getType(), this.getFetchAliasTuple4(), params);
            }
            case 5: {
                return (R)this.jdbc.querySingle(sql, this.entityQueryFetchMapping.get(0).getClassMapping().getType(), this.entityQueryFetchMapping.get(1).getClassMapping().getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)2)).classMapping.getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)3)).classMapping.getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)4)).classMapping.getType(), this.getFetchAliasTuple5(), params);
            }
            case 6: {
                return (R)this.jdbc.querySingle(sql, this.entityQueryFetchMapping.get(0).getClassMapping().getType(), this.entityQueryFetchMapping.get(1).getClassMapping().getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)2)).classMapping.getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)3)).classMapping.getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)4)).classMapping.getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)5)).classMapping.getType(), this.getFetchAliasTuple6(), params);
            }
        }
        throw new SqldbHammerException("entity query fetch times must be 2-6");
    }

    public <R> R unique(String sql, Object[] params) {
        switch (this.entityQueryFetchMapping.size()) {
            case 1: {
                return (R)this.jdbc.queryUnique(sql, ((EntitySqlRelation.EntityRelation)this.entityFilterableMappingTuple.getOrNull0()).getClassMapping().getType(), params);
            }
            case 2: {
                return (R)this.jdbc.queryUnique(sql, this.entityQueryFetchMapping.get(0).getClassMapping().getType(), this.entityQueryFetchMapping.get(1).getClassMapping().getType(), this.getFetchAliasTuple2(), params);
            }
            case 3: {
                return (R)this.jdbc.queryUnique(sql, this.entityQueryFetchMapping.get(0).getClassMapping().getType(), this.entityQueryFetchMapping.get(1).getClassMapping().getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)2)).classMapping.getType(), this.getFetchAliasTuple3(), params);
            }
            case 4: {
                return (R)this.jdbc.queryUnique(sql, this.entityQueryFetchMapping.get(0).getClassMapping().getType(), this.entityQueryFetchMapping.get(1).getClassMapping().getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)2)).classMapping.getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)3)).classMapping.getType(), this.getFetchAliasTuple4(), params);
            }
            case 5: {
                return (R)this.jdbc.queryUnique(sql, this.entityQueryFetchMapping.get(0).getClassMapping().getType(), this.entityQueryFetchMapping.get(1).getClassMapping().getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)2)).classMapping.getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)3)).classMapping.getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)4)).classMapping.getType(), this.getFetchAliasTuple5(), params);
            }
            case 6: {
                return (R)this.jdbc.queryUnique(sql, this.entityQueryFetchMapping.get(0).getClassMapping().getType(), this.entityQueryFetchMapping.get(1).getClassMapping().getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)2)).classMapping.getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)3)).classMapping.getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)4)).classMapping.getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)5)).classMapping.getType(), this.getFetchAliasTuple6(), params);
            }
        }
        throw new SqldbHammerException("entity query fetch times must be 2-6");
    }

    public <R> List<R> list(String sql, Object[] params) {
        switch (this.entityQueryFetchMapping.size()) {
            case 1: {
                return this.jdbc.query(sql, ((EntitySqlRelation.EntityRelation)this.entityFilterableMappingTuple.getOrNull0()).getClassMapping().getType(), params);
            }
            case 2: {
                return this.jdbc.query(sql, this.entityQueryFetchMapping.get(0).getClassMapping().getType(), this.entityQueryFetchMapping.get(1).getClassMapping().getType(), this.getFetchAliasTuple2(), params);
            }
            case 3: {
                return this.jdbc.query(sql, this.entityQueryFetchMapping.get(0).getClassMapping().getType(), this.entityQueryFetchMapping.get(1).getClassMapping().getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)2)).classMapping.getType(), this.getFetchAliasTuple3(), params);
            }
            case 4: {
                return this.jdbc.query(sql, this.entityQueryFetchMapping.get(0).getClassMapping().getType(), this.entityQueryFetchMapping.get(1).getClassMapping().getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)2)).classMapping.getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)3)).classMapping.getType(), this.getFetchAliasTuple4(), params);
            }
            case 5: {
                return this.jdbc.query(sql, this.entityQueryFetchMapping.get(0).getClassMapping().getType(), this.entityQueryFetchMapping.get(1).getClassMapping().getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)2)).classMapping.getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)3)).classMapping.getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)4)).classMapping.getType(), this.getFetchAliasTuple5(), params);
            }
            case 6: {
                return this.jdbc.query(sql, this.entityQueryFetchMapping.get(0).getClassMapping().getType(), this.entityQueryFetchMapping.get(1).getClassMapping().getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)2)).classMapping.getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)3)).classMapping.getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)4)).classMapping.getType(), this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)5)).classMapping.getType(), this.getFetchAliasTuple6(), params);
            }
        }
        throw new SqldbHammerException("entity query fetch times must be 2-6");
    }

    @Override
    protected void initBuilder(EntitySqlRelation.EntityRelation<?> erm) {
        this.selectBuilder = new SqlSelectBasicBuilder(this.jdbc.getDialect(), erm.classMapping, erm.tableAlias);
    }

    @Override
    public SqlSelectBasicBuilder getBuilder() {
        return this.selectBuilder;
    }

    private Tuple2<String, String> getFetchAliasTuple2() {
        if (this.entityQueryFetchMapping.size() == 2) {
            return Tuples.of((Object)(this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)0)).tableAlias + "."), (Object)(this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)1)).tableAlias + "."));
        }
        throw new SqldbHammerException("entity query fetch times must be 2");
    }

    private Tuple3<String, String, String> getFetchAliasTuple3() {
        if (this.entityQueryFetchMapping.size() == 3) {
            return Tuples.of((Object)(this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)0)).tableAlias + "."), (Object)(this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)1)).tableAlias + "."), (Object)(this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)2)).tableAlias + "."));
        }
        throw new SqldbHammerException("entity query fetch times must be 3");
    }

    private Tuple4<String, String, String, String> getFetchAliasTuple4() {
        if (this.entityQueryFetchMapping.size() == 4) {
            return Tuples.of((Object)(this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)0)).tableAlias + "."), (Object)(this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)1)).tableAlias + "."), (Object)(this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)2)).tableAlias + "."), (Object)(this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)3)).tableAlias + "."));
        }
        throw new SqldbHammerException("entity query fetch times must be 4");
    }

    private Tuple5<String, String, String, String, String> getFetchAliasTuple5() {
        if (this.entityQueryFetchMapping.size() == 5) {
            return Tuples.of((Object)(this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)0)).tableAlias + "."), (Object)(this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)1)).tableAlias + "."), (Object)(this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)2)).tableAlias + "."), (Object)(this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)3)).tableAlias + "."), (Object)(this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)4)).tableAlias + "."));
        }
        throw new SqldbHammerException("entity query fetch times must be 5");
    }

    private Tuple6<String, String, String, String, String, String> getFetchAliasTuple6() {
        if (this.entityQueryFetchMapping.size() == 6) {
            return Tuples.of((Object)(this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)0)).tableAlias + "."), (Object)(this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)1)).tableAlias + "."), (Object)(this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)2)).tableAlias + "."), (Object)(this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)3)).tableAlias + "."), (Object)(this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)4)).tableAlias + "."), (Object)(this.entityQueryFetchMapping.get((Object)Integer.valueOf((int)5)).tableAlias + "."));
        }
        throw new SqldbHammerException("entity query fetch times must be 6");
    }

    @Override
    public QueryConfig getConfig() {
        return (QueryConfig)this.conditionConfig;
    }
}

