/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb;

import cn.featherfly.common.bean.BeanDescriptor;
import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.db.Table;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.common.function.serializable.SerializableFunction;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.IgnoreStrategy;
import cn.featherfly.common.repository.Repository;
import cn.featherfly.common.structure.page.PaginationResults;
import cn.featherfly.hammer.config.HammerConfig;
import cn.featherfly.hammer.dsl.entity.execute.EntityDelete;
import cn.featherfly.hammer.dsl.entity.execute.EntityUpdate;
import cn.featherfly.hammer.dsl.entity.query.EntityQueryFetch;
import cn.featherfly.hammer.dsl.repository.execute.RepositoryDelete;
import cn.featherfly.hammer.dsl.repository.execute.RepositoryUpdate;
import cn.featherfly.hammer.dsl.repository.query.RepositoryQueryFetch;
import cn.featherfly.hammer.sqldb.SqldbHammer;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.dsl.execute.SqlDeleter;
import cn.featherfly.hammer.sqldb.dsl.execute.SqlUpdater;
import cn.featherfly.hammer.sqldb.dsl.query.SqlQuery;
import cn.featherfly.hammer.sqldb.dsl.repository.query.RepositorySqlQueryFetch;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.SimpleSqlPageFactory;
import cn.featherfly.hammer.sqldb.jdbc.SqlPageFactory;
import cn.featherfly.hammer.sqldb.jdbc.operate.DeleteOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.GetOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.InsertOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.MergeOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.UpdateFetchOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.UpdateOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.UpsertOperate;
import cn.featherfly.hammer.sqldb.tpl.SqlDbTemplateEngine;
import cn.featherfly.hammer.sqldb.tpl.SqlTplExecutor;
import cn.featherfly.hammer.sqldb.tpl.freemarker.SqldbFreemarkerTemplateEngine;
import cn.featherfly.hammer.sqldb.tpl.transverter.FuzzyQueryTransverter;
import cn.featherfly.hammer.tpl.AutoRegistTransverter;
import cn.featherfly.hammer.tpl.TplConfigFactory;
import cn.featherfly.hammer.tpl.TplExecuteId;
import cn.featherfly.hammer.tpl.TransverterManager;
import com.speedment.common.tuple.Tuple2;
import com.speedment.common.tuple.Tuple3;
import com.speedment.common.tuple.Tuple4;
import com.speedment.common.tuple.Tuple5;
import com.speedment.common.tuple.Tuple6;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.validation.ConstraintViolation;

public class SqldbHammerImpl
implements SqldbHammer {
    private Jdbc jdbc;
    private JdbcMappingFactory mappingFactory;
    private HammerConfig hammerConfig;
    private SqlTplExecutor sqlTplExecutor;
    private Map<Class<?>, InsertOperate<?>> insertOperates = new HashMap();
    private Map<Class<?>, UpdateOperate<?>> updateOperates = new HashMap();
    private Map<Class<?>, UpdateFetchOperate<?>> updateFetchOperates = new HashMap();
    private Map<Class<?>, UpsertOperate<?>> upsertOperates = new HashMap();
    private Map<Class<?>, GetOperate<?>> getOperates = new HashMap();
    private Map<Class<?>, DeleteOperate<?>> deleteOperates = new HashMap();
    private Map<Class<?>, MergeOperate<?>> mergeOperates = new HashMap();
    private final SqlQuery query;
    private final SqlUpdater updater;
    private final SqlDeleter deleter;

    public SqldbHammerImpl(Jdbc jdbc, JdbcMappingFactory mappingFactory, TplConfigFactory configFactory, HammerConfig hammerConfig) {
        this(jdbc, mappingFactory, configFactory, new SqldbFreemarkerTemplateEngine(configFactory), hammerConfig);
    }

    public SqldbHammerImpl(Jdbc jdbc, JdbcMappingFactory mappingFactory, TplConfigFactory configFactory, SqlDbTemplateEngine templateEngine, HammerConfig hammerConfig) {
        this(jdbc, mappingFactory, configFactory, templateEngine, new SimpleSqlPageFactory(), hammerConfig);
    }

    public SqldbHammerImpl(Jdbc jdbc, JdbcMappingFactory mappingFactory, TplConfigFactory configFactory, SqlDbTemplateEngine templateEngine, SqlPageFactory sqlPageFacotry, HammerConfig hammerConfig) {
        this(jdbc, mappingFactory, configFactory, templateEngine, sqlPageFacotry, new TransverterManager(new AutoRegistTransverter[]{new FuzzyQueryTransverter()}), hammerConfig);
    }

    public SqldbHammerImpl(Jdbc jdbc, JdbcMappingFactory mappingFactory, TplConfigFactory configFactory, SqlDbTemplateEngine templateEngine, SqlPageFactory sqlPageFacotry, TransverterManager transverterManager, HammerConfig hammerConfig) {
        this.jdbc = jdbc;
        this.mappingFactory = mappingFactory;
        this.hammerConfig = hammerConfig;
        this.sqlTplExecutor = new SqlTplExecutor(configFactory, templateEngine, jdbc, mappingFactory, sqlPageFacotry, transverterManager);
        this.query = new SqlQuery(jdbc, mappingFactory, this.sqlTplExecutor.getSqlPageFactory(), hammerConfig.getDslConfig().getQueryConfig());
        this.updater = new SqlUpdater(jdbc, mappingFactory, hammerConfig.getDslConfig().getUpdateConfig());
        this.deleter = new SqlDeleter(jdbc, mappingFactory, hammerConfig.getDslConfig().getDeleteConfig());
    }

    public <E> int save(E entity) {
        if (entity == null) {
            return 0;
        }
        InsertOperate<E> insert = this.getInsert(entity);
        this.validate(entity);
        return insert.execute(entity);
    }

    public <E> int[] save(List<E> entities, int batchSize) {
        if (Lang.isEmpty(entities)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        InsertOperate<E> insert = null;
        for (E entity : entities) {
            if (insert == null) {
                insert = this.getInsert(entity);
            }
            this.validate(entity);
        }
        if (insert == null) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        return insert.executeBatch(entities, batchSize);
    }

    public <E> int saveOrUpdate(E entity) {
        return this.saveOrUpdate(entity, e -> {
            GetOperate<?> get = this.getOperate(e.getClass());
            List<Serializable> ids = get.getIds(e);
            if (ids.size() == 1) {
                Serializable id = ids.get(0);
                return id != null;
            }
            if (ids.size() > 1) {
                boolean insertable = false;
                for (Serializable id : ids) {
                    if (id != null) continue;
                    insertable = true;
                }
                return !insertable;
            }
            throw new SqldbHammerException("no pk mapping");
        });
    }

    public <E> int saveOrUpdate(E entity, Predicate<E> updatable) {
        if (entity == null) {
            return 0;
        }
        if (this.jdbc.getDialect().supportUpsert()) {
            UpsertOperate<E> upsert = this.getUpsert(entity);
            return upsert.execute(entity);
        }
        if (updatable.test(entity)) {
            return this.update(entity);
        }
        return this.save(entity);
    }

    public <E> int update(E entity) {
        if (entity == null) {
            return 0;
        }
        UpdateOperate<E> update = this.getUpdate(entity);
        this.validate(entity);
        return update.execute(entity);
    }

    public <E> int update(E entity, IgnoreStrategy ignoreStrategy) {
        switch (ignoreStrategy) {
            case EMPTY: {
                return this.merge(entity);
            }
            case NULL: {
                return this.merge(entity, true);
            }
        }
        return this.update(entity);
    }

    public <E> int[] update(E ... entities) {
        if (Lang.isNotEmpty((Object[])entities)) {
            int[] results = new int[entities.length];
            for (int i = 0; i < entities.length; ++i) {
                results[i] = this.update(entities[i]);
            }
            return results;
        }
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    public <E> int[] update(List<E> entities) {
        return this.update(entities, entities.size());
    }

    public <E> int[] update(List<E> entities, int batchSize) {
        if (Lang.isEmpty(entities)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        Class<?> type = entities.get(0).getClass();
        UpdateOperate<Object> update = this.updateOperates.get(type);
        if (update == null) {
            JdbcClassMapping mapping = this.mappingFactory.getClassMapping(type);
            update = new UpdateOperate(this.jdbc, mapping, this.mappingFactory.getSqlTypeMappingManager(), this.mappingFactory.getMetadata());
            this.updateOperates.put(type, update);
        }
        for (E entity : entities) {
            this.validate(entity);
        }
        return update.executeBatch(entities, batchSize);
    }

    public <E> int[] update(List<E> entities, IgnoreStrategy ignoreStrategy) {
        if (Lang.isNotEmpty(entities)) {
            int[] results = new int[entities.size()];
            for (int i = 0; i < entities.size(); ++i) {
                results[i] = this.update(entities.get(i), ignoreStrategy);
            }
            return results;
        }
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    private <E> int merge(E entity, boolean onlyNull) {
        if (entity == null) {
            return 0;
        }
        MergeOperate<Object> update = this.mergeOperates.get(entity.getClass());
        if (update == null) {
            JdbcClassMapping mapping = this.mappingFactory.getClassMapping(entity.getClass());
            update = new MergeOperate(this.jdbc, mapping, this.mappingFactory.getSqlTypeMappingManager(), this.mappingFactory.getMetadata());
            this.mergeOperates.put(entity.getClass(), update);
        }
        this.validate(entity);
        return update.execute(entity, onlyNull);
    }

    public <E> int merge(E entity) {
        return this.merge(entity, false);
    }

    public <E> int[] merge(E ... entities) {
        int[] results = new int[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            results[i] = this.merge(entities[i]);
        }
        return results;
    }

    public <E> int[] merge(List<E> entities) {
        int[] results = new int[entities.size()];
        for (int i = 0; i < entities.size(); ++i) {
            results[i] = this.merge(entities.get(i));
        }
        return results;
    }

    public <E> int delete(Serializable id, @Nonnull Class<E> entityType) {
        if (id == null || entityType == null) {
            return 0;
        }
        DeleteOperate<E> delete = this.getDelete(entityType);
        return delete.delete(id);
    }

    public <E> int[] delete(Serializable[] ids, @Nonnull Class<E> entityType) {
        if (Lang.isEmpty((Object[])ids)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        DeleteOperate<E> delete = this.getDelete(entityType);
        return delete.deleteBatch(ids);
    }

    public <E, ID extends Serializable> int[] delete(List<ID> ids, @Nonnull Class<E> entityType) {
        if (Lang.isEmpty(ids)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        DeleteOperate<E> delete = this.getDelete(entityType);
        return delete.deleteBatch(ids);
    }

    public <E> int delete(E entity) {
        if (entity == null) {
            return 0;
        }
        DeleteOperate<E> delete = this.getDelete(entity);
        return delete.execute(entity);
    }

    public <E> int[] delete(List<E> entities) {
        if (Lang.isEmpty(entities)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        DeleteOperate<List<E>> delete = this.getDelete((E)entities);
        if (delete == null) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        return delete.executeBatch(entities);
    }

    public <E> E get(Serializable id, Class<E> type) {
        if (id == null || type == null) {
            return null;
        }
        GetOperate<E> get = this.getOperate(type);
        return get.execute(id);
    }

    public <E> List<E> get(Class<E> type, Serializable ... ids) {
        ArrayList<E> list = new ArrayList<E>();
        if (Lang.isEmpty((Object[])ids)) {
            return list;
        }
        for (Serializable id : ids) {
            list.add(this.get(id, type));
        }
        return list;
    }

    public <E> List<E> get(Class<E> type, List<Serializable> ids) {
        ArrayList<E> list = new ArrayList<E>();
        if (Lang.isEmpty(ids)) {
            return list;
        }
        for (Serializable id : ids) {
            list.add(this.get(id, type));
        }
        return list;
    }

    public <E, R> E get(Serializable id, Class<E> type, SerializableFunction<E, R> fetchProperty) {
        E entity = this.get(id, type);
        if (entity == null) {
            return null;
        }
        BeanProperty bp = BeanDescriptor.getBeanDescriptor(type).getBeanProperty(fetchProperty);
        Object fetchObj = this.get(bp.getValue(entity));
        bp.setValue(entity, fetchObj);
        return entity;
    }

    public <E> E get(E entity) {
        if (entity == null) {
            return null;
        }
        GetOperate<?> get = this.getOperate(entity.getClass());
        return (E)get.get(entity);
    }

    public <E> E updateFetch(Serializable id, Class<E> type, UnaryOperator<E> updateOperator) {
        if (Lang.isEmpty((Object)id)) {
            return null;
        }
        return (E)this.getUpdateFetch((E)type).execute((Class<E>)id, (UnaryOperator<Class<E>>)updateOperator);
    }

    public <E> E updateFetch(E entity, UnaryOperator<E> updateOperator) {
        if (entity == null) {
            return null;
        }
        return this.getUpdateFetch(entity).execute(entity, updateOperator);
    }

    public RepositoryQueryFetch query(String repository) {
        return this.query.find(repository);
    }

    public RepositoryQueryFetch query(Repository repository) {
        return this.query.find(repository);
    }

    @Override
    public RepositorySqlQueryFetch query(Table table) {
        return this.query.find((Repository)table);
    }

    public <E> EntityQueryFetch<E> query(Class<E> entityType) {
        return this.query.find(entityType);
    }

    public <E> EntityUpdate<E> update(Class<E> entityType) {
        return this.updater.update(entityType);
    }

    public RepositoryUpdate update(String repository) {
        return this.updater.update(repository);
    }

    public RepositoryUpdate update(Repository repository) {
        return this.updater.update(repository);
    }

    @Override
    public RepositoryUpdate update(Table table) {
        return this.updater.update(table);
    }

    public RepositoryDelete delete(String repository) {
        return this.deleter.delete(repository);
    }

    public RepositoryDelete delete(Repository repository) {
        return this.deleter.delete(repository);
    }

    @Override
    public RepositoryDelete delete(Table table) {
        return this.deleter.delete(table);
    }

    public <E> EntityDelete<E> delete(Class<E> entityType) {
        return this.deleter.delete(entityType);
    }

    private <E> void validate(E entity) {
        Set cons;
        if (this.hammerConfig.getValidator() != null && Lang.isNotEmpty((Collection)(cons = this.hammerConfig.getValidator().validate(entity, new Class[0])))) {
            StringBuilder errorMessage = new StringBuilder();
            for (ConstraintViolation constraintViolation : cons) {
                errorMessage.append(constraintViolation.getMessage()).append(",");
            }
            throw new SqldbHammerException(errorMessage.toString());
        }
    }

    public <E> List<E> list(String tplExecuteId, Class<E> entityType, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType, params);
    }

    public <E> List<E> list(String tplExecuteId, Class<E> entityType, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType, params, offset, limit);
    }

    public <E> PaginationResults<E> pagination(String tplExecuteId, Class<E> entityType, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType, params, offset, limit);
    }

    public Map<String, Object> single(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, params);
    }

    public Map<String, Object> single(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, params);
    }

    public <E> E single(String tplExecuteId, Class<E> entityType, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, entityType, params);
    }

    public <E> E single(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, entityType, params);
    }

    public <R1, R2> Tuple2<R1, R2> single(String tplExecuteId, Class<R1> elementType1, Class<R2> elementType2, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, elementType1, elementType2, params);
    }

    public <R1, R2> Tuple2<R1, R2> single(TplExecuteId tplExecuteId, Class<R1> elementType1, Class<R2> elementType2, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, elementType1, elementType2, params);
    }

    public <R1, R2> Tuple2<R1, R2> single(String tplExecuteId, Class<R1> elementType1, Class<R2> elementType2, Tuple2<String, String> prefixes, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, elementType1, elementType2, prefixes, params);
    }

    public <R1, R2> Tuple2<R1, R2> single(TplExecuteId tplExecuteId, Class<R1> elementType1, Class<R2> elementType2, Tuple2<String, String> prefixes, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, elementType1, elementType2, prefixes, params);
    }

    public <R1, R2, R3> Tuple3<R1, R2, R3> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, entityType1, entityType2, entityType3, params);
    }

    public <R1, R2, R3> Tuple3<R1, R2, R3> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, entityType1, entityType2, entityType3, params);
    }

    public <R1, R2, R3> Tuple3<R1, R2, R3> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, entityType1, entityType2, entityType3, prefixes, params);
    }

    public <R1, R2, R3> Tuple3<R1, R2, R3> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, entityType1, entityType2, entityType3, prefixes, params);
    }

    public <R1, R2, R3, R4> Tuple4<R1, R2, R3, R4> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, entityType1, entityType2, entityType3, entityType4, params);
    }

    public <R1, R2, R3, R4> Tuple4<R1, R2, R3, R4> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, entityType1, entityType2, entityType3, entityType4, params);
    }

    public <R1, R2, R3, R4> Tuple4<R1, R2, R3, R4> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, entityType1, entityType2, entityType3, entityType4, prefixes, params);
    }

    public <R1, R2, R3, R4> Tuple4<R1, R2, R3, R4> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, entityType1, entityType2, entityType3, entityType4, prefixes, params);
    }

    public <R1, R2, R3, R4, R5> Tuple5<R1, R2, R3, R4, R5> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params);
    }

    public <R1, R2, R3, R4, R5> Tuple5<R1, R2, R3, R4, R5> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params);
    }

    public <R1, R2, R3, R4, R5> Tuple5<R1, R2, R3, R4, R5> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, params);
    }

    public <R1, R2, R3, R4, R5> Tuple5<R1, R2, R3, R4, R5> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, params);
    }

    public <R1, R2, R3, R4, R5, R6> Tuple6<R1, R2, R3, R4, R5, R6> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, params);
    }

    public <R1, R2, R3, R4, R5, R6> Tuple6<R1, R2, R3, R4, R5, R6> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, params);
    }

    public <R1, R2, R3, R4, R5, R6> Tuple6<R1, R2, R3, R4, R5, R6> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params);
    }

    public <R1, R2, R3, R4, R5, R6> Tuple6<R1, R2, R3, R4, R5, R6> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params);
    }

    public <E> List<E> list(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType, params);
    }

    public <E> List<E> list(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType, params, offset, limit);
    }

    public <E> PaginationResults<E> pagination(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType, params, offset, limit);
    }

    public List<Map<String, Object>> list(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, params);
    }

    public List<Map<String, Object>> list(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, params);
    }

    public List<Map<String, Object>> list(String tplExecuteId, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, params, offset, limit);
    }

    public List<Map<String, Object>> list(TplExecuteId tplExecuteId, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, params, offset, limit);
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, params);
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, params);
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, params, offset, limit);
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, params, offset, limit);
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, prefixes, params);
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, prefixes, params);
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, prefixes, params, offset, limit);
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, prefixes, params, offset, limit);
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, params);
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, params);
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Object> param, int offset, int limits) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, param, offset, limits);
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, params, offset, limit);
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, prefixes, params);
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, prefixes, params);
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, prefixes, params, offset, limit);
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, params);
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, params);
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, params, offset, limit);
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, params, offset, limit);
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, prefixes, params);
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, prefixes, params);
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, params);
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, params);
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params);
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params);
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, params);
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, params);
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params);
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params);
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params, offset, limit);
    }

    public PaginationResults<Map<String, Object>> pagination(String tplExecuteId, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, params, offset, limit);
    }

    public PaginationResults<Map<String, Object>> pagination(TplExecuteId tplExecuteId, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, params, offset, limit);
    }

    public <R1, R2> PaginationResults<Tuple2<R1, R2>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType1, entityType2, params, offset, limit);
    }

    public <R1, R2> PaginationResults<Tuple2<R1, R2>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType1, entityType2, params, offset, limit);
    }

    public <R1, R2> PaginationResults<Tuple2<R1, R2>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType1, entityType2, prefixes, params, offset, limit);
    }

    public <R1, R2> PaginationResults<Tuple2<R1, R2>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType1, entityType2, prefixes, params, offset, limit);
    }

    public <R1, R2, R3> PaginationResults<Tuple3<R1, R2, R3>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Object> param, int offset, int limits) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType1, entityType2, entityType3, param, offset, limits);
    }

    public <R1, R2, R3> PaginationResults<Tuple3<R1, R2, R3>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType1, entityType2, entityType3, params, offset, limit);
    }

    public <R1, R2, R3> PaginationResults<Tuple3<R1, R2, R3>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType1, entityType2, entityType3, prefixes, params, offset, limit);
    }

    public <R1, R2, R3> PaginationResults<Tuple3<R1, R2, R3>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType1, entityType2, entityType3, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4> PaginationResults<Tuple4<R1, R2, R3, R4>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType1, entityType2, entityType3, entityType4, params, offset, limit);
    }

    public <R1, R2, R3, R4> PaginationResults<Tuple4<R1, R2, R3, R4>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType1, entityType2, entityType3, entityType4, params, offset, limit);
    }

    public <R1, R2, R3, R4> PaginationResults<Tuple4<R1, R2, R3, R4>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType1, entityType2, entityType3, entityType4, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4> PaginationResults<Tuple4<R1, R2, R3, R4>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType1, entityType2, entityType3, entityType4, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5> PaginationResults<Tuple5<R1, R2, R3, R4, R5>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5> PaginationResults<Tuple5<R1, R2, R3, R4, R5>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5> PaginationResults<Tuple5<R1, R2, R3, R4, R5>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5> PaginationResults<Tuple5<R1, R2, R3, R4, R5>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5, R6> PaginationResults<Tuple6<R1, R2, R3, R4, R5, R6>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5, R6> PaginationResults<Tuple6<R1, R2, R3, R4, R5, R6>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5, R6> PaginationResults<Tuple6<R1, R2, R3, R4, R5, R6>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5, R6> PaginationResults<Tuple6<R1, R2, R3, R4, R5, R6>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params, offset, limit);
    }

    public <E> E value(String tplExecuteId, Class<E> valueType, Map<String, Object> params) {
        return this.sqlTplExecutor.value(tplExecuteId, valueType, params);
    }

    public <N extends Number> N number(String tplExecuteId, Class<N> numberType, Map<String, Object> params) {
        return this.sqlTplExecutor.number(tplExecuteId, numberType, params);
    }

    public Integer numberInt(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.numberInt(tplExecuteId, params);
    }

    public Long numberLong(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.numberLong(tplExecuteId, params);
    }

    public BigDecimal numberBigDecimal(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.numberBigDecimal(tplExecuteId, params);
    }

    public Double numberDouble(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.numberDouble(tplExecuteId, params);
    }

    public String string(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.string(tplExecuteId, params);
    }

    public <E> E value(TplExecuteId tplExecuteId, Class<E> valueType, Map<String, Object> params) {
        return this.sqlTplExecutor.value(tplExecuteId, valueType, params);
    }

    public <N extends Number> N number(TplExecuteId tplExecuteId, Class<N> numberType, Map<String, Object> params) {
        return this.sqlTplExecutor.number(tplExecuteId, numberType, params);
    }

    public int intValue(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.intValue(tplExecuteId, params);
    }

    public int intValue(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.intValue(tplExecuteId, params);
    }

    public long longValue(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.longValue(tplExecuteId, params);
    }

    public long longValue(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.longValue(tplExecuteId, params);
    }

    public double doubleValue(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.doubleValue(tplExecuteId, params);
    }

    public double doubleValue(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.doubleValue(tplExecuteId, params);
    }

    public Integer numberInt(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.numberInt(tplExecuteId, params);
    }

    public Long numberLong(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.numberLong(tplExecuteId, params);
    }

    public BigDecimal numberBigDecimal(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.numberBigDecimal(tplExecuteId, params);
    }

    public Double numberDouble(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.numberDouble(tplExecuteId, params);
    }

    public String string(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.string(tplExecuteId, params);
    }

    public int execute(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.execute(tplExecuteId, params);
    }

    public int execute(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.execute(tplExecuteId, params);
    }

    @Override
    public Jdbc getJdbc() {
        return this.jdbc;
    }

    @Override
    public JdbcMappingFactory getMappingFactory() {
        return this.mappingFactory;
    }

    private <E> UpdateOperate<E> getUpdate(E entity) {
        return this.getUpdate(entity.getClass());
    }

    private <E> UpdateOperate<E> getUpdate(Class<E> entityType) {
        return this.updateOperates.computeIfAbsent(entityType, type -> new UpdateOperate(this.jdbc, this.mappingFactory.getClassMapping(type), this.mappingFactory.getSqlTypeMappingManager(), this.mappingFactory.getMetadata()));
    }

    private <E> UpdateFetchOperate<E> getUpdateFetch(Class<E> entityType) {
        return this.updateFetchOperates.computeIfAbsent(entityType, type -> new UpdateFetchOperate(this.jdbc, this.mappingFactory.getClassMapping(type), this.mappingFactory.getSqlTypeMappingManager(), this.mappingFactory.getMetadata(), this.getOperate((Class)type), this.getUpdate((Class)type), key -> {}, key -> {}));
    }

    private <E> UpdateFetchOperate<E> getUpdateFetch(E entity) {
        return this.getUpdateFetch((E)entity.getClass());
    }

    private <E> InsertOperate<E> getInsert(Class<E> entityType) {
        return this.insertOperates.computeIfAbsent(entityType, type -> new InsertOperate(this.jdbc, this.mappingFactory.getClassMapping(type), this.mappingFactory.getSqlTypeMappingManager(), this.mappingFactory.getMetadata()));
    }

    private <E> InsertOperate<E> getInsert(E entity) {
        return this.getInsert((E)entity.getClass());
    }

    private <E> UpsertOperate<E> getUpsert(Class<E> entityType) {
        return this.upsertOperates.computeIfAbsent(entityType, type -> new UpsertOperate(this.jdbc, this.mappingFactory.getClassMapping(type), this.mappingFactory.getSqlTypeMappingManager(), this.mappingFactory.getMetadata()));
    }

    private <E> UpsertOperate<E> getUpsert(E entity) {
        return this.getUpsert((E)entity.getClass());
    }

    private <E> DeleteOperate<E> getDelete(Collection<E> entities) {
        Object e = Lang.ifNotNullFirst(entities);
        if (e == null) {
            return null;
        }
        return this.getDelete(e);
    }

    private <E> DeleteOperate<E> getDelete(E entity) {
        return this.getDelete(entity.getClass());
    }

    private <E> DeleteOperate<E> getDelete(Class<E> entityType) {
        return this.deleteOperates.computeIfAbsent(entityType, type -> new DeleteOperate(this.jdbc, this.mappingFactory.getClassMapping(type), this.mappingFactory.getSqlTypeMappingManager(), this.mappingFactory.getMetadata()));
    }

    private <E> GetOperate<E> getOperate(Class<E> entityType) {
        return this.getOperates.computeIfAbsent(entityType, type -> new GetOperate(this.jdbc, this.mappingFactory.getClassMapping(type), this.mappingFactory.getSqlTypeMappingManager(), this.mappingFactory.getMetadata()));
    }
}

