/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.bean.BeanPropertyValue;
import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.repository.Execution;
import cn.featherfly.common.repository.mapping.RowMapper;
import cn.featherfly.hammer.sqldb.jdbc.GeneratedKeyHolder;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.JdbcExecution;
import cn.featherfly.hammer.sqldb.jdbc.JdbcExecutionInterceptor;
import cn.featherfly.hammer.sqldb.jdbc.NestedBeanPropertyRowMapper;
import cn.featherfly.hammer.sqldb.jdbc.SingleColumnRowMapper;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbc
implements Jdbc {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected DataSource dataSource;
    protected Dialect dialect;
    protected SqlTypeMappingManager manager;
    protected final List<JdbcExecutionInterceptor> interceptors = new ArrayList<JdbcExecutionInterceptor>(0);

    protected AbstractJdbc(DataSource dataSource, Dialect dialect, SqlTypeMappingManager manager) {
        this.setDataSource(dataSource);
        this.dialect = dialect;
        this.manager = manager;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public <T extends Serializable> int insert(String tableName, String[] columnNames, GeneratedKeyHolder<T> keyHolder, Object ... args) {
        return this.update(this.getDialect().buildInsertSql(tableName, columnNames), keyHolder, args);
    }

    @Override
    public int insertBatch(String tableName, String[] columnNames, int batchSize, Object ... args) {
        return this.update(this.getDialect().buildInsertBatchSql(tableName, columnNames, batchSize), args);
    }

    @Override
    public int upsert(String tableName, String[] columnNames, String[] uniqueColumns, Object ... args) {
        return this.update(this.getDialect().buildUpsertSql(tableName, columnNames, uniqueColumns), args);
    }

    @Override
    public <T extends Serializable> int update(String sql, GeneratedKeyHolder<T> keyHolder, Object ... args) {
        return this.updateBatch(sql, 1, keyHolder, args);
    }

    @Override
    public <T extends Serializable> int updateBatch(String sql, int batchSize, GeneratedKeyHolder<T> keySupplier, Object ... args) {
        if (Lang.isNotEmpty((String)sql)) {
            sql = sql.trim();
            return this.executeUpdate(sql, batchSize, keySupplier, args);
        }
        return 0;
    }

    @Override
    public <T extends Serializable> int updateBatch(String sql, int batchSize, GeneratedKeyHolder<T> keySupplier, Map<String, Object> args) {
        if (Lang.isNotEmpty((String)sql)) {
            sql = sql.trim();
            this.logger.debug("sql -> {}, args -> {}", (Object)sql, args);
            Execution execution = SqlUtils.convertNamedParamSql((String)sql, args);
            return this.executeUpdate(execution.getExecution(), batchSize, keySupplier, execution.getParams());
        }
        return 0;
    }

    @Override
    public <T extends Serializable> int update(String sql, GeneratedKeyHolder<T> keySupplier, BeanPropertyValue<?> ... args) {
        if (Lang.isNotEmpty((String)sql)) {
            sql = sql.trim();
            return this.executeUpdate(sql, 1, keySupplier, args);
        }
        return 0;
    }

    @Override
    public <T extends Serializable> int update(String sql, GeneratedKeyHolder<T> keySupplier, Map<String, Object> args) {
        this.logger.debug("sql -> {}, args -> {}", (Object)sql, args);
        Execution execution = SqlUtils.convertNamedParamSql((String)sql, args);
        return this.update(execution.getExecution(), keySupplier, execution.getParams());
    }

    @Override
    public int update(String sql, Map<String, Object> args) {
        this.logger.debug("sql -> {}, args -> {}", (Object)sql, args);
        Execution execution = SqlUtils.convertNamedParamSql((String)sql, args);
        return this.update(execution.getExecution(), execution.getParams());
    }

    @Override
    public int update(String sql, Object ... args) {
        if (Lang.isNotEmpty((String)sql)) {
            sql = sql.trim();
            return this.executeUpdate(sql, 1, args);
        }
        return 0;
    }

    @Override
    public int update(String sql, BeanPropertyValue<?> ... args) {
        if (Lang.isNotEmpty((String)sql)) {
            sql = sql.trim();
            return this.executeUpdate(sql, 1, args);
        }
        return 0;
    }

    private int executeUpdate(String sql, int batchSize, Object ... args) {
        return this.executeUpdate(sql, batchSize, null, args);
    }

    private <T extends Serializable> int executeUpdate(String sql, int batchSize, GeneratedKeyHolder<T> generatedKeyHolder, Object ... args) {
        this.logger.debug("sql -> {}, args -> {}", (Object)sql, (Object)args);
        return this.executeUpdate((PreparedStatement prep) -> this.setParams((PreparedStatement)prep, args), sql, batchSize, generatedKeyHolder, args);
    }

    private int executeUpdate(String sql, int batchSize, BeanPropertyValue<?> ... args) {
        return this.executeUpdate(sql, batchSize, (GeneratedKeyHolder)null, args);
    }

    private <T extends Serializable> int executeUpdate(String sql, int batchSize, GeneratedKeyHolder<T> generatedKeyHolder, BeanPropertyValue<?> ... argsBp) {
        this.logger.debug("sql -> {}, args -> {}", (Object)sql, argsBp);
        return this.executeUpdate((PreparedStatement prep) -> this.setParams((PreparedStatement)prep, argsBp), sql, batchSize, generatedKeyHolder, Arrays.stream(argsBp).map(arg -> arg.getValue()).toArray());
    }

    /*
     * Exception decompiling
     */
    private <T extends Serializable> int executeUpdate(Consumer<PreparedStatement> setParams, String sql, int batchSize, GeneratedKeyHolder<T> generatedKeyHolder, Object ... args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<Map<String, Object>> query(String sql, Map<String, Object> args) {
        this.logger.debug("sql -> {}, args -> {}", (Object)sql, args);
        Execution execution = SqlUtils.convertNamedParamSql((String)sql, args);
        return this.query(execution.getExecution(), execution.getParams());
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Map<String, Object>> query(String sql, Object ... args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public <T> List<T> query(String sql, RowMapper<T> rowMapper, Map<String, Object> args) {
        this.logger.debug("sql -> {}, args -> {}", (Object)sql, args);
        Execution execution = SqlUtils.convertNamedParamSql((String)sql, args);
        return this.query(execution.getExecution(), rowMapper, execution.getParams());
    }

    @Override
    public <T> List<T> query(String sql, Class<T> elementType, Map<String, Object> args) {
        this.logger.debug("sql -> {}, args -> {}, elementType -> {}", new Object[]{sql, args, elementType});
        Execution execution = SqlUtils.convertNamedParamSql((String)sql, args);
        return this.query(execution.getExecution(), elementType, execution.getParams());
    }

    @Override
    public <T> List<T> query(String sql, Class<T> elementType, Object ... args) {
        SQLType sqlType = this.manager.getSqlType(elementType);
        Object rowMapper = null;
        rowMapper = sqlType == null ? new NestedBeanPropertyRowMapper<T>(elementType, this.manager) : new SingleColumnRowMapper<T>(elementType, this.manager);
        return this.query(sql, (RowMapper<T>)rowMapper, args);
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T> List<T> query(String sql, RowMapper<T> rowMapper, Object ... args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Map<String, Object> querySingle(String sql, Map<String, Object> args) {
        return this.singleResult(this.query(sql, args));
    }

    @Override
    public Map<String, Object> querySingle(String sql, Object ... args) {
        return this.singleResult(this.query(sql, args));
    }

    @Override
    public <T> T querySingle(String sql, RowMapper<T> rowMapper, Object ... args) {
        return this.singleResult(this.query(sql, rowMapper, args));
    }

    @Override
    public <T> T querySingle(String sql, RowMapper<T> rowMapper, Map<String, Object> args) {
        return this.singleResult(this.query(sql, rowMapper, args));
    }

    @Override
    public <T> T querySingle(String sql, Class<T> elementType, Map<String, Object> args) {
        return this.singleResult(this.query(sql, elementType, args));
    }

    @Override
    public <T> T querySingle(String sql, Class<T> elementType, Object ... args) {
        return this.singleResult(this.query(sql, elementType, args));
    }

    private <T> T singleResult(Collection<T> results) {
        if (results == null || results.size() <= 0) {
            return null;
        }
        if (results.size() > 1) {
            throw new JdbcException(Strings.format((String)"results size must be 1, but is {0}", (Object)results.size()));
        }
        return results.iterator().next();
    }

    @Override
    public Map<String, Object> queryUnique(String sql, Map<String, Object> args) {
        return this.nullableSingleResult(this.query(sql, args));
    }

    @Override
    public Map<String, Object> queryUnique(String sql, Object ... args) {
        return this.nullableSingleResult(this.query(sql, args));
    }

    @Override
    public <T> T queryUnique(String sql, RowMapper<T> rowMapper, Object ... args) {
        return this.nullableSingleResult(this.query(sql, rowMapper, args));
    }

    @Override
    public <T> T queryUnique(String sql, RowMapper<T> rowMapper, Map<String, Object> args) {
        return this.nullableSingleResult(this.query(sql, rowMapper, args));
    }

    @Override
    public <T> T queryUnique(String sql, Class<T> elementType, Map<String, Object> args) {
        return this.nullableSingleResult(this.query(sql, elementType, args));
    }

    @Override
    public <T> T queryUnique(String sql, Class<T> elementType, Object ... args) {
        return this.nullableSingleResult(this.query(sql, elementType, args));
    }

    private <T> T nullableSingleResult(Collection<T> results) {
        if (Lang.isEmpty(results)) {
            throw new JdbcException("results is empty");
        }
        if (results.size() > 1) {
            throw new JdbcException(Strings.format((String)"results size must be 1, but is {0}", (Object)results.size()));
        }
        return results.iterator().next();
    }

    @Override
    public <T> T queryValue(String sql, Class<T> valueType, Map<String, Object> args) {
        return this.queryValue(sql, new SingleColumnRowMapper<T>(valueType, this.manager), args);
    }

    @Override
    public <T> T queryValue(String sql, Class<T> valueType, Object ... args) {
        return this.queryValue(sql, new SingleColumnRowMapper<T>(valueType, this.manager), args);
    }

    @Override
    public <T> T queryValue(String sql, RowMapper<T> rowMapper, Map<String, Object> args) {
        this.logger.debug("sql -> {}, args -> {}", (Object)sql, args);
        Execution execution = SqlUtils.convertNamedParamSql((String)sql, args);
        return this.queryValue(execution.getExecution(), rowMapper, execution.getParams());
    }

    @Override
    public <T> T queryValue(String sql, RowMapper<T> rowMapper, Object ... args) {
        List<T> results = this.query(sql, rowMapper, args);
        return this.nullableSingleResult(results);
    }

    protected void setParam(PreparedStatement prep, int index, Object arg) {
        if (arg instanceof BeanPropertyValue) {
            BeanPropertyValue bpv = (BeanPropertyValue)arg;
            BeanProperty bp = bpv.getBeanProperty();
            this.manager.set(prep, index, bpv.getValue(), (GenericType)bp);
        } else {
            this.manager.set(prep, index, arg);
        }
    }

    protected void setParams(PreparedStatement prep, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg instanceof BeanPropertyValue) {
                BeanPropertyValue bpv = (BeanPropertyValue)arg;
                BeanProperty argBp = bpv.getBeanProperty();
                this.manager.set(prep, i + 1, bpv.getValue(), (GenericType)argBp);
                continue;
            }
            this.manager.set(prep, i + 1, arg);
        }
    }

    protected void setParams(PreparedStatement prep, BeanPropertyValue<?> ... args) {
        for (int i = 0; i < args.length; ++i) {
            BeanProperty argBp = args[i].getBeanProperty();
            this.manager.set(prep, i + 1, args[i].getValue(), (GenericType)argBp);
        }
    }

    public void addInterceptor(JdbcExecutionInterceptor interceptor) {
        if (interceptor != null) {
            this.interceptors.add(interceptor);
        }
    }

    public void addInterceptor(List<JdbcExecutionInterceptor> interceptors) {
        if (interceptors != null) {
            for (JdbcExecutionInterceptor jdbcExecutionInterceptor : interceptors) {
                this.addInterceptor(jdbcExecutionInterceptor);
            }
        }
    }

    public void addInterceptor(JdbcExecutionInterceptor ... interceptors) {
        if (interceptors != null) {
            for (JdbcExecutionInterceptor jdbcExecutionInterceptor : interceptors) {
                this.addInterceptor(jdbcExecutionInterceptor);
            }
        }
    }

    private JdbcExecution preHandle(String sql, Object ... params) {
        JdbcExecution jdbcExecution = new JdbcExecution(this, sql, params);
        for (JdbcExecutionInterceptor interceptor : this.interceptors) {
            interceptor.preHandle(jdbcExecution);
        }
        return jdbcExecution;
    }

    private <O> O postHandle(JdbcExecution jdbcExecution, String sql, Object ... params) {
        for (JdbcExecutionInterceptor interceptor : this.interceptors) {
            interceptor.postHandle(jdbcExecution);
        }
        return (O)jdbcExecution.getResult();
    }

    protected abstract void releaseConnection(Connection var1, DataSource var2);

    protected abstract Connection getConnection(DataSource var1);
}

