/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.dsl.query;

import cn.featherfly.common.db.dialect.Join;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.repository.builder.AliasManager;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.MappingFactory;
import cn.featherfly.common.repository.mapping.RowMapper;
import cn.featherfly.common.repository.operate.AggregateFunction;
import cn.featherfly.common.structure.page.Page;
import cn.featherfly.hammer.dsl.query.QueryConditionGroupExpression;
import cn.featherfly.hammer.dsl.query.QueryEntityProperties;
import cn.featherfly.hammer.dsl.query.QuerySortExpression;
import cn.featherfly.hammer.expression.query.QueryLimitExecutor;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.SqlPageFactory;
import cn.featherfly.hammer.sqldb.jdbc.dsl.query.AbstractSqlQueryEntityProperties;
import cn.featherfly.hammer.sqldb.jdbc.dsl.query.SqlQueryEntity;
import cn.featherfly.hammer.sqldb.jdbc.dsl.query.SqlQueryExpression;
import cn.featherfly.hammer.sqldb.jdbc.dsl.query.SqlQueryWith;
import cn.featherfly.hammer.sqldb.jdbc.dsl.query.SqlQueryWithOn;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class SqlQueryEntityProperties
extends AbstractSqlQueryEntityProperties<SqlQueryEntityProperties>
implements SqlQueryEntity,
QueryEntityProperties {
    public SqlQueryEntityProperties(Jdbc jdbc, DatabaseMetadata databaseMetadata, String tableName, MappingFactory factory, SqlPageFactory sqlPageFactory, AliasManager aliasManager, Predicate<Object> ignorePolicy) {
        this(jdbc, databaseMetadata, tableName, aliasManager.put(tableName), factory, sqlPageFactory, aliasManager, ignorePolicy);
    }

    public SqlQueryEntityProperties(Jdbc jdbc, ClassMapping<?> classMapping, MappingFactory factory, SqlPageFactory sqlPageFactory, AliasManager aliasManager, Predicate<Object> ignorePolicy) {
        super(jdbc, classMapping, factory, sqlPageFactory, aliasManager, ignorePolicy);
    }

    public SqlQueryEntityProperties(Jdbc jdbc, DatabaseMetadata databaseMetadata, String tableName, String tableAlias, MappingFactory factory, SqlPageFactory sqlPageFactory, AliasManager aliasManager, Predicate<Object> ignorePolicy) {
        super(jdbc, databaseMetadata, tableName, tableAlias, factory, sqlPageFactory, aliasManager, ignorePolicy);
    }

    public QueryConditionGroupExpression where() {
        return new SqlQueryExpression(this.jdbc, this.sqlPageFactory, this.classMapping, this.selectBuilder, (Predicate<Object>)this.ignorePolicy);
    }

    public QueryConditionGroupExpression where(Consumer<QueryConditionGroupExpression> consumer) {
        SqlQueryExpression sqlQueryExpression = new SqlQueryExpression(this.jdbc, this.sqlPageFactory, this.classMapping, this.selectBuilder, (Predicate<Object>)this.ignorePolicy);
        if (consumer != null) {
            consumer.accept(sqlQueryExpression);
        }
        return sqlQueryExpression;
    }

    public List<Map<String, Object>> list() {
        return new SqlQueryExpression(this.jdbc, this.sqlPageFactory, this.classMapping, this.selectBuilder, (Predicate<Object>)this.ignorePolicy).list();
    }

    public <E> List<E> list(Class<E> type) {
        return new SqlQueryExpression(this.jdbc, this.sqlPageFactory, this.classMapping, this.selectBuilder, (Predicate<Object>)this.ignorePolicy).list(type);
    }

    public <E> List<E> list(RowMapper<E> rowMapper) {
        return new SqlQueryExpression(this.jdbc, this.sqlPageFactory, this.classMapping, this.selectBuilder, (Predicate<Object>)this.ignorePolicy).list(rowMapper);
    }

    public QueryLimitExecutor limit(Integer limit) {
        return new SqlQueryExpression(this.jdbc, this.sqlPageFactory, this.classMapping, this.selectBuilder, (Predicate<Object>)this.ignorePolicy).limit(limit);
    }

    public QueryLimitExecutor limit(Integer offset, Integer limit) {
        return new SqlQueryExpression(this.jdbc, this.sqlPageFactory, this.classMapping, this.selectBuilder, (Predicate<Object>)this.ignorePolicy).limit(offset, limit);
    }

    public QueryLimitExecutor limit(Page page) {
        return new SqlQueryExpression(this.jdbc, this.sqlPageFactory, this.classMapping, this.selectBuilder, (Predicate<Object>)this.ignorePolicy).limit(page);
    }

    public String string() {
        return new SqlQueryExpression(this.jdbc, this.sqlPageFactory, this.classMapping, this.selectBuilder, (Predicate<Object>)this.ignorePolicy).string();
    }

    public Integer integer() {
        return new SqlQueryExpression(this.jdbc, this.sqlPageFactory, this.classMapping, this.selectBuilder, (Predicate<Object>)this.ignorePolicy).integer();
    }

    public Long longInt() {
        return new SqlQueryExpression(this.jdbc, this.sqlPageFactory, this.classMapping, this.selectBuilder, (Predicate<Object>)this.ignorePolicy).longInt();
    }

    public BigDecimal decimal() {
        return new SqlQueryExpression(this.jdbc, this.sqlPageFactory, this.classMapping, this.selectBuilder, (Predicate<Object>)this.ignorePolicy).decimal();
    }

    public <N extends Number> N number(Class<N> type) {
        return new SqlQueryExpression(this.jdbc, this.sqlPageFactory, this.classMapping, this.selectBuilder, (Predicate<Object>)this.ignorePolicy).number(type);
    }

    public Long count() {
        return new SqlQueryExpression(this.jdbc, this.sqlPageFactory, this.classMapping, this.selectBuilder.addSelectColumn("*", AggregateFunction.COUNT), (Predicate<Object>)this.ignorePolicy).longInt();
    }

    public SqlQueryWithOn with(String repositoryName) {
        return this.join(repositoryName);
    }

    @Override
    public SqlQueryWithOn join(String repositoryName) {
        return this.join(Join.INNER_JOIN, repositoryName);
    }

    @Override
    public SqlQueryWithOn join(Join join, String repositoryName) {
        return new SqlQueryWith(this, this.aliasManager, this.factory, this.sqlPageFactory, this.selectBuilder.getTableAlias(), this.getIdName(), repositoryName, this.aliasManager.put(repositoryName), join, this.ignorePolicy);
    }

    public <T> SqlQueryWithOn with(Class<T> repositoryType) {
        return this.join(repositoryType);
    }

    @Override
    public <T> SqlQueryWithOn join(Class<T> repositoryType) {
        return this.join(Join.INNER_JOIN, repositoryType);
    }

    @Override
    public <T> SqlQueryWithOn join(Join join, Class<T> repositoryType) {
        return new SqlQueryWith(this, this.aliasManager, this.factory, this.sqlPageFactory, this.selectBuilder.getTableAlias(), this.getIdName(), repositoryType, join, (Predicate<Object>)this.ignorePolicy);
    }

    public QuerySortExpression sort() {
        return new SqlQueryExpression(this.jdbc, this.sqlPageFactory, this.classMapping, this.selectBuilder, (Predicate<Object>)this.ignorePolicy).sort();
    }
}

