/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.bean.BeanDescriptor;
import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.bean.NoSuchPropertyException;
import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.mapping.JdbcMappingException;
import cn.featherfly.common.db.mapping.SqlResultSet;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.repository.mapping.ResultSet;
import cn.featherfly.common.repository.mapping.RowMapper;
import cn.featherfly.hammer.sqldb.jdbc.ClassMapperObjectFactory;
import cn.featherfly.hammer.sqldb.jdbc.MapperObjectFactory;
import cn.featherfly.hammer.sqldb.jdbc.MappingDebugMessage;
import java.beans.PropertyDescriptor;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class NestedBeanPropertyRowMapper<T>
implements org.springframework.jdbc.core.RowMapper<T>,
RowMapper<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nullable
    private Class<T> mappedClass;
    private boolean checkFullyPopulated = false;
    private boolean primitivesDefaultedForNullValue = false;
    @Nullable
    private ConversionService conversionService = DefaultConversionService.getSharedInstance();
    @Nullable
    private Map<String, PropertyDescriptor> mappedFields;
    @Nullable
    private Set<String> mappedProperties;
    @Nullable
    private SqlTypeMappingManager manager;
    @Nullable
    private MapperObjectFactory<T> mapperObjectFactory;
    private List<Mapping> mappings;

    public NestedBeanPropertyRowMapper(Class<T> mappedClass, SqlTypeMappingManager manager) {
        this(mappedClass, manager, false);
    }

    public NestedBeanPropertyRowMapper(Class<T> mappedClass, SqlTypeMappingManager manager, boolean checkFullyPopulated) {
        this(new ClassMapperObjectFactory<T>(mappedClass), manager, checkFullyPopulated);
    }

    public NestedBeanPropertyRowMapper(MapperObjectFactory<T> mapperObjectFactory, SqlTypeMappingManager manager) {
        this(mapperObjectFactory, manager, false);
    }

    public NestedBeanPropertyRowMapper(MapperObjectFactory<T> mapperObjectFactory, SqlTypeMappingManager manager, boolean checkFullyPopulated) {
        this.manager = manager;
        this.mapperObjectFactory = mapperObjectFactory;
        this.checkFullyPopulated = checkFullyPopulated;
    }

    public void setCheckFullyPopulated(boolean checkFullyPopulated) {
        this.checkFullyPopulated = checkFullyPopulated;
    }

    public boolean isCheckFullyPopulated() {
        return this.checkFullyPopulated;
    }

    public void setPrimitivesDefaultedForNullValue(boolean primitivesDefaultedForNullValue) {
        this.primitivesDefaultedForNullValue = primitivesDefaultedForNullValue;
    }

    public boolean isPrimitivesDefaultedForNullValue() {
        return this.primitivesDefaultedForNullValue;
    }

    public void setConversionService(@Nullable ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Nullable
    public ConversionService getConversionService() {
        return this.conversionService;
    }

    protected void initialize(Class<T> mappedClass) {
        PropertyDescriptor[] pds;
        AssertIllegalArgument.isNotNull(mappedClass, (String)"mappedClass");
        this.mappedClass = mappedClass;
        this.mappedFields = new HashMap<String, PropertyDescriptor>();
        this.mappedProperties = new HashSet<String>();
        for (PropertyDescriptor pd : pds = BeanUtils.getPropertyDescriptors(mappedClass)) {
            if (pd.getWriteMethod() == null) continue;
            this.mappedFields.put(this.lowerCaseName(pd.getName()), pd);
            String underscoredName = this.underscoreName(pd.getName());
            if (!this.lowerCaseName(pd.getName()).equals(underscoredName)) {
                this.mappedFields.put(underscoredName, pd);
            }
            this.mappedProperties.add(pd.getName());
        }
    }

    protected String underscoreName(String name) {
        if (!StringUtils.hasLength((String)name)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(this.lowerCaseName(name.substring(0, 1)));
        for (int i = 1; i < name.length(); ++i) {
            String slc;
            String s = name.substring(i, i + 1);
            if (!s.equals(slc = this.lowerCaseName(s))) {
                result.append("_").append(slc);
                continue;
            }
            result.append(s);
        }
        return result.toString();
    }

    protected String lowerCaseName(String name) {
        return name.toLowerCase(Locale.US);
    }

    public T mapRow(ResultSet res, int rowNum) {
        java.sql.ResultSet rs = null;
        if (!(res instanceof SqlResultSet)) {
            throw new JdbcMappingException("ResultSet is not type of SqlResultSet");
        }
        SqlResultSet sqlrs = (SqlResultSet)res;
        rs = sqlrs.getResultSet();
        AssertIllegalArgument.isNotNull((Object)rs, (String)"java.sql.ResultSet");
        try {
            return this.mapRow(rs, rowNum);
        }
        catch (SQLException e) {
            throw new JdbcException((Throwable)e);
        }
    }

    public T mapRow(java.sql.ResultSet rs, int rowNumber) throws SQLException {
        BeanDescriptor beanDescriptor;
        T mappedObject = this.mapperObjectFactory.create(rs);
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess(mappedObject);
        this.initBeanWrapper(bw);
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        HashSet<String> populatedProperties = this.isCheckFullyPopulated() ? new HashSet<String>() : null;
        MappingDebugMessage mappingDebugMessage = new MappingDebugMessage();
        if (rowNumber == 0) {
            this.mappings = new ArrayList<Mapping>();
            Class<?> mappedType = mappedObject.getClass();
            this.initialize(mappedType);
            beanDescriptor = BeanDescriptor.getBeanDescriptor(this.mappedClass);
            for (int index = 1; index <= columnCount; ++index) {
                Mapping mapping = new Mapping();
                this.mappings.add(mapping);
                String column = JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)index);
                String field = this.lowerCaseName(StringUtils.delete((String)column, (String)" "));
                boolean nestedProperty = false;
                if (field.contains(".")) {
                    nestedProperty = true;
                    field = org.apache.commons.lang3.StringUtils.substringBefore((String)field, (String)".");
                }
                mapping.column = rsmd.getColumnName(index);
                mapping.columnAs = column;
                PropertyDescriptor pd = this.mappedFields != null ? this.mappedFields.get(field) : null;
                mapping.propertyDescriptor = pd;
                if (pd != null) {
                    BeanProperty bp;
                    if (nestedProperty) {
                        bp = beanDescriptor.getChildBeanProperty(column);
                        mapping.property = column;
                        mapping.propertyTypeName = bp.getType().getName();
                        mapping.beanProperty = bp;
                    } else {
                        try {
                            bp = beanDescriptor.getChildBeanProperty(pd.getName());
                            mapping.property = pd.getName();
                            mapping.propertyTypeName = bp.getType().getName();
                            mapping.beanProperty = bp;
                        }
                        catch (NoSuchPropertyException e) {
                            this.logger.debug(e.getMessage());
                            mapping.property = pd.getName();
                            mapping.propertyTypeName = ClassUtils.getQualifiedName(pd.getPropertyType());
                        }
                    }
                    if (this.logger.isDebugEnabled()) {
                        mappingDebugMessage.addMapping(mapping.column, mapping.columnAs, mapping.property, mapping.propertyTypeName);
                    }
                    if (populatedProperties == null) continue;
                    populatedProperties.add(mapping.propertyDescriptor.getName());
                    continue;
                }
                this.logger.debug("No property found for column '" + column + "' mapped to field '" + field + "'");
            }
            if (this.logger.isDebugEnabled()) {
                StringBuilder debugMessage = new StringBuilder();
                debugMessage.append("\n---------- Map " + this.mappedClass.getName() + " Start ----------\n").append(mappingDebugMessage.toString()).append("---------- Map " + this.mappedClass.getName() + " End ----------");
                this.logger.debug(debugMessage.toString());
            }
        }
        Assert.state((this.mappedClass != null ? 1 : 0) != 0, (String)"Mapped class was not specified");
        for (int index = 1; index <= this.mappings.size(); ++index) {
            beanDescriptor = BeanDescriptor.getBeanDescriptor(this.mappedClass);
            Mapping mapping = this.mappings.get(index - 1);
            if (mapping.propertyDescriptor == null) continue;
            try {
                Object value = null;
                if (mapping.beanProperty != null) {
                    value = this.manager.get(rs, index, mapping.beanProperty);
                    beanDescriptor.setProperty(mappedObject, mapping.property, value);
                    continue;
                }
                value = this.getColumnValue(rs, index, mapping.propertyDescriptor);
                try {
                    bw.setPropertyValue(mapping.propertyDescriptor.getName(), value);
                    continue;
                }
                catch (TypeMismatchException ex) {
                    if (value == null && this.primitivesDefaultedForNullValue) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Intercepted TypeMismatchException for row " + rowNumber + " and column '" + mapping.columnAs + "' with null value when setting property '" + mapping.propertyDescriptor.getName() + "' of type '" + ClassUtils.getQualifiedName(mapping.propertyDescriptor.getPropertyType()) + "' on object: " + mappedObject, (Throwable)ex);
                        }
                        continue;
                    }
                    throw ex;
                }
            }
            catch (NotWritablePropertyException ex) {
                throw new DataRetrievalFailureException("Unable to map column '" + mapping.columnAs + "' to property '" + mapping.property + "'", (Throwable)ex);
            }
        }
        if (populatedProperties != null && !populatedProperties.equals(this.mappedProperties)) {
            throw new InvalidDataAccessApiUsageException("Given ResultSet does not contain all fields necessary to populate object of class [" + this.mappedClass.getName() + "]: " + this.mappedProperties);
        }
        return mappedObject;
    }

    protected void initBeanWrapper(BeanWrapper bw) {
        ConversionService cs = this.getConversionService();
        if (cs != null) {
            bw.setConversionService(cs);
        }
    }

    @Nullable
    protected Object getColumnValue(java.sql.ResultSet rs, int index, PropertyDescriptor pd) throws SQLException {
        return JdbcUtils.getResultSetValue((java.sql.ResultSet)rs, (int)index, pd.getPropertyType());
    }

    public static class Mapping {
        String column;
        String columnAs;
        String property;
        String propertyTypeName;
        BeanProperty<?> beanProperty;
        private PropertyDescriptor propertyDescriptor;
    }
}

