/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractBatchExecuteOperate;
import com.speedment.common.tuple.Tuple2;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class DeleteOperate<T>
extends AbstractBatchExecuteOperate<T> {
    public DeleteOperate(Jdbc jdbc, ClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager) {
        super(jdbc, classMapping, sqlTypeMappingManager);
    }

    public DeleteOperate(Jdbc jdbc, ClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, String dataBase) {
        super(jdbc, classMapping, sqlTypeMappingManager, dataBase);
    }

    public DeleteOperate(Jdbc jdbc, ClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, sqlTypeMappingManager, databaseMetadata);
    }

    public int delete(Serializable id) {
        return this.jdbc.update(this.sql, id);
    }

    public int deleteBatch(Serializable ... ids) {
        return this.deleteBatch(ArrayUtils.toList((Object[])ids));
    }

    public <ID extends Serializable> int deleteBatch(List<ID> ids) {
        if (Lang.isEmpty(ids)) {
            return 0;
        }
        Tuple2 tuple = ClassMappingUtils.getDeleteSqlAndParamPositions((int)ids.size(), (ClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        return this.jdbc.update((String)tuple.get0(), ids.toArray());
    }

    @Override
    public int executeBatch(List<T> entities, int batchSize) {
        if (Lang.isEmpty(entities)) {
            return 0;
        }
        int bs = batchSize;
        if (entities.size() <= batchSize) {
            bs = entities.size();
            Tuple2 tuple = ClassMappingUtils.getDeleteSqlAndParamPositions((int)bs, (ClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
            return this.jdbc.updateBatch((String)tuple.get0(), bs, this.getBatchParameters(entities, (Map)tuple.get1()));
        }
        int size = 0;
        int len = entities.size() / batchSize;
        for (int i = 0; i < len; ++i) {
            if (i == len - 1) {
                bs = entities.size() - batchSize * i;
            }
            Tuple2 tuple = ClassMappingUtils.getDeleteSqlAndParamPositions((int)bs, (ClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
            size += this.jdbc.updateBatch((String)tuple.get0(), bs, this.getBatchParameters(entities, (Map)tuple.get1()));
        }
        return size;
    }

    @Override
    protected void initSql() {
        Tuple2 tuple = ClassMappingUtils.getDeleteSqlAndParamPositions((ClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        this.sql = (String)tuple.get0();
        this.propertyPositions.putAll((Map)tuple.get1());
        this.logger.debug("sql: {}", (Object)this.sql);
    }

    protected Object[] getBatchParameters(List<T> entities, Map<Integer, String> propertyPositions) {
        if (Lang.isEmpty(entities)) {
            return new Object[0];
        }
        Object[] params = new Object[propertyPositions.size()];
        int pkNum = propertyPositions.size() / entities.size();
        int i = 0;
        Object entity = null;
        for (Map.Entry<Integer, String> propertyPosition : propertyPositions.entrySet()) {
            if (i % pkNum == 0) {
                entity = entities.get(i / pkNum);
            }
            params[i] = BeanUtils.getProperty(entity, (String)propertyPosition.getValue());
            ++i;
        }
        return params;
    }
}

