/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.sql.dml;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.builder.BuilderUtils;
import cn.featherfly.common.db.builder.SqlBuilder;
import cn.featherfly.common.db.builder.dml.SqlLogicExpression;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.LambdaUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.lang.function.SerializableFunction;
import cn.featherfly.common.lang.function.SerializableSupplier;
import cn.featherfly.common.repository.IgnorePolicy;
import cn.featherfly.common.repository.builder.BuilderException;
import cn.featherfly.common.repository.builder.BuilderExceptionCode;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.MappingFactory;
import cn.featherfly.common.repository.mapping.PropertyMapping;
import cn.featherfly.hammer.expression.condition.Expression;
import cn.featherfly.hammer.expression.condition.LogicOperatorExpression;
import cn.featherfly.hammer.expression.condition.ParamedExpression;
import com.speedment.common.tuple.Tuple2;
import com.speedment.common.tuple.Tuple3;
import com.speedment.common.tuple.Tuples;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public abstract class AbstractSqlConditionExpression<L>
implements SqlBuilder,
ParamedExpression {
    private List<Expression> conditions = new ArrayList<Expression>();
    protected L parent;
    protected Dialect dialect;
    private Expression previousCondition;
    protected Predicate<Object> ignorePolicy = IgnorePolicy.EMPTY;

    public AbstractSqlConditionExpression(Dialect dialect, Predicate<Object> ignorePolicy) {
        this(dialect, ignorePolicy, null);
    }

    protected AbstractSqlConditionExpression(Dialect dialect, Predicate<Object> ignorePolicy, L parent) {
        AssertIllegalArgument.isNotNull(ignorePolicy, (String)"ignorePolicy");
        this.ignorePolicy = ignorePolicy;
        this.dialect = dialect;
        this.parent = parent;
    }

    public String build() {
        Expression last;
        StringBuilder result = new StringBuilder();
        if (this.conditions.size() > 0 && (last = this.conditions.get(this.conditions.size() - 1)) instanceof LogicOperatorExpression) {
            throw new BuilderException(BuilderExceptionCode.createNoConditionBehindCode((String)((SqlLogicExpression)last).getLogicOperator().name()));
        }
        ArrayList<String> availableConditions = new ArrayList<String>();
        ArrayList<Expression> availableExpressions = new ArrayList<Expression>();
        for (Expression expression : this.conditions) {
            Expression pre;
            String condition = expression.expression();
            if (Strings.isNotBlank((String)condition)) {
                availableConditions.add(condition);
                availableExpressions.add(expression);
                continue;
            }
            if (availableExpressions.size() <= 0 || !((pre = (Expression)availableExpressions.get(availableExpressions.size() - 1)) instanceof LogicOperatorExpression)) continue;
            availableExpressions.remove(availableExpressions.size() - 1);
            availableConditions.remove(availableConditions.size() - 1);
        }
        if (availableExpressions.size() > 0) {
            if (availableExpressions.get(0) instanceof LogicOperatorExpression) {
                availableExpressions.remove(0);
                availableConditions.remove(0);
            }
            if (availableExpressions.get(availableExpressions.size() - 1) instanceof LogicOperatorExpression) {
                availableExpressions.remove(availableExpressions.size() - 1);
                availableConditions.remove(availableConditions.size() - 1);
            }
        }
        for (String condition : availableConditions) {
            BuilderUtils.link((StringBuilder)result, (String)condition);
        }
        if (result.length() > 0 && this.parent != null) {
            return " ( " + result.toString() + " ) ";
        }
        return result.toString();
    }

    public String expression() {
        return this.build();
    }

    public Object getParam() {
        return this.getParams();
    }

    public List<Object> getParams() {
        ArrayList<Object> params = new ArrayList<Object>();
        for (Expression condition : this.conditions) {
            Object param;
            if (!(condition instanceof ParamedExpression) || this.ignorePolicy.test(param = ((ParamedExpression)condition).getParam())) continue;
            if (param == null) {
                params.add(param);
                continue;
            }
            if (param instanceof Collection) {
                params.addAll((Collection)param);
                continue;
            }
            if (param.getClass().isArray()) {
                int length = Array.getLength(param);
                for (int i = 0; i < length; ++i) {
                    params.add(Array.get(param, i));
                }
                continue;
            }
            params.add(param);
        }
        return params;
    }

    public String toString() {
        return this.build();
    }

    protected <T, R> String getPropertyName(SerializableFunction<T, R> name) {
        return LambdaUtils.getLambdaPropertyName(name);
    }

    protected Object addCondition(Expression condition) {
        if (this.previousCondition != null && this.previousCondition.getClass().isInstance(condition)) {
            throw new BuilderException(BuilderExceptionCode.createNextToSameConditionCode((String)condition.getClass().getName()));
        }
        this.previousCondition = condition;
        this.conditions.add(condition);
        return this;
    }

    protected <R> List<Tuple2<String, Optional<R>>> supplier(LambdaUtils.SerializableSupplierLambdaInfo<R> info, ClassMapping<?> classMapping) {
        PropertyMapping propertyMapping;
        ArrayList<Tuple2<String, Optional<R>>> list = new ArrayList<Tuple2<String, Optional<R>>>();
        String propertyName = info.getSerializedLambdaInfo().getPropertyName();
        Object r = info.getValue();
        if (r != null && classMapping != null && Lang.isNotEmpty((Collection)(propertyMapping = classMapping.getPropertyMapping(propertyName)).getPropertyMappings())) {
            for (PropertyMapping pm : propertyMapping.getPropertyMappings()) {
                Object obj = BeanUtils.getProperty((Object)r, (String)pm.getPropertyName());
                Optional<Object> optional = Optional.empty();
                if (obj != null) {
                    optional = Optional.of(obj);
                }
                list.add(Tuples.of((Object)pm.getRepositoryFieldName(), optional));
            }
            return list;
        }
        list.add(Tuples.of((Object)propertyName, Optional.of(r)));
        return list;
    }

    protected <O, T, R> Tuple2<String, String> conditionResult(SerializableFunction<O, T> repository, SerializableFunction<T, R> property, Object value, MappingFactory factory) {
        LambdaUtils.SerializedLambdaInfo repositoryInfo = LambdaUtils.getLambdaInfo(repository);
        LambdaUtils.SerializedLambdaInfo propertyInfo = LambdaUtils.getLambdaInfo(property);
        String pn = propertyInfo.getPropertyName();
        ClassMapping cm = factory.getClassMapping(repositoryInfo.getPropertyType());
        String column = ClassMappingUtils.getColumnName((String)pn, (ClassMapping)cm);
        return Tuples.of((Object)repositoryInfo.getPropertyName(), (Object)column);
    }

    protected <T, R> Tuple3<String, String, Object> conditionResult(SerializableSupplier<T> repository, SerializableFunction<T, R> property, MappingFactory factory) {
        LambdaUtils.SerializableSupplierLambdaInfo repositoryInfo = LambdaUtils.getSerializableSupplierLambdaInfo(repository);
        LambdaUtils.SerializedLambdaInfo propertyInfo = LambdaUtils.getLambdaInfo(property);
        String pn = propertyInfo.getPropertyName();
        Object obj = repositoryInfo.getValue();
        ClassMapping cm = factory.getClassMapping(repositoryInfo.getSerializedLambdaInfo().getPropertyType());
        String column = ClassMappingUtils.getColumnName((String)pn, (ClassMapping)cm);
        return Tuples.of((Object)repositoryInfo.getSerializedLambdaInfo().getPropertyName(), (Object)column, (Object)BeanUtils.getProperty((Object)obj, (String)pn));
    }

    public Predicate<Object> getIgnorePolicy() {
        return this.ignorePolicy;
    }

    public List<Expression> getConditions() {
        return this.conditions;
    }
}

