/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.bean.BeanPropertyValue;
import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.repository.mapping.RowMapper;
import cn.featherfly.hammer.sqldb.jdbc.GeneratedKeyHolder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public interface Jdbc {
    public DataSource getDataSource();

    public Dialect getDialect();

    default public int insert(String tableName, String[] columnNames, Object ... args) {
        return this.insert(tableName, columnNames, null, args);
    }

    public <T extends Serializable> int insert(String var1, String[] var2, GeneratedKeyHolder<T> var3, Object ... var4);

    default public int insert(String tableName, Map<String, Object> columnParams) {
        return this.insert(tableName, columnParams, null);
    }

    default public <T extends Serializable> int insert(String tableName, Map<String, Object> columnParams, GeneratedKeyHolder<T> keyHolder) {
        int i = 0;
        String[] columns = new String[columnParams.size()];
        Object[] params = new Object[columnParams.size()];
        for (Map.Entry<String, Object> entry : columnParams.entrySet()) {
            columns[i] = entry.getKey();
            params[i] = entry.getValue();
            ++i;
        }
        return this.insert(tableName, columns, keyHolder, params);
    }

    default public int insertBatch(String tableName, String[] columnNames, Object ... args) {
        if (args.length % columnNames.length != 0) {
            throw new JdbcException("batch size is not explicit (args.length % columnNames.length != 0)");
        }
        return this.insertBatch(tableName, columnNames, args.length / columnNames.length, args);
    }

    default public int insertBatch(String tableName, List<Map<String, Object>> columnParams) {
        if (columnParams.size() == 0) {
            return 0;
        }
        int i = 0;
        int columnLen = columnParams.get(0).size();
        int paramLen = columnLen * columnParams.size();
        String[] columns = new String[columnLen];
        Object[] params = new Object[paramLen];
        for (Map.Entry<String, Object> entry : columnParams.get(0).entrySet()) {
            columns[i] = entry.getKey();
            ++i;
        }
        i = 0;
        for (Map map : columnParams) {
            for (Map.Entry entry : map.entrySet()) {
                params[i] = entry.getValue();
                ++i;
            }
        }
        return this.insertBatch(tableName, columns, columnParams.size(), params);
    }

    public int insertBatch(String var1, String[] var2, int var3, Object ... var4);

    default public int upsert(String tableName, String[] columnNames, String uniqueColumn, Object ... args) {
        return this.upsert(tableName, columnNames, new String[]{uniqueColumn}, args);
    }

    public int upsert(String var1, String[] var2, String[] var3, Object ... var4);

    default public int upsert(String tableName, String uniqueColumn, Map<String, Object> params) {
        return this.upsert(tableName, new String[]{uniqueColumn}, params);
    }

    default public int upsert(String tableName, String[] uniqueColumns, Map<String, Object> params) {
        Object[] ps = new Object[params.size()];
        String[] columnNames = new String[params.size()];
        int i = 0;
        for (Map.Entry<String, Object> e : params.entrySet()) {
            columnNames[i] = e.getKey();
            ps[i] = e.getValue();
            ++i;
        }
        return this.upsert(tableName, columnNames, uniqueColumns, ps);
    }

    public int update(String var1, Object ... var2);

    public int update(String var1, BeanPropertyValue<?> ... var2);

    public int update(String var1, Map<String, Object> var2);

    public <T extends Serializable> int update(String var1, GeneratedKeyHolder<T> var2, Object ... var3);

    public <T extends Serializable> int update(String var1, GeneratedKeyHolder<T> var2, BeanPropertyValue<?> ... var3);

    public <T extends Serializable> int update(String var1, GeneratedKeyHolder<T> var2, Map<String, Object> var3);

    default public <T extends Serializable> int updateBatch(String sql, int batchSize, Object ... args) {
        return this.updateBatch(sql, batchSize, null, args);
    }

    default public int updateBatch(String sql, int batchSize, Map<String, Object> args) {
        return this.updateBatch(sql, batchSize, null, args);
    }

    public <T extends Serializable> int updateBatch(String var1, int var2, GeneratedKeyHolder<T> var3, Map<String, Object> var4);

    public <T extends Serializable> int updateBatch(String var1, int var2, GeneratedKeyHolder<T> var3, Object ... var4);

    public List<Map<String, Object>> query(String var1, Object ... var2);

    public List<Map<String, Object>> query(String var1, Map<String, Object> var2);

    public <T> List<T> query(String var1, RowMapper<T> var2, Object ... var3);

    public <T> List<T> query(String var1, Class<T> var2, Object ... var3);

    public <T> List<T> query(String var1, RowMapper<T> var2, Map<String, Object> var3);

    public <T> List<T> query(String var1, Class<T> var2, Map<String, Object> var3);

    public Map<String, Object> querySingle(String var1, Map<String, Object> var2);

    public Map<String, Object> querySingle(String var1, Object ... var2);

    public <T> T querySingle(String var1, RowMapper<T> var2, Object ... var3);

    public <T> T querySingle(String var1, RowMapper<T> var2, Map<String, Object> var3);

    public <T> T querySingle(String var1, Class<T> var2, Map<String, Object> var3);

    public <T> T querySingle(String var1, Class<T> var2, Object ... var3);

    public Map<String, Object> queryUnique(String var1, Map<String, Object> var2);

    public Map<String, Object> queryUnique(String var1, Object ... var2);

    public <T> T queryUnique(String var1, RowMapper<T> var2, Object ... var3);

    public <T> T queryUnique(String var1, RowMapper<T> var2, Map<String, Object> var3);

    public <T> T queryUnique(String var1, Class<T> var2, Map<String, Object> var3);

    public <T> T queryUnique(String var1, Class<T> var2, Object ... var3);

    default public Integer queryInt(String sql, Object ... args) {
        return this.queryValue(sql, Integer.class, args);
    }

    default public Integer queryInt(String sql, Map<String, Object> args) {
        return this.queryValue(sql, Integer.class, args);
    }

    default public Long queryLong(String sql, Object ... args) {
        return this.queryValue(sql, Long.class, args);
    }

    default public Long queryLong(String sql, Map<String, Object> args) {
        return this.queryValue(sql, Long.class, args);
    }

    default public BigDecimal queryBigDecimal(String sql, Object ... args) {
        return this.queryValue(sql, BigDecimal.class, args);
    }

    default public BigDecimal queryBigDecimal(String sql, Map<String, Object> args) {
        return this.queryValue(sql, BigDecimal.class, args);
    }

    default public Double queryDouble(String sql, Object ... args) {
        return this.queryValue(sql, Double.class, args);
    }

    default public Double queryDouble(String sql, Map<String, Object> args) {
        return this.queryValue(sql, Double.class, args);
    }

    default public String queryString(String sql, Object ... args) {
        return this.queryValue(sql, String.class, args);
    }

    default public String queryString(String sql, Map<String, Object> args) {
        return this.queryValue(sql, String.class, args);
    }

    public <T> T queryValue(String var1, Class<T> var2, Object ... var3);

    public <T> T queryValue(String var1, Class<T> var2, Map<String, Object> var3);

    public <T> T queryValue(String var1, RowMapper<T> var2, Object ... var3);

    public <T> T queryValue(String var1, RowMapper<T> var2, Map<String, Object> var3);
}

