/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.dsl.query;

import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.IgnorePolicy;
import cn.featherfly.common.repository.builder.AliasManager;
import cn.featherfly.common.repository.mapping.MappingFactory;
import cn.featherfly.hammer.dsl.query.Query;
import cn.featherfly.hammer.expression.Repository;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.SqlPageFactory;
import cn.featherfly.hammer.sqldb.jdbc.dsl.query.SqlQueryEntityProperties;
import cn.featherfly.hammer.sqldb.jdbc.dsl.query.TypeSqlQueryEntityProperties;
import java.util.function.Predicate;

public class SqlQuery
implements Query {
    private Jdbc jdbc;
    private DatabaseMetadata databaseMetadata;
    private JdbcMappingFactory mappingFactory;
    private SqlPageFactory sqlPageFactory;

    public SqlQuery(Jdbc jdbc, DatabaseMetadata databaseMetadata, SqlPageFactory sqlPageFactory) {
        this.jdbc = jdbc;
        this.databaseMetadata = databaseMetadata;
        this.sqlPageFactory = sqlPageFactory;
    }

    public SqlQuery(Jdbc jdbc, JdbcMappingFactory mappingFactory, SqlPageFactory sqlPageFactory) {
        this.jdbc = jdbc;
        this.mappingFactory = mappingFactory;
        this.databaseMetadata = mappingFactory.getMetadata();
        this.sqlPageFactory = sqlPageFactory;
    }

    public SqlQueryEntityProperties find(Repository repository) {
        if (repository == null) {
            return null;
        }
        AliasManager aliasManager = new AliasManager();
        String alias = repository.alias();
        if (Lang.isNotEmpty((String)alias)) {
            aliasManager.put(repository.name(), alias);
        } else {
            alias = aliasManager.put(repository.name());
        }
        return new SqlQueryEntityProperties(this.jdbc, this.databaseMetadata, repository.name(), alias, (MappingFactory)this.mappingFactory, this.sqlPageFactory, aliasManager, (Predicate<Object>)IgnorePolicy.EMPTY);
    }

    public SqlQueryEntityProperties find(String tableName) {
        return new SqlQueryEntityProperties(this.jdbc, this.databaseMetadata, tableName, (MappingFactory)this.mappingFactory, this.sqlPageFactory, new AliasManager(), (Predicate<Object>)IgnorePolicy.EMPTY);
    }

    public TypeSqlQueryEntityProperties find(Class<?> repositType) {
        if (this.mappingFactory == null) {
            throw new SqldbHammerException("mappingFactory is null");
        }
        return new TypeSqlQueryEntityProperties(this.jdbc, this.mappingFactory.getClassMapping(repositType), (MappingFactory)this.mappingFactory, this.sqlPageFactory, new AliasManager(), (Predicate<Object>)IgnorePolicy.EMPTY);
    }
}

