/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.dsl.execute;

import cn.featherfly.common.db.builder.dml.basic.SqlUpdateSetBasicBuilder;
import cn.featherfly.common.db.builder.model.UpdateColumnElement;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.lang.LambdaUtils;
import cn.featherfly.common.lang.function.SerializableFunction;
import cn.featherfly.common.lang.function.SerializableSupplier;
import cn.featherfly.common.repository.IgnorePolicy;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.hammer.dsl.execute.ExecutableConditionGroupExpression;
import cn.featherfly.hammer.dsl.execute.ExecutableUpdate;
import cn.featherfly.hammer.dsl.execute.SimpleUpdateNumberValue;
import cn.featherfly.hammer.dsl.execute.SimpleUpdateValue;
import cn.featherfly.hammer.dsl.execute.UpdateNumberValue;
import cn.featherfly.hammer.dsl.execute.UpdateValue;
import cn.featherfly.hammer.expression.Repository;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.dsl.execute.SqlUpdate;
import cn.featherfly.hammer.sqldb.jdbc.dsl.execute.SqlUpdateExpression;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class SqlExecutableUpdate
implements SqlUpdate,
ExecutableUpdate {
    private Jdbc jdbc;
    private SqlUpdateSetBasicBuilder builder;
    private ClassMapping<?> classMapping;

    public SqlExecutableUpdate(String tableName, Jdbc jdbc) {
        this(tableName, jdbc, (Predicate<Object>)IgnorePolicy.NONE);
    }

    public SqlExecutableUpdate(Repository repository, Jdbc jdbc) {
        this(repository.name(), jdbc);
    }

    public SqlExecutableUpdate(ClassMapping<?> classMapping, Jdbc jdbc) {
        this(classMapping, jdbc, (Predicate<Object>)IgnorePolicy.NONE);
    }

    public SqlExecutableUpdate(String tableName, Jdbc jdbc, Predicate<Object> ignorePolicy) {
        this.jdbc = jdbc;
        this.builder = new SqlUpdateSetBasicBuilder(jdbc.getDialect(), tableName, ignorePolicy);
    }

    public SqlExecutableUpdate(Repository repository, Jdbc jdbc, Predicate<Object> ignorePolicy) {
        this(repository.name(), jdbc, ignorePolicy);
    }

    public SqlExecutableUpdate(ClassMapping<?> classMapping, Jdbc jdbc, Predicate<Object> ignorePolicy) {
        this.classMapping = classMapping;
        this.jdbc = jdbc;
        this.builder = new SqlUpdateSetBasicBuilder(jdbc.getDialect(), classMapping.getRepositoryName(), ignorePolicy);
    }

    public SqlExecutableUpdate set(String name, Object value) {
        this.builder.setValue(ClassMappingUtils.getColumnName((String)name, this.classMapping), value);
        return this;
    }

    public <N extends Number> SqlExecutableUpdate increase(String name, N value) {
        this.builder.setValue(ClassMappingUtils.getColumnName((String)name, this.classMapping), value, UpdateColumnElement.SetType.INCR);
        return this;
    }

    public <T, R> ExecutableUpdate set(SerializableFunction<T, R> name, R value) {
        return this.set(LambdaUtils.getLambdaPropertyName(name), value);
    }

    public <T, R extends Number> ExecutableUpdate increase(SerializableFunction<T, R> name, R value) {
        return this.increase(LambdaUtils.getLambdaPropertyName(name), (N)value);
    }

    public <R> ExecutableUpdate set(SerializableSupplier<R> property) {
        LambdaUtils.SerializableSupplierLambdaInfo info = LambdaUtils.getSerializableSupplierLambdaInfo(property);
        return this.set(info.getSerializedLambdaInfo().getPropertyName(), info.getValue());
    }

    public ExecutableUpdate set(Consumer<ExecutableUpdate> consumer) {
        consumer.accept(this);
        return this;
    }

    public <N extends Number> ExecutableUpdate increase(SerializableSupplier<N> property) {
        LambdaUtils.SerializableSupplierLambdaInfo info = LambdaUtils.getSerializableSupplierLambdaInfo(property);
        return this.increase(info.getSerializedLambdaInfo().getPropertyName(), (N)((Number)info.getValue()));
    }

    public ExecutableUpdate increase(Consumer<ExecutableUpdate> consumer) {
        consumer.accept(this);
        return this;
    }

    public UpdateValue property(String name) {
        return new SimpleUpdateValue(ClassMappingUtils.getColumnName((String)name, this.classMapping), (ExecutableUpdate)this);
    }

    public UpdateNumberValue propertyNumber(String name) {
        return new SimpleUpdateNumberValue(ClassMappingUtils.getColumnName((String)name, this.classMapping), (ExecutableUpdate)this);
    }

    public <T, R> UpdateValue property(SerializableFunction<T, R> name) {
        return this.property(LambdaUtils.getLambdaPropertyName(name));
    }

    public <T, R extends Number> UpdateNumberValue propertyNumber(SerializableFunction<T, R> name) {
        return this.propertyNumber(LambdaUtils.getLambdaPropertyName(name));
    }

    public ExecutableConditionGroupExpression where() {
        return new SqlUpdateExpression(this.jdbc, this.builder, this.classMapping, (Predicate<Object>)this.builder.getIgnorePolicy());
    }

    public ExecutableConditionGroupExpression where(Consumer<ExecutableConditionGroupExpression> consumer) {
        SqlUpdateExpression sqlUpdateExpression = new SqlUpdateExpression(this.jdbc, this.builder, this.classMapping, (Predicate<Object>)this.builder.getIgnorePolicy());
        if (consumer != null) {
            consumer.accept(sqlUpdateExpression);
        }
        return sqlUpdateExpression;
    }

    public int execute() {
        return new SqlUpdateExpression(this.jdbc, this.builder, this.classMapping).execute();
    }
}

