/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.lang.Strings;
import cn.featherfly.hammer.sqldb.jdbc.NestedBeanPropertyRowMapper;
import java.util.ArrayList;
import java.util.List;

public class MappingDebugMessage {
    private int columnMaxLength;
    private int columnAsMaxLength;
    private int propertyMaxLength;
    private final List<NestedBeanPropertyRowMapper.Mapping> mappings = new ArrayList<NestedBeanPropertyRowMapper.Mapping>(0);

    public void addMapping(String column, String property, String propertyTypeName) {
        this.addMapping(column, column, property, propertyTypeName);
    }

    public void addMapping(String column, String columnAs, String property, String propertyTypeName) {
        NestedBeanPropertyRowMapper.Mapping mapping = new NestedBeanPropertyRowMapper.Mapping();
        mapping.column = column;
        if (this.columnMaxLength < column.length()) {
            this.columnMaxLength = column.length();
        }
        mapping.property = property;
        if (this.propertyMaxLength < property.length()) {
            this.propertyMaxLength = property.length();
        }
        mapping.propertyTypeName = propertyTypeName;
        if (columnAs != null) {
            mapping.columnAs = columnAs;
            if (this.columnAsMaxLength < columnAs.length()) {
                this.columnAsMaxLength = columnAs.length();
            }
        }
        this.mappings.add(mapping);
    }

    public String toString() {
        StringBuilder dm = new StringBuilder();
        String format = Strings.format((String)"  Mapping column %-{0}s as %-{1}s to property %-{2}s of type %s\n", (Object[])new Object[]{this.columnMaxLength, this.columnAsMaxLength, this.propertyMaxLength});
        for (NestedBeanPropertyRowMapper.Mapping mapping : this.mappings) {
            dm.append(String.format(format, mapping.column, mapping.columnAs, mapping.property, mapping.propertyTypeName));
        }
        return dm.toString();
    }
}

