/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractExecuteOperate;
import com.speedment.common.tuple.Tuple2;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Map;

public class DeleteOperate<T>
extends AbstractExecuteOperate<T> {
    public DeleteOperate(Jdbc jdbc, ClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager) {
        super(jdbc, classMapping, sqlTypeMappingManager);
    }

    public DeleteOperate(Jdbc jdbc, ClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, String dataBase) {
        super(jdbc, classMapping, sqlTypeMappingManager, dataBase);
    }

    public DeleteOperate(Jdbc jdbc, ClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, sqlTypeMappingManager, databaseMetadata);
    }

    public int delete(Serializable id) {
        return this.jdbc.execute((con, manager) -> {
            PreparedStatement prep = null;
            prep = con.prepareStatement(this.sql);
            this.setParameter(prep, id, manager);
            this.logger.debug("execute sql: {}", (Object)this.sql);
            int result = prep.executeUpdate();
            prep.close();
            return result;
        });
    }

    public int deleteBatch(Serializable ... ids) {
        return this.deleteBatch(ArrayUtils.toList((Object[])ids));
    }

    public int deleteBatch(List<Serializable> ids) {
        if (Lang.isEmpty(ids)) {
            return 0;
        }
        return this.jdbc.execute((con, manager) -> {
            Tuple2 tuple = ClassMappingUtils.getDeleteSqlAndParamPositions((int)ids.size(), (ClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
            try (PreparedStatement prep = con.prepareStatement((String)tuple.get0());){
                int index = 1;
                for (Serializable id : ids) {
                    manager.set(prep, index, (Object)id, (GenericType)this.pkProperties.get(index - 1));
                    ++index;
                }
                this.logger.debug("execute sql: {} \n params: {}", (Object)this.sql, (Object)ids);
                int result = prep.executeUpdate();
                Integer n = result;
                return n;
            }
        });
    }

    public int executeBatch(T[] entities) {
        return this.executeBatch(ArrayUtils.toList((Object[])entities));
    }

    public int executeBatch(List<T> entities) {
        if (Lang.isEmpty(entities)) {
            return 0;
        }
        Tuple2 tuple = ClassMappingUtils.getDeleteSqlAndParamPositions((int)entities.size(), (ClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        return this.jdbc.execute((con, manager) -> {
            try (PreparedStatement prep = con.prepareStatement((String)tuple.get0());){
                Object[] params = this.setBatchParameters(entities, (Map)tuple.get1(), prep, manager);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("execute sql: {} \n params: {}", (Object)this.sql, (Object)ArrayUtils.toString((Object[])params));
                }
                int result = prep.executeUpdate();
                Integer n = result;
                return n;
            }
        });
    }

    @Override
    public void initSql() {
        Tuple2 tuple = ClassMappingUtils.getDeleteSqlAndParamPositions((ClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        this.sql = (String)tuple.get0();
        this.propertyPositions.putAll((Map)tuple.get1());
        this.logger.debug("sql: {}", (Object)this.sql);
    }
}

