/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.dsl.query;

import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.db.builder.dml.SqlSortBuilder;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.exception.UnsupportedException;
import cn.featherfly.common.lang.LambdaUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.function.ReturnDateFunction;
import cn.featherfly.common.lang.function.ReturnLocalDateFunction;
import cn.featherfly.common.lang.function.ReturnLocalDateTimeFunction;
import cn.featherfly.common.lang.function.ReturnLocalTimeFunction;
import cn.featherfly.common.lang.function.ReturnNumberFunction;
import cn.featherfly.common.lang.function.ReturnStringFunction;
import cn.featherfly.common.lang.function.SerializableFunction;
import cn.featherfly.common.lang.function.SerializableSupplier;
import cn.featherfly.common.repository.builder.AliasManager;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.MappingFactory;
import cn.featherfly.common.repository.operate.QueryOperator;
import cn.featherfly.common.structure.page.Limit;
import cn.featherfly.common.structure.page.Page;
import cn.featherfly.common.structure.page.PaginationResults;
import cn.featherfly.common.structure.page.SimplePaginationResults;
import cn.featherfly.hammer.dsl.query.TypeQueryConditionGroupExpression;
import cn.featherfly.hammer.dsl.query.TypeQueryConditionGroupLogicExpression;
import cn.featherfly.hammer.dsl.query.TypeQueryEntity;
import cn.featherfly.hammer.dsl.query.TypeQuerySortExpression;
import cn.featherfly.hammer.expression.condition.Expression;
import cn.featherfly.hammer.expression.query.TypeQueryLimitExecutor;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.sql.dml.AbstractSqlConditionGroupExpression;
import cn.featherfly.hammer.sqldb.sql.dml.SqlConditionExpressionBuilder;
import com.speedment.common.tuple.Tuple2;
import com.speedment.common.tuple.Tuple3;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class TypeSqlQueryConditionGroupExpression
extends AbstractSqlConditionGroupExpression<TypeQueryConditionGroupExpression, TypeQueryConditionGroupLogicExpression>
implements TypeQueryConditionGroupExpression,
TypeQueryConditionGroupLogicExpression,
TypeQuerySortExpression {
    private SqlSortBuilder sortBuilder;
    private Limit limit;
    protected MappingFactory factory;
    protected AliasManager aliasManager;
    protected Jdbc jdbc;

    public TypeSqlQueryConditionGroupExpression(Jdbc jdbc, ClassMapping<?> classMapping, MappingFactory factory, AliasManager aliasManager, TypeQueryEntity typeQueryEntity) {
        this(jdbc, null, classMapping, factory, aliasManager, typeQueryEntity);
    }

    public TypeSqlQueryConditionGroupExpression(Jdbc jdbc, String queryAlias, ClassMapping<?> classMapping, MappingFactory factory, AliasManager aliasManager, TypeQueryEntity typeQueryEntity) {
        this(jdbc, null, queryAlias, classMapping, factory, aliasManager, typeQueryEntity);
    }

    TypeSqlQueryConditionGroupExpression(Jdbc jdbc, TypeQueryConditionGroupLogicExpression parent, String queryAlias, ClassMapping<?> classMapping, MappingFactory factory, AliasManager aliasManager, TypeQueryEntity typeQueryEntity) {
        super(jdbc.getDialect(), parent, queryAlias, classMapping, typeQueryEntity);
        this.sortBuilder = new SqlSortBuilder(this.dialect);
        this.jdbc = jdbc;
        this.factory = factory;
        this.aliasManager = aliasManager;
    }

    @Override
    protected TypeSqlQueryConditionGroupExpression createGroup(TypeQueryConditionGroupLogicExpression parent, String queryAlias, TypeQueryEntity typeQueryEntity) {
        return new TypeSqlQueryConditionGroupExpression(this.jdbc, parent, queryAlias, this.classMapping, this.factory, this.aliasManager, typeQueryEntity);
    }

    @Override
    public String build() {
        String condition = super.build();
        if (this.parent == null) {
            if (Lang.isNotEmpty((String)condition)) {
                return this.dialect.getKeywords().where() + " " + super.build() + " " + this.sortBuilder.build();
            }
            return super.build() + " " + this.sortBuilder.build();
        }
        return super.build();
    }

    public TypeQueryLimitExecutor limit(Integer limit) {
        return this.limit(0, limit);
    }

    public TypeQueryLimitExecutor limit(Integer offset, Integer limit) {
        return this.limit(new Limit(offset, limit));
    }

    public TypeQueryLimitExecutor limit(Page page) {
        return this.limit(new Limit(page));
    }

    private TypeQueryLimitExecutor limit(Limit limit) {
        this.limit = limit;
        return this;
    }

    public <E> List<E> list() {
        String sql = this.getRoot().expression();
        Object[] params = this.getRoot().getParams().toArray();
        if (this.limit != null) {
            sql = this.dialect.getPaginationSql(sql, this.limit.getOffset().intValue(), this.limit.getLimit().intValue());
            params = this.dialect.getPaginationSqlParameter(params, this.limit.getOffset().intValue(), this.limit.getLimit().intValue());
        }
        return this.jdbc.query(sql, this.classMapping.getType(), params);
    }

    public <E> PaginationResults<E> pagination() {
        String sql = this.getRoot().expression();
        String countSql = SqlUtils.convertSelectToCount((String)sql);
        Object[] params = this.getRoot().getParams().toArray();
        SimplePaginationResults pagination = new SimplePaginationResults(this.limit);
        if (this.limit != null) {
            List list = this.jdbc.query(this.dialect.getPaginationSql(sql, this.limit.getOffset().intValue(), this.limit.getLimit().intValue()), this.classMapping.getType(), this.dialect.getPaginationSqlParameter(params, this.limit.getOffset().intValue(), this.limit.getLimit().intValue()));
            pagination.setPageResults(list);
            int total = this.jdbc.queryInt(countSql, params);
            pagination.setTotal(Integer.valueOf(total));
        } else {
            List<Map<String, Object>> list = this.jdbc.query(sql, params, this.classMapping.getType());
            pagination.setPageResults(list);
            pagination.setTotal(Integer.valueOf(list.size()));
        }
        return pagination;
    }

    public <E> E single() {
        String sql = this.getRoot().expression();
        Object[] params = this.getRoot().getParams().toArray();
        if (this.limit != null) {
            sql = this.dialect.getPaginationSql(sql, this.limit.getOffset().intValue(), this.limit.getLimit().intValue());
            params = this.dialect.getPaginationSqlParameter(params, this.limit.getOffset().intValue(), this.limit.getLimit().intValue());
        }
        return (E)this.jdbc.querySingle(sql, this.classMapping.getType(), params);
    }

    public <E> E unique() {
        String sql = this.getRoot().expression();
        Object[] params = this.getRoot().getParams().toArray();
        if (this.limit != null) {
            sql = this.dialect.getPaginationSql(sql, this.limit.getOffset().intValue(), this.limit.getLimit().intValue());
            params = this.dialect.getPaginationSqlParameter(params, this.limit.getOffset().intValue(), this.limit.getLimit().intValue());
        }
        return (E)this.jdbc.queryUnique(sql, this.classMapping.getType(), params);
    }

    public Long count() {
        throw new UnsupportedException();
    }

    public TypeQuerySortExpression sort() {
        return this;
    }

    public TypeQuerySortExpression asc(String ... names) {
        ((TypeSqlQueryConditionGroupExpression)this.getRoot()).sortBuilder.asc(ClassMappingUtils.getColumnNames((ClassMapping)this.classMapping, (String[])names));
        return this;
    }

    public TypeQuerySortExpression asc(List<String> names) {
        ((TypeSqlQueryConditionGroupExpression)this.getRoot()).sortBuilder.asc(ClassMappingUtils.getColumnNames((ClassMapping)this.classMapping, names));
        return this;
    }

    public <T, R> TypeQuerySortExpression asc(SerializableFunction<T, R> name) {
        return this.asc(this.getPropertyName(name));
    }

    public <T, R> TypeQuerySortExpression asc(SerializableFunction<T, R> ... names) {
        String[] nameArray = (String[])Arrays.stream(names).map(LambdaUtils::getLambdaPropertyName).toArray(String[]::new);
        return this.asc(nameArray);
    }

    public TypeQuerySortExpression desc(String ... names) {
        ((TypeSqlQueryConditionGroupExpression)this.getRoot()).sortBuilder.desc(ClassMappingUtils.getColumnNames((ClassMapping)this.classMapping, (String[])names));
        return this;
    }

    public TypeQuerySortExpression desc(List<String> names) {
        ((TypeSqlQueryConditionGroupExpression)this.getRoot()).sortBuilder.desc(ClassMappingUtils.getColumnNames((ClassMapping)this.classMapping, names));
        return this;
    }

    public <T, R> TypeQuerySortExpression desc(SerializableFunction<T, R> name) {
        return this.desc(this.getPropertyName(name));
    }

    public <T, R> TypeQuerySortExpression desc(SerializableFunction<T, R> ... names) {
        String[] nameArray = (String[])Arrays.stream(names).map(LambdaUtils::getLambdaPropertyName).toArray(String[]::new);
        return this.desc(nameArray);
    }

    public <T, R> TypeQueryConditionGroupLogicExpression co(SerializableFunction<T, R> repository, ReturnStringFunction<R> property, Object value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.CO, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression co(SerializableSupplier<T> repository, ReturnStringFunction<T> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.CO, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression ew(SerializableFunction<T, R> repository, ReturnStringFunction<R> property, Object value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.EW, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression ew(SerializableSupplier<T> repository, ReturnStringFunction<T> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.EW, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <O, T, R> TypeQueryConditionGroupLogicExpression eq(SerializableFunction<O, T> repository, SerializableFunction<T, R> property, Object value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.EQ, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression eq(SerializableSupplier<T> repository, SerializableFunction<T, R> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.EQ, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R, N extends Number> TypeQueryConditionGroupLogicExpression ge(SerializableFunction<T, R> repository, ReturnNumberFunction<R, N> property, N value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.GE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, N extends Number> TypeQueryConditionGroupLogicExpression ge(SerializableSupplier<T> repository, ReturnNumberFunction<T, N> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.GE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R, D extends Date> TypeQueryConditionGroupLogicExpression ge(SerializableFunction<T, R> repository, ReturnDateFunction<R, D> property, D value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.GE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, D extends Date> TypeQueryConditionGroupLogicExpression ge(SerializableSupplier<T> repository, ReturnDateFunction<T, D> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.GE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression ge(SerializableFunction<T, R> repository, ReturnLocalTimeFunction<R> property, LocalTime value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.GE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T> TypeQueryConditionGroupLogicExpression ge(SerializableSupplier<T> repository, ReturnLocalTimeFunction<T> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.GE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression ge(SerializableFunction<T, R> repository, ReturnLocalDateFunction<R> property, LocalDate value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.GE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T> TypeQueryConditionGroupLogicExpression ge(SerializableSupplier<T> repository, ReturnLocalDateFunction<T> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.GE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression ge(SerializableFunction<T, R> repository, ReturnLocalDateTimeFunction<R> property, LocalDateTime value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.GE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T> TypeQueryConditionGroupLogicExpression ge(SerializableSupplier<T> repository, ReturnLocalDateTimeFunction<T> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.GE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression ge(SerializableFunction<T, R> repository, ReturnStringFunction<R> property, String value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.GE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T> TypeQueryConditionGroupLogicExpression ge(SerializableSupplier<T> repository, ReturnStringFunction<T> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.GE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R, N extends Number> TypeQueryConditionGroupLogicExpression gt(SerializableFunction<T, R> repository, ReturnNumberFunction<R, N> property, N value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.GT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, N extends Number> TypeQueryConditionGroupLogicExpression gt(SerializableSupplier<T> repository, ReturnNumberFunction<T, N> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.GT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R, D extends Date> TypeQueryConditionGroupLogicExpression gt(SerializableFunction<T, R> repository, ReturnDateFunction<R, D> property, D value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.GT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, D extends Date> TypeQueryConditionGroupLogicExpression gt(SerializableSupplier<T> repository, ReturnDateFunction<T, D> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.GT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression gt(SerializableFunction<T, R> repository, ReturnLocalTimeFunction<R> property, LocalTime value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.GT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T> TypeQueryConditionGroupLogicExpression gt(SerializableSupplier<T> repository, ReturnLocalTimeFunction<T> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.GT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression gt(SerializableFunction<T, R> repository, ReturnLocalDateFunction<R> property, LocalDate value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.GT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T> TypeQueryConditionGroupLogicExpression gt(SerializableSupplier<T> repository, ReturnLocalDateFunction<T> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.GT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression gt(SerializableFunction<T, R> repository, ReturnLocalDateTimeFunction<R> property, LocalDateTime value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.GT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T> TypeQueryConditionGroupLogicExpression gt(SerializableSupplier<T> repository, ReturnLocalDateTimeFunction<T> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.GT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression gt(SerializableFunction<T, R> repository, ReturnStringFunction<R> property, String value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.GT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T> TypeQueryConditionGroupLogicExpression gt(SerializableSupplier<T> repository, ReturnStringFunction<T> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.GT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <O, T, R> TypeQueryConditionGroupLogicExpression in(SerializableFunction<O, T> repository, SerializableFunction<T, R> property, Object value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.IN, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression in(SerializableSupplier<T> repository, SerializableFunction<T, R> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.IN, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <O, T, R> TypeQueryConditionGroupLogicExpression inn(SerializableFunction<O, T> repository, SerializableFunction<T, R> property) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, null, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), null, QueryOperator.INN, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <O, T, R> TypeQueryConditionGroupLogicExpression isn(SerializableFunction<O, T> repository, SerializableFunction<T, R> property) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, null, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), null, QueryOperator.ISN, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R, N extends Number> TypeQueryConditionGroupLogicExpression le(SerializableFunction<T, R> repository, ReturnNumberFunction<R, N> property, N value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.LE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, N extends Number> TypeQueryConditionGroupLogicExpression le(SerializableSupplier<T> repository, ReturnNumberFunction<T, N> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.LE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R, D extends Date> TypeQueryConditionGroupLogicExpression le(SerializableFunction<T, R> repository, ReturnDateFunction<R, D> property, D value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.LE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, D extends Date> TypeQueryConditionGroupLogicExpression le(SerializableSupplier<T> repository, ReturnDateFunction<T, D> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.LE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression le(SerializableFunction<T, R> repository, ReturnLocalTimeFunction<R> property, LocalTime value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.LE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T> TypeQueryConditionGroupLogicExpression le(SerializableSupplier<T> repository, ReturnLocalTimeFunction<T> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.LE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression le(SerializableFunction<T, R> repository, ReturnLocalDateFunction<R> property, LocalDate value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.LE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T> TypeQueryConditionGroupLogicExpression le(SerializableSupplier<T> repository, ReturnLocalDateFunction<T> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.LE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression le(SerializableFunction<T, R> repository, ReturnLocalDateTimeFunction<R> property, LocalDateTime value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.LE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T> TypeQueryConditionGroupLogicExpression le(SerializableSupplier<T> repository, ReturnLocalDateTimeFunction<T> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.LE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression le(SerializableFunction<T, R> repository, ReturnStringFunction<R> property, String value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.LE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T> TypeQueryConditionGroupLogicExpression le(SerializableSupplier<T> repository, ReturnStringFunction<T> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.LE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R, N extends Number> TypeQueryConditionGroupLogicExpression lt(SerializableFunction<T, R> repository, ReturnNumberFunction<R, N> property, N value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.LT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, N extends Number> TypeQueryConditionGroupLogicExpression lt(SerializableSupplier<T> repository, ReturnNumberFunction<T, N> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.LT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R, D extends Date> TypeQueryConditionGroupLogicExpression lt(SerializableFunction<T, R> repository, ReturnDateFunction<R, D> property, D value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.LT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, D extends Date> TypeQueryConditionGroupLogicExpression lt(SerializableSupplier<T> repository, ReturnDateFunction<T, D> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.LT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression lt(SerializableFunction<T, R> repository, ReturnLocalTimeFunction<R> property, LocalTime value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.LT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T> TypeQueryConditionGroupLogicExpression lt(SerializableSupplier<T> repository, ReturnLocalTimeFunction<T> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.LT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression lt(SerializableFunction<T, R> repository, ReturnLocalDateFunction<R> property, LocalDate value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.LT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T> TypeQueryConditionGroupLogicExpression lt(SerializableSupplier<T> repository, ReturnLocalDateFunction<T> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.LT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression lt(SerializableFunction<T, R> repository, ReturnLocalDateTimeFunction<R> property, LocalDateTime value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.LT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T> TypeQueryConditionGroupLogicExpression lt(SerializableSupplier<T> repository, ReturnLocalDateTimeFunction<T> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.LT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression lt(SerializableFunction<T, R> repository, ReturnStringFunction<R> property, String value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.LT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T> TypeQueryConditionGroupLogicExpression lt(SerializableSupplier<T> repository, ReturnStringFunction<T> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.LT, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <O, T, R> TypeQueryConditionGroupLogicExpression ne(SerializableFunction<O, T> repository, SerializableFunction<T, R> property, Object value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.EQ, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression ne(SerializableSupplier<T> repository, SerializableFunction<T, R> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.NE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <O, T, R> TypeQueryConditionGroupLogicExpression nin(SerializableFunction<O, T> repository, SerializableFunction<T, R> property, Object value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.NIN, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression nin(SerializableSupplier<T> repository, SerializableFunction<T, R> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.NE, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression sw(SerializableFunction<T, R> repository, ReturnStringFunction<R> property, Object value) {
        this.typeQueryEntity.with(repository);
        Tuple2<String, String> tuple = this.conditionResult(repository, property, value, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), value, QueryOperator.SW, this.aliasManager.getAlias((String)tuple.get0())));
    }

    public <T, R> TypeQueryConditionGroupLogicExpression sw(SerializableSupplier<T> repository, ReturnStringFunction<T> property) {
        this.typeQueryEntity.with(repository);
        Tuple3<String, String, Object> tuple = this.conditionResult(repository, property, this.factory);
        return (TypeQueryConditionGroupLogicExpression)this.addCondition((Expression)new SqlConditionExpressionBuilder(this.dialect, (String)tuple.get1(), tuple.get2(), QueryOperator.SW, this.aliasManager.getAlias((String)tuple.get0())));
    }
}

