/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.Execution;
import cn.featherfly.hammer.sqldb.Constants;
import cn.featherfly.hammer.sqldb.jdbc.SpringJdbcTemplateImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class JdbcImpl
extends SpringJdbcTemplateImpl {
    private SqlTypeMappingManager manager;

    public JdbcImpl() {
    }

    public JdbcImpl(DataSource dataSource, Dialect dialect) {
        this(dataSource, dialect, new SqlTypeMappingManager());
    }

    public JdbcImpl(DataSource dataSource, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager) {
        super(dataSource, dialect);
        this.manager = sqlTypeMappingManager;
    }

    @Override
    public int update(String sql, Object ... args) {
        Constants.LOGGER.debug("sql -> {}, args -> {}", (Object)sql, (Object)args);
        if (Lang.isNotEmpty((String)sql)) {
            sql = sql.trim();
            return this.executeUpdate(sql, args);
        }
        return 0;
    }

    @Override
    public int update(String sql, Map<String, Object> args) {
        Constants.LOGGER.debug("sql -> {}, args -> {}", (Object)sql, args);
        if (Lang.isNotEmpty((String)sql)) {
            sql = sql.trim();
            return this.executeUpdate(SqlUtils.convertNamedParamSql((String)sql, args));
        }
        return 0;
    }

    private int executeUpdate(Execution execution) {
        return this.executeUpdate(execution.getExecution(), execution.getParams());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int executeUpdate(String sql, Object ... args) {
        Connection connection = this.getConnection();
        try (PreparedStatement prep = connection.prepareStatement(sql);){
            Constants.LOGGER.debug("sql -> {}, args -> {}", (Object)sql, (Object)ArrayUtils.toString((Object[])args));
            this.setParams(prep, args);
            int n = prep.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new JdbcException();
        }
    }

    private void setParams(PreparedStatement prep, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            this.manager.set(prep, i + 1, args[i]);
        }
    }

    private Connection getConnection() {
        return DataSourceUtils.getConnection((DataSource)this.dataSource);
    }
}

