/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.reflect.GenericClass;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.PropertyMapping;
import cn.featherfly.hammer.sqldb.jdbc.GeneratedKeyHolder;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractBatchExecuteOperate;
import com.speedment.common.tuple.Tuple2;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class InsertOperate<T>
extends AbstractBatchExecuteOperate<T> {
    public InsertOperate(Jdbc jdbc, ClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager) {
        super(jdbc, classMapping, sqlTypeMappingManager);
    }

    public InsertOperate(Jdbc jdbc, ClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, String dataBase) {
        super(jdbc, classMapping, sqlTypeMappingManager, dataBase);
    }

    public InsertOperate(Jdbc jdbc, ClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, sqlTypeMappingManager, databaseMetadata);
    }

    @Override
    public int executeBatch(List<T> entities) {
        return this.executeBatch(entities, true);
    }

    public int executeBatch(final List<T> entities, boolean autoSetGenerateId) {
        if (this.jdbc.getDialect().isInsertBatch()) {
            Tuple2 tuple = ClassMappingUtils.getInsertBatchSqlAndParamPositions((int)entities.size(), (ClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
            String sql = (String)tuple.get0();
            final List pks = this.classMapping.getPrivaryKeyPropertyMappings();
            if (pks.size() == 1) {
                return this.jdbc.update(sql, new GeneratedKeyHolder<Serializable>(){

                    @Override
                    public void acceptKey(Serializable key, int row) {
                        BeanUtils.setProperty(entities.get(row), (String)((PropertyMapping)pks.get(0)).getPropertyName(), (Object)key);
                    }

                    @Override
                    public GenericType<Serializable> getType() {
                        return new GenericClass(((PropertyMapping)pks.get(0)).getPropertyType());
                    }
                }, this.getBatchParameters(entities, (Map)tuple.get1()));
            }
            return this.jdbc.update(sql, this.getBatchParameters(entities, (Map)tuple.get1()));
        }
        int size = 0;
        for (T entity : entities) {
            size += this.execute(entity);
        }
        return size;
    }

    @Override
    public int execute(final T entity) {
        final List pks = this.classMapping.getPrivaryKeyPropertyMappings();
        if (pks.size() == 1) {
            return this.jdbc.update(this.sql, new GeneratedKeyHolder<Serializable>(){

                @Override
                public void acceptKey(Serializable key, int row) {
                    BeanUtils.setProperty((Object)entity, (String)((PropertyMapping)pks.get(0)).getPropertyName(), (Object)key);
                }

                @Override
                public GenericType<Serializable> getType() {
                    return new GenericClass(((PropertyMapping)pks.get(0)).getPropertyType());
                }
            }, this.getParameters(entity));
        }
        return this.jdbc.update(this.sql, this.getParameters(entity));
    }

    @Override
    protected void initSql() {
        Tuple2 tuple = ClassMappingUtils.getInsertSqlAndParamPositions((ClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        this.sql = (String)tuple.get0();
        this.propertyPositions.putAll((Map)tuple.get1());
        this.logger.debug("sql: {}", (Object)this.sql);
    }

    protected Object[] getBatchParameters(List<T> entities, Map<Integer, String> propertyPositions) {
        if (Lang.isEmpty(entities)) {
            return new Object[0];
        }
        Object[] params = new Object[propertyPositions.size() * entities.size()];
        for (int i = 0; i < entities.size(); ++i) {
            T entity = entities.get(i);
            int index = 0;
            for (Map.Entry<Integer, String> propertyPosition : propertyPositions.entrySet()) {
                params[i * propertyPositions.size() + index] = BeanUtils.getProperty(entity, (String)propertyPosition.getValue());
                ++index;
            }
        }
        return params;
    }
}

