/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.SqlResultSet;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.PropertyMapping;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.MappingDebugMessage;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractOperate;
import java.sql.ResultSet;

public abstract class AbstractQueryOperate<T>
extends AbstractOperate<T> {
    private String selectSql;

    public AbstractQueryOperate(Jdbc jdbc, ClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager) {
        super(jdbc, classMapping, sqlTypeMappingManager);
    }

    public AbstractQueryOperate(Jdbc jdbc, ClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, String dataBase) {
        super(jdbc, classMapping, sqlTypeMappingManager, dataBase);
    }

    public AbstractQueryOperate(Jdbc jdbc, ClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, sqlTypeMappingManager, databaseMetadata);
    }

    protected T mapRow(cn.featherfly.common.repository.mapping.ResultSet rs, int rowNumber) {
        Object mappedObject = BeanUtils.instantiateClass((Class)this.classMapping.getType());
        int index = 1;
        ResultSet resultSet = null;
        if (rs instanceof SqlResultSet) {
            SqlResultSet sqlrs = (SqlResultSet)rs;
            resultSet = sqlrs.getResultSet();
        }
        MappingDebugMessage mappingDebugMessage = new MappingDebugMessage();
        for (PropertyMapping propertyMapping : this.classMapping.getPropertyMappings()) {
            if (propertyMapping.getPropertyMappings().isEmpty()) {
                BeanProperty<?> bp = this.getBeanProperty(propertyMapping, rowNumber);
                Object value = this.sqlTypeMappingManager.get(resultSet, index, bp);
                index = this.setProperty(rowNumber, mappedObject, index, propertyMapping, value, mappingDebugMessage);
                continue;
            }
            for (PropertyMapping subPropertyMapping : propertyMapping.getPropertyMappings()) {
                BeanProperty<?> bp = this.getBeanProperty(subPropertyMapping, rowNumber);
                Object value = this.sqlTypeMappingManager.get(resultSet, index, bp);
                index = this.setProperty(rowNumber, mappedObject, index, subPropertyMapping, value, mappingDebugMessage);
            }
        }
        if (rowNumber == 0 && this.logger.isDebugEnabled()) {
            StringBuilder debugMessage = new StringBuilder();
            debugMessage.append("\n---------- Map " + this.classMapping.getType().getName() + " Start ----------\n").append(mappingDebugMessage.toString()).append("---------- Map " + this.classMapping.getType().getName() + " End ----------");
            this.logger.debug(debugMessage.toString());
        }
        return (T)mappedObject;
    }

    private BeanProperty<?> getBeanProperty(PropertyMapping propertyMapping, int rowNumber) {
        String propertyName = ClassMappingUtils.getPropertyAliasName((PropertyMapping)propertyMapping);
        return this.beanDescriptor.getChildBeanProperty(propertyName);
    }

    private int setProperty(int rowNumber, T mappedObject, int index, PropertyMapping propertyMapping, Object value, MappingDebugMessage mappingDebugMessage) {
        String propertyName = ClassMappingUtils.getPropertyAliasName((PropertyMapping)propertyMapping);
        if (this.logger.isDebugEnabled() && rowNumber == 0) {
            mappingDebugMessage.addMapping(propertyMapping.getRepositoryFieldName(), propertyName, propertyMapping.getPropertyType().getName());
        }
        BeanUtils.setProperty(mappedObject, (String)propertyName, (Object)value);
        return ++index;
    }

    @Override
    protected void initSql() {
        this.initSelectSql();
        StringBuilder getSql = new StringBuilder();
        getSql.append(this.getSelectSql());
        String condition = this.initCondition();
        if (Lang.isNotEmpty((String)condition)) {
            getSql.append(" ").append(this.jdbc.getDialect().getKeywords().where()).append(" ").append(condition);
        }
        this.sql = getSql.toString();
        this.logger.debug("sql: {}", (Object)this.sql);
    }

    protected abstract String initCondition();

    private void initSelectSql() {
        this.selectSql = ClassMappingUtils.getSelectSql((ClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
    }

    public String getSelectSql() {
        return this.selectSql;
    }
}

