/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb;

import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.IgnorePolicy;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.structure.page.Page;
import cn.featherfly.common.structure.page.PaginationResults;
import cn.featherfly.hammer.dsl.execute.Delete;
import cn.featherfly.hammer.dsl.execute.Update;
import cn.featherfly.hammer.dsl.query.QueryEntity;
import cn.featherfly.hammer.dsl.query.TypeQueryEntity;
import cn.featherfly.hammer.sqldb.SqldbHammer;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.SimpleSqlPageFactory;
import cn.featherfly.hammer.sqldb.jdbc.SqlPageFactory;
import cn.featherfly.hammer.sqldb.jdbc.dsl.execute.SqlDeleter;
import cn.featherfly.hammer.sqldb.jdbc.dsl.execute.SqlUpdater;
import cn.featherfly.hammer.sqldb.jdbc.dsl.query.SqlQuery;
import cn.featherfly.hammer.sqldb.jdbc.operate.DeleteOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.GetOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.InsertOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.MergeOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.UpdateOperate;
import cn.featherfly.hammer.sqldb.tpl.SqlDbTemplateEngine;
import cn.featherfly.hammer.sqldb.tpl.SqlTplExecutor;
import cn.featherfly.hammer.sqldb.tpl.freemarker.SqldbFreemarkerTemplateEngine;
import cn.featherfly.hammer.tpl.TplConfigFactory;
import cn.featherfly.hammer.tpl.TplConfigFactoryImpl;
import cn.featherfly.hammer.tpl.TplExecuteId;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public class SqldbHammerImpl
implements SqldbHammer {
    private Jdbc jdbc;
    private JdbcMappingFactory mappingFactory;
    private Validator validator;
    private SqlTplExecutor sqlTplExecutor;
    private Map<Class<?>, InsertOperate<?>> insertOperates = new HashMap();
    private Map<Class<?>, UpdateOperate<?>> updateOperates = new HashMap();
    private Map<Class<?>, GetOperate<?>> getOperates = new HashMap();
    private Map<Class<?>, DeleteOperate<?>> deleteOperates = new HashMap();
    private Map<Class<?>, MergeOperate<?>> mergeOperates = new HashMap();

    public SqldbHammerImpl(Jdbc jdbc, JdbcMappingFactory mappingFactory) {
        this(jdbc, mappingFactory, (TplConfigFactory)new TplConfigFactoryImpl());
    }

    public SqldbHammerImpl(Jdbc jdbc, JdbcMappingFactory mappingFactory, TplConfigFactory configFactory) {
        this(jdbc, mappingFactory, configFactory, new SqldbFreemarkerTemplateEngine(configFactory));
    }

    public SqldbHammerImpl(Jdbc jdbc, JdbcMappingFactory mappingFactory, TplConfigFactory configFactory, SqlDbTemplateEngine templateEngine) {
        this(jdbc, mappingFactory, configFactory, templateEngine, new SimpleSqlPageFactory());
    }

    public SqldbHammerImpl(Jdbc jdbc, JdbcMappingFactory mappingFactory, TplConfigFactory configFactory, SqlDbTemplateEngine templateEngine, SqlPageFactory sqlPageFacotry) {
        this(jdbc, mappingFactory, configFactory, templateEngine, sqlPageFacotry, ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(false)).buildValidatorFactory().getValidator());
    }

    public SqldbHammerImpl(Jdbc jdbc, JdbcMappingFactory mappingFactory, TplConfigFactory configFactory, SqlDbTemplateEngine templateEngine, SqlPageFactory sqlPageFacotry, Validator validator) {
        this.jdbc = jdbc;
        this.mappingFactory = mappingFactory;
        this.validator = validator;
        this.sqlTplExecutor = new SqlTplExecutor(configFactory, templateEngine, jdbc, mappingFactory, sqlPageFacotry);
    }

    public <E> int save(E entity) {
        if (entity == null) {
            return 0;
        }
        InsertOperate<E> insert = this.getInsert(entity);
        this.validate(entity);
        return insert.execute(entity);
    }

    public <E> int save(E ... entities) {
        return this.save(ArrayUtils.toList((Object[])entities));
    }

    public <E> int save(List<E> entities) {
        if (Lang.isEmpty(entities)) {
            return 0;
        }
        InsertOperate<E> insert = null;
        if (this.jdbc.getDialect().isInsertBatch() && this.jdbc.getDialect().isAutoGenerateKeyBatch()) {
            for (E entity : entities) {
                if (insert == null) {
                    insert = this.getInsert(entity);
                }
                this.validate(entity);
            }
            return insert.executeBatch(entities);
        }
        int size = 0;
        if (Lang.isNotEmpty(entities)) {
            for (E e : entities) {
                size += this.save(e);
            }
        }
        return size;
    }

    private <E> InsertOperate<E> getInsert(E entity) {
        InsertOperate<Object> insert = this.insertOperates.get(entity.getClass());
        if (insert == null) {
            ClassMapping mapping = this.mappingFactory.getClassMapping(entity.getClass());
            insert = new InsertOperate(this.jdbc, mapping, this.mappingFactory.getSqlTypeMappingManager(), this.mappingFactory.getMetadata());
            this.insertOperates.put(entity.getClass(), insert);
        }
        return insert;
    }

    public <E> int update(E entity) {
        if (entity == null) {
            return 0;
        }
        UpdateOperate<Object> update = this.updateOperates.get(entity.getClass());
        if (update == null) {
            ClassMapping mapping = this.mappingFactory.getClassMapping(entity.getClass());
            update = new UpdateOperate(this.jdbc, mapping, this.mappingFactory.getSqlTypeMappingManager(), this.mappingFactory.getMetadata());
            this.updateOperates.put(entity.getClass(), update);
        }
        this.validate(entity);
        return update.execute(entity);
    }

    public <E> int update(E ... entities) {
        int size = 0;
        if (Lang.isNotEmpty((Object[])entities)) {
            for (E e : entities) {
                size += this.update(e);
            }
        }
        return size;
    }

    public <E> int update(List<E> entities) {
        int size = 0;
        if (Lang.isNotEmpty(entities)) {
            for (E e : entities) {
                size += this.update(e);
            }
        }
        return size;
    }

    public <E> int update(E entity, IgnorePolicy ignorePolicy) {
        switch (ignorePolicy) {
            case EMPTY: {
                return this.merge(entity);
            }
            case NULL: {
                return this.merge(entity, true);
            }
        }
        return this.update(entity);
    }

    public <E> int update(List<E> entities, IgnorePolicy ignorePolicy) {
        int size = 0;
        if (Lang.isNotEmpty(entities)) {
            for (E e : entities) {
                size += this.update(e, ignorePolicy);
            }
        }
        return size;
    }

    private <E> int merge(E entity, boolean onlyNull) {
        if (entity == null) {
            return 0;
        }
        MergeOperate<Object> update = this.mergeOperates.get(entity.getClass());
        if (update == null) {
            ClassMapping mapping = this.mappingFactory.getClassMapping(entity.getClass());
            update = new MergeOperate(this.jdbc, mapping, this.mappingFactory.getSqlTypeMappingManager(), this.mappingFactory.getMetadata());
            this.mergeOperates.put(entity.getClass(), update);
        }
        this.validate(entity);
        return update.execute(entity, onlyNull);
    }

    public <E> int merge(E entity) {
        return this.merge(entity, false);
    }

    public <E> int merge(E ... entities) {
        int size = 0;
        if (Lang.isNotEmpty((Object[])entities)) {
            for (E e : entities) {
                size += this.merge(e);
            }
        }
        return size;
    }

    public <E> int merge(List<E> entities) {
        int size = 0;
        if (Lang.isNotEmpty(entities)) {
            for (E e : entities) {
                size += this.merge(e);
            }
        }
        return size;
    }

    public <E> int delete(Serializable id, @Nonnull Class<E> entityType) {
        if (id == null || entityType == null) {
            return 0;
        }
        DeleteOperate<E> delete = this.getDelete(entityType);
        return delete.delete(id);
    }

    public <E> int delete(Serializable[] ids, @Nonnull Class<E> entityType) {
        if (Lang.isEmpty((Object[])ids)) {
            return 0;
        }
        DeleteOperate<E> delete = this.getDelete(entityType);
        return delete.deleteBatch(ids);
    }

    public <E, ID extends Serializable> int delete(List<ID> ids, @Nonnull Class<E> entityType) {
        if (Lang.isEmpty(ids)) {
            return 0;
        }
        DeleteOperate<E> delete = this.getDelete(entityType);
        return delete.deleteBatch(ids);
    }

    public <E> int delete(E entity) {
        if (entity == null) {
            return 0;
        }
        DeleteOperate<E> delete = this.getDelete(entity);
        return delete.execute(entity);
    }

    public <E> int delete(E ... entities) {
        if (Lang.isEmpty((Object[])entities)) {
            return 0;
        }
        DeleteOperate<E> delete = this.getDelete(entities[0]);
        return delete.executeBatch(entities);
    }

    public <E> int delete(List<E> entities) {
        if (Lang.isEmpty(entities)) {
            return 0;
        }
        DeleteOperate<E> delete = this.getDelete(entities.get(0));
        return delete.executeBatch(entities);
    }

    private <E> DeleteOperate<E> getDelete(E entity) {
        Class<?> type = entity.getClass();
        return this.getDelete(type);
    }

    private <E> DeleteOperate<E> getDelete(Class<E> entityType) {
        DeleteOperate<Object> delete = this.deleteOperates.get(entityType);
        if (delete == null) {
            ClassMapping mapping = this.mappingFactory.getClassMapping(entityType);
            delete = new DeleteOperate(this.jdbc, mapping, this.mappingFactory.getSqlTypeMappingManager(), this.mappingFactory.getMetadata());
            this.deleteOperates.put(entityType, delete);
        }
        return delete;
    }

    public <E> E get(Serializable id, Class<E> type) {
        if (id == null || type == null) {
            return null;
        }
        GetOperate<E> get = this.getOperate(type);
        return (E)get.get((E)id);
    }

    public <E> List<E> get(Class<E> type, Serializable ... ids) {
        ArrayList<E> list = new ArrayList<E>();
        if (Lang.isEmpty((Object[])ids)) {
            return list;
        }
        for (Serializable id : ids) {
            list.add(this.get(id, type));
        }
        return list;
    }

    public <E> List<E> get(Class<E> type, List<Serializable> ids) {
        ArrayList<E> list = new ArrayList<E>();
        if (Lang.isEmpty(ids)) {
            return list;
        }
        for (Serializable id : ids) {
            list.add(this.get(id, type));
        }
        return list;
    }

    public <E> E get(E entity) {
        if (entity == null) {
            return null;
        }
        GetOperate<?> get = this.getOperate(entity.getClass());
        return (E)get.get(entity);
    }

    public QueryEntity query(String repository) {
        SqlQuery query = new SqlQuery(this.jdbc, this.mappingFactory, this.sqlTplExecutor.getSqlPageFactory());
        return query.find(repository);
    }

    public <E> TypeQueryEntity query(Class<E> entityType) {
        SqlQuery query = new SqlQuery(this.jdbc, this.mappingFactory, this.sqlTplExecutor.getSqlPageFactory());
        return query.find(entityType);
    }

    public <E> Update update(Class<E> entityType) {
        SqlUpdater updater = new SqlUpdater(this.jdbc, this.mappingFactory);
        return updater.update(entityType);
    }

    public Update update(String repository) {
        SqlUpdater updater = new SqlUpdater(this.jdbc, this.mappingFactory);
        return updater.update(repository);
    }

    public Delete delete(String repository) {
        SqlDeleter deleter = new SqlDeleter(this.jdbc, this.mappingFactory);
        return deleter.delete(repository);
    }

    public <E> Delete delete(Class<E> entityType) {
        SqlDeleter deleter = new SqlDeleter(this.jdbc, this.mappingFactory);
        return deleter.delete(entityType);
    }

    private <E> void validate(E entity) {
        Set cons;
        if (this.validator != null && Lang.isNotEmpty((Collection)(cons = this.validator.validate(entity, new Class[0])))) {
            StringBuilder errorMessage = new StringBuilder();
            for (ConstraintViolation constraintViolation : cons) {
                errorMessage.append(constraintViolation.getMessage()).append(",");
            }
            throw new SqldbHammerException(errorMessage.toString());
        }
    }

    private <E> GetOperate<E> getOperate(Class<E> entityType) {
        GetOperate<Object> get = this.getOperates.get(entityType);
        if (get == null) {
            ClassMapping mapping = this.mappingFactory.getClassMapping(entityType);
            get = new GetOperate(this.jdbc, mapping, this.mappingFactory.getSqlTypeMappingManager(), this.mappingFactory.getMetadata());
            this.getOperates.put(entityType.getClass(), get);
        }
        return get;
    }

    public <E> E single(String tplExecuteId, Class<E> entityType, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, entityType, params);
    }

    public <E> List<E> list(String tplExecuteId, Class<E> entityType, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType, params);
    }

    public <E> List<E> list(String tplExecuteId, Class<E> entityType, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType, params, offset, limit);
    }

    public <E> List<E> list(String tplExecuteId, Class<E> entityType, Map<String, Object> params, Page page) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType, params, page);
    }

    public <E> PaginationResults<E> pagination(String tplExecuteId, Class<E> entityType, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType, params, offset, limit);
    }

    public <E> PaginationResults<E> pagination(String tplExecuteId, Class<E> entityType, Map<String, Object> params, Page page) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType, params, page);
    }

    public <E> E single(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, entityType, params);
    }

    public <E> List<E> list(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType, params);
    }

    public <E> List<E> list(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType, params, offset, limit);
    }

    public <E> List<E> list(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params, Page page) {
        return this.sqlTplExecutor.list(tplExecuteId, entityType, params, page);
    }

    public <E> PaginationResults<E> pagination(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType, params, offset, limit);
    }

    public <E> PaginationResults<E> pagination(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params, Page page) {
        return this.sqlTplExecutor.pagination(tplExecuteId, entityType, params, page);
    }

    public Map<String, Object> single(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, params);
    }

    public Map<String, Object> single(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.single(tplExecuteId, params);
    }

    public List<Map<String, Object>> list(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, params);
    }

    public List<Map<String, Object>> list(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.list(tplExecuteId, params);
    }

    public List<Map<String, Object>> list(String tplExecuteId, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, params, offset, limit);
    }

    public List<Map<String, Object>> list(TplExecuteId tplExecuteId, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.list(tplExecuteId, params, offset, limit);
    }

    public List<Map<String, Object>> list(String tplExecuteId, Map<String, Object> params, Page page) {
        return this.sqlTplExecutor.list(tplExecuteId, params, page);
    }

    public List<Map<String, Object>> list(TplExecuteId tplExecuteId, Map<String, Object> params, Page page) {
        return this.sqlTplExecutor.list(tplExecuteId, params, page);
    }

    public PaginationResults<Map<String, Object>> pagination(String tplExecuteId, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, params, offset, limit);
    }

    public PaginationResults<Map<String, Object>> pagination(TplExecuteId tplExecuteId, Map<String, Object> params, int offset, int limit) {
        return this.sqlTplExecutor.pagination(tplExecuteId, params, offset, limit);
    }

    public PaginationResults<Map<String, Object>> pagination(String tplExecuteId, Map<String, Object> params, Page page) {
        return this.sqlTplExecutor.pagination(tplExecuteId, params, page);
    }

    public PaginationResults<Map<String, Object>> pagination(TplExecuteId tplExecuteId, Map<String, Object> params, Page page) {
        return this.sqlTplExecutor.pagination(tplExecuteId, params, page);
    }

    public <E> E value(String tplExecuteId, Class<E> valueType, Map<String, Object> params) {
        return this.sqlTplExecutor.value(tplExecuteId, valueType, params);
    }

    public <N extends Number> N number(String tplExecuteId, Class<N> numberType, Map<String, Object> params) {
        return this.sqlTplExecutor.number(tplExecuteId, numberType, params);
    }

    public Integer numberInt(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.numberInt(tplExecuteId, params);
    }

    public Long numberLong(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.numberLong(tplExecuteId, params);
    }

    public BigDecimal numberBigDecimal(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.numberBigDecimal(tplExecuteId, params);
    }

    public Double numberDouble(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.numberDouble(tplExecuteId, params);
    }

    public String string(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.string(tplExecuteId, params);
    }

    public <E> E value(TplExecuteId tplExecuteId, Class<E> valueType, Map<String, Object> params) {
        return this.sqlTplExecutor.value(tplExecuteId, valueType, params);
    }

    public <N extends Number> N number(TplExecuteId tplExecuteId, Class<N> numberType, Map<String, Object> params) {
        return this.sqlTplExecutor.number(tplExecuteId, numberType, params);
    }

    public int intValue(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.intValue(tplExecuteId, params);
    }

    public int intValue(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.intValue(tplExecuteId, params);
    }

    public long longValue(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.longValue(tplExecuteId, params);
    }

    public long longValue(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.longValue(tplExecuteId, params);
    }

    public double doubleValue(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.doubleValue(tplExecuteId, params);
    }

    public double doubleValue(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.doubleValue(tplExecuteId, params);
    }

    public Integer numberInt(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.numberInt(tplExecuteId, params);
    }

    public Long numberLong(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.numberLong(tplExecuteId, params);
    }

    public BigDecimal numberBigDecimal(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.numberBigDecimal(tplExecuteId, params);
    }

    public Double numberDouble(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.numberDouble(tplExecuteId, params);
    }

    public String string(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.string(tplExecuteId, params);
    }

    public int execute(String tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.execute(tplExecuteId, params);
    }

    public int execute(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.sqlTplExecutor.execute(tplExecuteId, params);
    }

    @Override
    public Jdbc getJdbc() {
        return this.jdbc;
    }

    @Override
    public JdbcMappingFactory getMappingFactory() {
        return this.mappingFactory;
    }
}

