/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.BeanDescriptor;
import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.db.metadata.DatabaseMetadataManager;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.PropertyMapping;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperate<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String sql;
    protected Jdbc jdbc;
    protected ClassMapping<T> classMapping;
    protected BeanDescriptor<T> beanDescriptor;
    protected SqlTypeMappingManager sqlTypeMappingManager;
    protected DatabaseMetadata meta;
    protected Map<Integer, String> propertyPositions = new HashMap<Integer, String>(0);
    protected List<BeanProperty<Serializable>> pkProperties = new ArrayList<BeanProperty<Serializable>>();

    public AbstractOperate(Jdbc jdbc, ClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager) {
        this(jdbc, classMapping, sqlTypeMappingManager, "");
    }

    public AbstractOperate(Jdbc jdbc, ClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, String dataBase) {
        this.meta = Lang.isEmpty((String)dataBase) ? DatabaseMetadataManager.getDefaultManager().create(jdbc.getDataSource()) : DatabaseMetadataManager.getDefaultManager().create(jdbc.getDataSource(), dataBase);
        this.jdbc = jdbc;
        this.classMapping = classMapping;
        this.sqlTypeMappingManager = sqlTypeMappingManager == null ? new SqlTypeMappingManager() : sqlTypeMappingManager;
        this.init();
    }

    public AbstractOperate(Jdbc jdbc, ClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata) {
        this.jdbc = jdbc;
        this.classMapping = classMapping;
        this.meta = databaseMetadata;
        this.sqlTypeMappingManager = sqlTypeMappingManager == null ? new SqlTypeMappingManager() : sqlTypeMappingManager;
        this.init();
    }

    private void init() {
        this.beanDescriptor = BeanDescriptor.getBeanDescriptor((Class)this.classMapping.getType());
        for (PropertyMapping pm : this.classMapping.getPrivaryKeyPropertyMappings()) {
            this.pkProperties.add((BeanProperty<Serializable>)BeanDescriptor.getBeanDescriptor((Class)this.classMapping.getType()).getBeanProperty(pm.getPropertyFullName()));
        }
        this.initSql();
    }

    public String getSql() {
        return this.sql;
    }

    protected void setParameter(PreparedStatement prep, T entity, SqlTypeMappingManager manager) {
        BeanDescriptor beanDescriptor = BeanDescriptor.getBeanDescriptor(entity.getClass());
        for (Map.Entry<Integer, String> propertyPosition : this.propertyPositions.entrySet()) {
            BeanProperty property = beanDescriptor.getBeanProperty(propertyPosition.getValue());
            manager.set(prep, propertyPosition.getKey().intValue(), BeanUtils.getProperty(entity, (String)propertyPosition.getValue()), (GenericType)property);
        }
    }

    protected void setParameter(PreparedStatement prep, T entity, int index, SqlTypeMappingManager manager) {
        int len = this.propertyPositions.size();
        BeanDescriptor beanDescriptor = BeanDescriptor.getBeanDescriptor(entity.getClass());
        for (Map.Entry<Integer, String> propertyPosition : this.propertyPositions.entrySet()) {
            int position = propertyPosition.getKey() + index * len;
            BeanProperty property = beanDescriptor.getBeanProperty(propertyPosition.getValue());
            manager.set(prep, position, BeanUtils.getProperty(entity, (String)propertyPosition.getValue()), (GenericType)property);
        }
    }

    protected Object[] setParameters(T entity, PreparedStatement prep, SqlTypeMappingManager manager) {
        return this.setParameters(entity, this.propertyPositions, prep, manager);
    }

    protected Object[] setParameters(T entity, Map<Integer, String> propertyPositions, PreparedStatement prep, SqlTypeMappingManager manager) {
        BeanDescriptor beanDescriptor = BeanDescriptor.getBeanDescriptor(entity.getClass());
        Object[] params = new Object[propertyPositions.size()];
        int i = 0;
        for (Map.Entry<Integer, String> propertyPosition : propertyPositions.entrySet()) {
            Object value;
            BeanProperty property = beanDescriptor.getBeanProperty(propertyPosition.getValue());
            params[i] = value = BeanUtils.getProperty(entity, (String)propertyPosition.getValue());
            manager.set(prep, ++i, value, (GenericType)property);
        }
        return params;
    }

    public Object[] setBatchParameters(List<T> entities, Map<Integer, String> propertyPositions, PreparedStatement prep, SqlTypeMappingManager manager) {
        if (Lang.isEmpty(entities)) {
            return new Object[0];
        }
        BeanDescriptor beanDescriptor = BeanDescriptor.getBeanDescriptor(entities.get(0).getClass());
        Object[] params = new Object[propertyPositions.size()];
        int pkNum = propertyPositions.size() / entities.size();
        int i = 0;
        Object entity = null;
        for (Map.Entry<Integer, String> propertyPosition : propertyPositions.entrySet()) {
            if (i % pkNum == 0) {
                entity = entities.get(i / pkNum);
            }
            params[i] = BeanUtils.getProperty(entity, (String)propertyPosition.getValue());
            BeanProperty property = beanDescriptor.getBeanProperty(propertyPosition.getValue());
            manager.set(prep, i + 1, params[i], (GenericType)property);
            ++i;
        }
        return params;
    }

    protected void setBatchParameters(List<T> entities, Map<Integer, String> propertyPositions, SqlTypeMappingManager manager) {
    }

    public Object[] getParameters(T entity) {
        return this.getParameters(entity, this.propertyPositions);
    }

    public Object[] getBatchParameters(List<T> entities, Map<Integer, String> propertyPositions) {
        if (Lang.isEmpty(entities)) {
            return new Object[0];
        }
        Object[] params = new Object[propertyPositions.size()];
        int pkNum = propertyPositions.size() / entities.size();
        int i = 0;
        Object entity = null;
        for (Map.Entry<Integer, String> propertyPosition : propertyPositions.entrySet()) {
            if (i % pkNum == 0) {
                entity = entities.get(i / pkNum);
            }
            params[i] = BeanUtils.getProperty(entity, (String)propertyPosition.getValue());
            ++i;
        }
        return params;
    }

    protected Object[] getParameters(T entity, Map<Integer, String> propertyPositions) {
        Object[] params = new Object[propertyPositions.size()];
        int i = 0;
        for (Map.Entry<Integer, String> propertyPosition : propertyPositions.entrySet()) {
            params[i] = BeanUtils.getProperty(entity, (String)propertyPosition.getValue());
            ++i;
        }
        return params;
    }

    protected void setParameter(PreparedStatement prep, Serializable id, SqlTypeMappingManager manager) {
        manager.set(prep, 1, (Object)id, (GenericType)this.pkProperties.get(0));
    }

    protected void setParameter(PreparedStatement prep, List<Serializable> ids, SqlTypeMappingManager manager) {
        int i = 0;
        for (Serializable id : ids) {
            manager.set(prep, ++i, (Object)id, (GenericType)this.pkProperties.get(i - 1));
        }
    }

    protected abstract void initSql();
}

