/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.lang.CollectionUtils;
import cn.featherfly.common.repository.Execution;
import cn.featherfly.common.repository.SimpleExecution;
import cn.featherfly.common.repository.mapping.RowMapper;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.JdbcExecutionInterceptor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JdbcExecution
extends SimpleExecution {
    private Jdbc jdbc;
    private List<JdbcExecutionInterceptor> interceptors = new ArrayList<JdbcExecutionInterceptor>(0);

    public JdbcExecution(Jdbc jdbc, String execute, Object ... params) {
        super(execute, params);
        this.jdbc = jdbc;
    }

    public JdbcExecution(Jdbc jdbc, String execute, Object[] params, JdbcExecutionInterceptor ... executionInterceptors) {
        super(execute, params);
        this.jdbc = jdbc;
        CollectionUtils.addAll(this.interceptors, (Object[])executionInterceptors);
    }

    public int update() {
        this.before();
        int result = this.jdbc.update(this.getExecution(), this.getParams());
        this.after();
        return result;
    }

    public List<Map<String, Object>> query() {
        this.before();
        List<Map<String, Object>> result = this.jdbc.query(this.getExecution(), this.getParams());
        this.after();
        return result;
    }

    public <T> List<T> query(RowMapper<T> rowMapper) {
        this.before();
        List<T> result = this.jdbc.query(this.getExecution(), rowMapper, this.getParams());
        this.after();
        return result;
    }

    public <T> List<T> query(Class<T> elementType) {
        this.before();
        List<T> result = this.jdbc.query(this.getExecution(), elementType, this.getParams());
        this.after();
        return result;
    }

    public Map<String, Object> querySingle() {
        this.before();
        Map<String, Object> result = this.jdbc.querySingle(this.getExecution(), this.getParams());
        this.after();
        return result;
    }

    public <T> T querySingle(RowMapper<T> rowMapper) {
        this.before();
        T result = this.jdbc.querySingle(this.getExecution(), rowMapper, this.getParams());
        this.after();
        return result;
    }

    public <T> T querySingle(Class<T> elementType) {
        this.before();
        T result = this.jdbc.querySingle(this.getExecution(), elementType, this.getParams());
        this.after();
        return result;
    }

    public Map<String, Object> queryUnique() {
        this.before();
        Map<String, Object> result = this.jdbc.queryUnique(this.getExecution(), this.getParams());
        this.after();
        return result;
    }

    public <T> T queryUnique(RowMapper<T> rowMapper) {
        this.before();
        T result = this.jdbc.queryUnique(this.getExecution(), rowMapper, this.getParams());
        this.after();
        return result;
    }

    public <T> T queryUnique(Class<T> elementType) {
        this.before();
        T result = this.jdbc.queryUnique(this.getExecution(), elementType, this.getParams());
        this.after();
        return result;
    }

    public Integer queryInt() {
        this.before();
        Integer result = this.jdbc.queryInt(this.getExecution(), this.getParams());
        this.after();
        return result;
    }

    public Long queryLong() {
        this.before();
        Long result = this.jdbc.queryLong(this.getExecution(), this.getParams());
        this.after();
        return result;
    }

    public BigDecimal queryBigDecimal() {
        this.before();
        BigDecimal result = this.jdbc.queryBigDecimal(this.getExecution(), this.getParams());
        this.after();
        return result;
    }

    public Double queryDouble() {
        this.before();
        Double result = this.jdbc.queryDouble(this.getExecution(), this.getParams());
        this.after();
        return result;
    }

    public String queryString() {
        this.before();
        String result = this.jdbc.queryString(this.getExecution(), this.getParams());
        this.after();
        return result;
    }

    public <T> T queryValue(Class<T> valueType) {
        this.before();
        T result = this.jdbc.queryValue(this.getExecution(), valueType, this.getParams());
        this.after();
        return result;
    }

    public <T> T queryValue(RowMapper<T> rowMapper) {
        this.before();
        T result = this.jdbc.queryValue(this.getExecution(), rowMapper, this.getParams());
        this.after();
        return result;
    }

    private void before() {
        for (JdbcExecutionInterceptor interceptor : this.interceptors) {
            interceptor.preHandle((Execution)this);
        }
    }

    private void after() {
        for (JdbcExecutionInterceptor interceptor : this.interceptors) {
            interceptor.postHandle((Execution)this);
        }
    }
}

