/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.PropertyMapping;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractExecuteOperate;
import com.speedment.common.tuple.Tuple2;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;

public class InsertOperate<T>
extends AbstractExecuteOperate<T> {
    public InsertOperate(Jdbc jdbc, ClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager) {
        super(jdbc, classMapping, sqlTypeMappingManager);
    }

    public InsertOperate(Jdbc jdbc, ClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, String dataBase) {
        super(jdbc, classMapping, sqlTypeMappingManager, dataBase);
    }

    public InsertOperate(Jdbc jdbc, ClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, sqlTypeMappingManager, databaseMetadata);
    }

    public int executeBatch(T[] entities) {
        return this.executeBatch(ArrayUtils.toList((Object[])entities));
    }

    public int executeBatch(List<T> entities) {
        return this.executeBatch(entities, true);
    }

    public int executeBatch(List<T> entities, boolean autoSetGenerateId) {
        if (this.jdbc.getDialect().isInsertBatch()) {
            return this.jdbc.execute((con, manager) -> {
                Tuple2 tuple = ClassMappingUtils.getInsertBatchSqlAndParamPositions((int)entities.size(), (ClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
                String sql = (String)tuple.get0();
                List pks = this.classMapping.getPrivaryKeyPropertyMappings();
                PreparedStatement prep = null;
                prep = pks.size() == 1 && autoSetGenerateId ? con.prepareStatement(sql, 1) : con.prepareStatement(sql);
                int index = 0;
                for (Object entity : entities) {
                    this.setParameter(prep, entity, index, manager);
                    ++index;
                }
                this.logger.debug("execute sql: {}", (Object)sql);
                int result = prep.executeUpdate();
                if (pks.size() == 1 && autoSetGenerateId) {
                    PropertyMapping pm = (PropertyMapping)pks.get(0);
                    ResultSet res = prep.getGeneratedKeys();
                    StringBuilder msg = null;
                    if (this.logger.isDebugEnabled()) {
                        msg = new StringBuilder("\u81ea\u52a8\u751f\u6210\u7684\u952e\u503c : ");
                    }
                    index = 0;
                    while (res.next()) {
                        Object value = manager.get(res, 1, (GenericType)this.pkProperties.get(0));
                        if (this.logger.isDebugEnabled()) {
                            msg.append(" ").append(value).append(", ");
                        }
                        BeanUtils.setProperty(entities.get(index), (String)pm.getPropertyName(), (Object)value);
                        ++index;
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(msg.toString());
                    }
                }
                prep.close();
                return result;
            });
        }
        int size = 0;
        for (T entity : entities) {
            size += this.execute(entity);
        }
        return size;
    }

    @Override
    public int execute(T entity) {
        return this.jdbc.execute((con, manager) -> {
            List pks = this.classMapping.getPrivaryKeyPropertyMappings();
            PreparedStatement prep = null;
            prep = pks.size() == 1 ? con.prepareStatement(this.sql, 1) : con.prepareStatement(this.sql);
            this.setParameter(prep, entity, manager);
            this.logger.debug("execute sql: {}", (Object)this.sql);
            int result = prep.executeUpdate();
            if (pks.size() == 1) {
                PropertyMapping pm = (PropertyMapping)pks.get(0);
                ResultSet res = prep.getGeneratedKeys();
                StringBuilder msg = null;
                if (this.logger.isDebugEnabled()) {
                    msg = new StringBuilder("\u81ea\u52a8\u751f\u6210\u7684\u952e\u503c : ");
                }
                if (res.next()) {
                    Object value = manager.get(res, 1, (GenericType)this.pkProperties.get(0));
                    if (this.logger.isDebugEnabled()) {
                        msg.append(" ").append(value).append(", ");
                    }
                    BeanUtils.setProperty((Object)entity, (String)pm.getPropertyName(), (Object)value);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(msg.toString());
                }
            }
            prep.close();
            return result;
        });
    }

    @Override
    public void initSql() {
        Tuple2 tuple = ClassMappingUtils.getInsertSqlAndParamPositions((ClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        this.sql = (String)tuple.get0();
        this.propertyPositions.putAll((Map)tuple.get1());
        this.logger.debug("sql: {}", (Object)this.sql);
    }
}

