/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.tpl.freemarker.directive;

import cn.featherfly.common.lang.Strings;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.tpl.TplException;
import cn.featherfly.hammer.tpl.directive.LogicDirective;
import cn.featherfly.hammer.tpl.freemarker.FreemarkerDirective;
import cn.featherfly.hammer.tpl.supports.ConditionParamsManager;
import freemarker.core.Environment;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class LogicTemplateDirectiveModel
implements FreemarkerDirective,
LogicDirective {
    private static final String BETWEEN = "between";
    private static final Pattern CONDITION_PATTERN = Pattern.compile("(\\w+) *(([=><]|<>|!=|>=|<=|!>|!<| like | in | is ) *(:\\w+|\\?)|(between) +(:\\w+|\\?) *(and) *(:\\w+|\\?))", 2);
    private ConditionParamsManager conditionParamsManager;

    public LogicTemplateDirectiveModel(ConditionParamsManager conditionParamsManager) {
        this.conditionParamsManager = conditionParamsManager;
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        Boolean ifParam = null;
        String nameParam = null;
        String transverterParam = null;
        Set entrySet = params.entrySet();
        for (Map.Entry ent : entrySet) {
            String paramName = (String)ent.getKey();
            TemplateModel paramValue = (TemplateModel)ent.getValue();
            if (paramName.equals("if")) {
                if (!(paramValue instanceof TemplateBooleanModel)) {
                    throw new TplException("The \"if\" parameter must be a boolean.");
                }
                ifParam = ((TemplateBooleanModel)paramValue).getAsBoolean();
                continue;
            }
            if (paramName.equals("name")) {
                if (!(paramValue instanceof TemplateScalarModel)) {
                    throw new TplException("The \"name\" parameter must be a String.");
                }
                nameParam = ((TemplateScalarModel)paramValue).getAsString();
                continue;
            }
            if (paramName.equals("transverter")) {
                if (!(paramValue instanceof TemplateScalarModel)) {
                    throw new TplException("The \"transverter\" parameter must be a String.");
                }
                transverterParam = ((TemplateScalarModel)paramValue).getAsString();
                continue;
            }
            throw new TplException("Unsupported parameter: " + paramName);
        }
        Writer out = env.getOut();
        if (body != null) {
            if (ifParam == null) {
                boolean needAppendLogicWorld = this.conditionParamsManager.isNeedAppendLogicWorld();
                this.conditionParamsManager.startGroup();
                StringWriter stringWriter = new StringWriter();
                body.render((Writer)stringWriter);
                String condition = stringWriter.toString().trim();
                if (condition.length() > 0) {
                    String result = "";
                    result = needAppendLogicWorld ? " " + this.getLogicWorld() + " ( " + condition + " )" : " ( " + condition + " )";
                    out.write(result);
                }
                this.conditionParamsManager.endGroup();
            } else if (ifParam.booleanValue()) {
                String name = nameParam;
                boolean needAppendLogicWorld = this.conditionParamsManager.isNeedAppendLogicWorld();
                StringWriter stringWriter = new StringWriter();
                body.render((Writer)stringWriter);
                String condition = stringWriter.toString().trim();
                if (StringUtils.isBlank((CharSequence)name) && condition.length() > 0) {
                    Object m = null;
                    m = CONDITION_PATTERN.matcher(condition);
                    if (!((Matcher)m).matches()) {
                        throw new IllegalArgumentException("[" + condition + "] \u67e5\u8be2\u6761\u4ef6\u65e0\u6cd5\u83b7\u53d6\u6761\u4ef6\u540d\u79f0\uff0c\u8bf7\u76f4\u63a5\u5728\u6307\u4ee4\u4e0a\u8bbe\u7f6e\u53c2\u6570\u540d\u79f0<@and name=\"paramName\">");
                    }
                    String paramType = null;
                    boolean betweenAnd = false;
                    if (BETWEEN.equalsIgnoreCase(((Matcher)m).group(5))) {
                        paramType = ((Matcher)m).group(6);
                        betweenAnd = true;
                    } else {
                        paramType = ((Matcher)m).group(4);
                    }
                    if ("?".equals(paramType)) {
                        if (this.conditionParamsManager.getParamNamed() != null && this.conditionParamsManager.getParamNamed().booleanValue()) {
                            throw new SqldbHammerException("\u4e0d\u80fdname = ? \u548c name = :name\u6df7\u5408\u4e00\u8d77\u7528");
                        }
                        this.conditionParamsManager.setParamNamed(Boolean.valueOf(false));
                        name = ((Matcher)m).group(1);
                        if (StringUtils.isBlank((CharSequence)name) || betweenAnd) {
                            throw new IllegalArgumentException("[" + condition + "] \u67e5\u8be2\u6761\u4ef6\u65e0\u6cd5\u83b7\u53d6\u6761\u4ef6\u540d\u79f0\uff0c\u8bf7\u76f4\u63a5\u5728\u6307\u4ee4\u4e0a\u8bbe\u7f6e\u53c2\u6570\u540d\u79f0<@and name=\"paramName\">\u6216\u8005<@and name=\"paramName1,paramName2\">");
                        }
                    } else if (paramType.startsWith(":")) {
                        if (this.conditionParamsManager.getParamNamed() != null && !this.conditionParamsManager.getParamNamed().booleanValue()) {
                            throw new SqldbHammerException("\u4e0d\u80fdname = ? \u548c name = :name\u6df7\u5408\u4e00\u8d77\u7528");
                        }
                        this.conditionParamsManager.setParamNamed(Boolean.valueOf(true));
                        name = paramType.substring(1);
                        if (betweenAnd) {
                            name = name + "," + ((Matcher)m).group(8).substring(1);
                        }
                    }
                }
                if (name.contains(",")) {
                    for (String n : name.split(",")) {
                        ConditionParamsManager.Param param = new ConditionParamsManager.Param();
                        if (Strings.isNotBlank((String)transverterParam)) {
                            param.setTransverter(transverterParam.trim());
                        }
                        param.setName(n.trim());
                        this.conditionParamsManager.addParam(param);
                    }
                } else {
                    ConditionParamsManager.Param param = new ConditionParamsManager.Param();
                    if (Strings.isNotBlank((String)transverterParam)) {
                        param.setTransverter(transverterParam.trim());
                    }
                    param.setName(name.trim());
                    this.conditionParamsManager.addParam(param);
                }
                if (needAppendLogicWorld) {
                    condition = " " + this.getLogicWorld() + " " + condition;
                }
                out.write(condition);
            } else {
                out.write("");
            }
        }
    }

    protected abstract String getLogicWorld();
}

