/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.dsl.query;

import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.LambdaUtils;
import cn.featherfly.common.lang.function.SerializableFunction;
import cn.featherfly.common.lang.function.SerializableSupplier;
import cn.featherfly.common.repository.builder.AliasManager;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.MappingFactory;
import cn.featherfly.common.repository.mapping.PropertyMapping;
import cn.featherfly.common.repository.operate.AggregateFunction;
import cn.featherfly.common.structure.page.Page;
import cn.featherfly.hammer.dsl.query.TypeQueryConditionGroupExpression;
import cn.featherfly.hammer.dsl.query.TypeQueryEntityProperties;
import cn.featherfly.hammer.dsl.query.TypeQueryWithEntity;
import cn.featherfly.hammer.expression.query.TypeQueryLimitExecutor;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.dsl.query.AbstractSqlQueryEntityProperties;
import cn.featherfly.hammer.sqldb.jdbc.dsl.query.SqlQueryExpression;
import cn.featherfly.hammer.sqldb.jdbc.dsl.query.TypeSqlQueryEntity;
import cn.featherfly.hammer.sqldb.jdbc.dsl.query.TypeSqlQueryExpression;
import cn.featherfly.hammer.sqldb.jdbc.dsl.query.TypeSqlQueryWith;
import java.util.ArrayList;
import java.util.List;

public class TypeSqlQueryEntityProperties
extends AbstractSqlQueryEntityProperties<TypeSqlQueryEntityProperties>
implements TypeSqlQueryEntity,
TypeQueryEntityProperties {
    List<TypeSqlQueryWith> typeSqlQueryWiths = new ArrayList<TypeSqlQueryWith>();

    public TypeSqlQueryEntityProperties(Jdbc jdbc, ClassMapping<?> classMapping, MappingFactory factory, AliasManager aliasManager) {
        super(jdbc, classMapping, factory, aliasManager);
    }

    public TypeQueryConditionGroupExpression where() {
        return new TypeSqlQueryExpression(this.jdbc, this.classMapping, this, this.factory, this.aliasManager, this.selectBuilder);
    }

    public <E> List<E> list() {
        return new TypeSqlQueryExpression(this.jdbc, this.classMapping, this, this.factory, this.aliasManager, this.selectBuilder).list();
    }

    public TypeQueryLimitExecutor limit(Integer limit) {
        return new TypeSqlQueryExpression(this.jdbc, this.classMapping, this, this.factory, this.aliasManager, this.selectBuilder).limit(limit);
    }

    public TypeQueryLimitExecutor limit(Integer offset, Integer limit) {
        return new TypeSqlQueryExpression(this.jdbc, this.classMapping, this, this.factory, this.aliasManager, this.selectBuilder).limit(offset, limit);
    }

    public TypeQueryLimitExecutor limit(Page page) {
        return new TypeSqlQueryExpression(this.jdbc, this.classMapping, this, this.factory, this.aliasManager, this.selectBuilder).limit(page);
    }

    public Long count() {
        return new SqlQueryExpression(this.jdbc, this.classMapping, this.selectBuilder.addSelectColumn("*", AggregateFunction.COUNT)).longInt();
    }

    public <T> TypeQueryWithEntity with(SerializableSupplier<T> propertyName) {
        LambdaUtils.SerializedLambdaInfo joinInfo = LambdaUtils.getLambdaInfo(propertyName);
        return this.with(joinInfo);
    }

    public <T, R> TypeQueryWithEntity with(SerializableFunction<T, R> propertyName) {
        LambdaUtils.SerializedLambdaInfo joinInfo = LambdaUtils.getLambdaInfo(propertyName);
        return this.with(joinInfo);
    }

    private TypeQueryWithEntity with(LambdaUtils.SerializedLambdaInfo joinInfo) {
        TypeSqlQueryWith typeSqlQueryWith = this.with(this.classMapping, this.selectBuilder.getTableAlias(), joinInfo);
        if (typeSqlQueryWith != null) {
            return typeSqlQueryWith;
        }
        for (TypeSqlQueryWith with : this.typeSqlQueryWiths) {
            if (this.classMapping != with.joinTypeClassMapping && (typeSqlQueryWith = this.with(with.joinTypeClassMapping, with.joinTableAlias, joinInfo)) != null) {
                return typeSqlQueryWith;
            }
            if (this.classMapping == with.conditionTypeClassMapping || (typeSqlQueryWith = this.with(with.conditionTypeClassMapping, with.conditionTableAlias, joinInfo)) == null) continue;
            return typeSqlQueryWith;
        }
        throw new SqldbHammerException("there is no relation find for lambda property -> " + joinInfo.getMethodInstanceClassName() + "." + joinInfo.getMethodName());
    }

    public <T, R> TypeQueryWithEntity with(SerializableFunction<T, R> propertyName, int index) {
        if (index <= 0) {
            throw new SqldbHammerException("index must > 0");
        }
        if (index > this.typeSqlQueryWiths.size()) {
            throw new SqldbHammerException("index must < invoke with method times");
        }
        LambdaUtils.SerializedLambdaInfo joinInfo = LambdaUtils.getLambdaInfo(propertyName);
        TypeSqlQueryWith with = this.typeSqlQueryWiths.get(index - 1);
        return this.with(with.joinTypeClassMapping, with.joinTableAlias, joinInfo);
    }

    private TypeSqlQueryWith with(ClassMapping<?> cm, String tableAlias, LambdaUtils.SerializedLambdaInfo joinInfo) {
        String name = joinInfo.getPropertyName();
        if (cm.getType().getName().equals(joinInfo.getMethodInstanceClassName())) {
            ClassMapping joinClassMapping = this.factory.getClassMapping(joinInfo.getPropertyType());
            PropertyMapping pm = cm.getPropertyMapping(name);
            TypeSqlQueryWith typeSqlQueryWith = new TypeSqlQueryWith(this, this.aliasManager, this.factory, cm, tableAlias, pm.getRepositoryFieldName(), joinClassMapping, this.getPkMapping(joinClassMapping).getRepositoryFieldName(), name);
            this.typeSqlQueryWiths.add(typeSqlQueryWith);
            return typeSqlQueryWith;
        }
        if (ClassUtils.isParent((Class)cm.getType(), (Class)joinInfo.getPropertyType())) {
            ClassMapping joinClassMapping = this.factory.getClassMapping(ClassUtils.forName((String)joinInfo.getMethodInstanceClassName()));
            PropertyMapping pm = joinClassMapping.getPropertyMapping(name);
            TypeSqlQueryWith typeSqlQueryWith = new TypeSqlQueryWith(this, this.aliasManager, this.factory, cm, tableAlias, this.getIdName(), joinClassMapping, pm.getRepositoryFieldName());
            this.typeSqlQueryWiths.add(typeSqlQueryWith);
            return typeSqlQueryWith;
        }
        return null;
    }

    @Override
    protected String getIdName() {
        return this.getPkMapping(this.classMapping).getRepositoryFieldName();
    }

    private PropertyMapping getPkMapping(ClassMapping<?> classMapping) {
        if (classMapping.getPrivaryKeyPropertyMappings().size() > 1) {
            throw new SqldbHammerException(String.format("there is more than one privary key property in type(%s)", classMapping.getType().getName()));
        }
        if (classMapping.getPrivaryKeyPropertyMappings().size() == 0) {
            throw new SqldbHammerException(String.format("there is no privary key property in type(%s)", classMapping.getType().getName()));
        }
        return (PropertyMapping)classMapping.getPrivaryKeyPropertyMappings().get(0);
    }
}

