/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.bean.BeanDescriptor;
import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.mapping.JdbcMappingException;
import cn.featherfly.common.db.mapping.SqlResultSet;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.repository.mapping.ResultSet;
import java.beans.PropertyDescriptor;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class NestedBeanPropertyRowMapper<T>
implements RowMapper<T>,
cn.featherfly.common.repository.mapping.RowMapper<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nullable
    private Class<T> mappedClass;
    private boolean checkFullyPopulated = false;
    private boolean primitivesDefaultedForNullValue = false;
    @Nullable
    private ConversionService conversionService = DefaultConversionService.getSharedInstance();
    @Nullable
    private Map<String, PropertyDescriptor> mappedFields;
    @Nullable
    private Set<String> mappedProperties;
    @Nullable
    private SqlTypeMappingManager manager;

    public NestedBeanPropertyRowMapper(Class<T> mappedClass, SqlTypeMappingManager manager) {
        this.initialize(mappedClass);
        this.manager = manager;
    }

    public NestedBeanPropertyRowMapper(Class<T> mappedClass, SqlTypeMappingManager manager, boolean checkFullyPopulated) {
        this.initialize(mappedClass);
        this.manager = manager;
        this.checkFullyPopulated = checkFullyPopulated;
    }

    public void setMappedClass(Class<T> mappedClass) {
        if (this.mappedClass == null) {
            this.initialize(mappedClass);
        } else if (this.mappedClass != mappedClass) {
            throw new InvalidDataAccessApiUsageException("The mapped class can not be reassigned to map to " + mappedClass + " since it is already providing mapping for " + this.mappedClass);
        }
    }

    @Nullable
    public final Class<T> getMappedClass() {
        return this.mappedClass;
    }

    public void setCheckFullyPopulated(boolean checkFullyPopulated) {
        this.checkFullyPopulated = checkFullyPopulated;
    }

    public boolean isCheckFullyPopulated() {
        return this.checkFullyPopulated;
    }

    public void setPrimitivesDefaultedForNullValue(boolean primitivesDefaultedForNullValue) {
        this.primitivesDefaultedForNullValue = primitivesDefaultedForNullValue;
    }

    public boolean isPrimitivesDefaultedForNullValue() {
        return this.primitivesDefaultedForNullValue;
    }

    public void setConversionService(@Nullable ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Nullable
    public ConversionService getConversionService() {
        return this.conversionService;
    }

    protected void initialize(Class<T> mappedClass) {
        PropertyDescriptor[] pds;
        AssertIllegalArgument.isNotNull(mappedClass, (String)"mappedClass");
        this.mappedClass = mappedClass;
        this.mappedFields = new HashMap<String, PropertyDescriptor>();
        this.mappedProperties = new HashSet<String>();
        for (PropertyDescriptor pd : pds = BeanUtils.getPropertyDescriptors(mappedClass)) {
            if (pd.getWriteMethod() == null) continue;
            this.mappedFields.put(this.lowerCaseName(pd.getName()), pd);
            String underscoredName = this.underscoreName(pd.getName());
            if (!this.lowerCaseName(pd.getName()).equals(underscoredName)) {
                this.mappedFields.put(underscoredName, pd);
            }
            this.mappedProperties.add(pd.getName());
        }
    }

    protected String underscoreName(String name) {
        if (!StringUtils.hasLength((String)name)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(this.lowerCaseName(name.substring(0, 1)));
        for (int i = 1; i < name.length(); ++i) {
            String slc;
            String s = name.substring(i, i + 1);
            if (!s.equals(slc = this.lowerCaseName(s))) {
                result.append("_").append(slc);
                continue;
            }
            result.append(s);
        }
        return result.toString();
    }

    protected String lowerCaseName(String name) {
        return name.toLowerCase(Locale.US);
    }

    public T mapRow(ResultSet res, int rowNum) {
        java.sql.ResultSet rs = null;
        if (!(res instanceof SqlResultSet)) {
            throw new JdbcMappingException("ResultSet is not type of SqlResultSet");
        }
        SqlResultSet sqlrs = (SqlResultSet)res;
        rs = sqlrs.getResultSet();
        AssertIllegalArgument.isNotNull((Object)rs, (String)"java.sql.ResultSet");
        try {
            return this.mapRow(rs, rowNum);
        }
        catch (SQLException e) {
            throw new JdbcException((Throwable)e);
        }
    }

    public T mapRow(java.sql.ResultSet rs, int rowNumber) throws SQLException {
        Assert.state((this.mappedClass != null ? 1 : 0) != 0, (String)"Mapped class was not specified");
        Object mappedObject = BeanUtils.instantiateClass(this.mappedClass);
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)mappedObject);
        this.initBeanWrapper(bw);
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        HashSet<String> populatedProperties = this.isCheckFullyPopulated() ? new HashSet<String>() : null;
        for (int index = 1; index <= columnCount; ++index) {
            PropertyDescriptor pd;
            String column = JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)index);
            String field = this.lowerCaseName(StringUtils.delete((String)column, (String)" "));
            boolean nestedProperty = false;
            if (field.contains(".")) {
                nestedProperty = true;
                field = org.apache.commons.lang3.StringUtils.substringBefore((String)field, (String)".");
            }
            PropertyDescriptor propertyDescriptor = pd = this.mappedFields != null ? this.mappedFields.get(field) : null;
            if (pd != null) {
                try {
                    BeanProperty bp;
                    BeanDescriptor bd = BeanDescriptor.getBeanDescriptor(this.mappedClass);
                    Object value = null;
                    if (nestedProperty) {
                        bp = bd.getChildBeanProperty(column);
                        if (bp == null) continue;
                        if (rowNumber == 0) {
                            this.logger.debug("Mapping column '{} as {}' to property '{}' of type '{}'", new Object[]{rsmd.getColumnName(index), column, column, bp.getType().getName()});
                        }
                        value = JdbcUtils.getResultSetValue((java.sql.ResultSet)rs, (int)index, (Class)bp.getType());
                        bd.setProperty(mappedObject, column, value);
                        continue;
                    }
                    bp = bd.getChildBeanProperty(pd.getName());
                    value = bp != null ? this.manager.get(rs, index, (GenericType)bp) : this.getColumnValue(rs, index, pd);
                    if (rowNumber == 0) {
                        this.logger.debug("Mapping column '{}' to property '{}' of type '{}'", new Object[]{column, pd.getName(), ClassUtils.getQualifiedName(pd.getPropertyType())});
                    }
                    try {
                        bw.setPropertyValue(pd.getName(), value);
                    }
                    catch (TypeMismatchException ex) {
                        if (value == null && this.primitivesDefaultedForNullValue) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("Intercepted TypeMismatchException for row " + rowNumber + " and column '" + column + "' with null value when setting property '" + pd.getName() + "' of type '" + ClassUtils.getQualifiedName(pd.getPropertyType()) + "' on object: " + mappedObject, (Throwable)ex);
                            }
                        }
                        throw ex;
                    }
                    if (populatedProperties == null) continue;
                    populatedProperties.add(pd.getName());
                    continue;
                }
                catch (NotWritablePropertyException ex) {
                    throw new DataRetrievalFailureException("Unable to map column '" + column + "' to property '" + pd.getName() + "'", (Throwable)ex);
                }
            }
            if (rowNumber != 0 || !this.logger.isDebugEnabled()) continue;
            this.logger.debug("No property found for column '" + column + "' mapped to field '" + field + "'");
        }
        if (populatedProperties != null && !populatedProperties.equals(this.mappedProperties)) {
            throw new InvalidDataAccessApiUsageException("Given ResultSet does not contain all fields necessary to populate object of class [" + this.mappedClass.getName() + "]: " + this.mappedProperties);
        }
        return (T)mappedObject;
    }

    protected void initBeanWrapper(BeanWrapper bw) {
        ConversionService cs = this.getConversionService();
        if (cs != null) {
            bw.setConversionService(cs);
        }
    }

    @Nullable
    protected Object getColumnValue(java.sql.ResultSet rs, int index, PropertyDescriptor pd) throws SQLException {
        return JdbcUtils.getResultSetValue((java.sql.ResultSet)rs, (int)index, pd.getPropertyType());
    }
}

