/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.repository.Execution;
import cn.featherfly.common.repository.mapping.RowMapper;
import cn.featherfly.hammer.sqldb.jdbc.ConnectionCallback;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.NestedBeanPropertyRowMapper;
import cn.featherfly.hammer.sqldb.jdbc.SingleColumnRowMapper;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbc
implements Jdbc {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected DataSource dataSource;
    protected Dialect dialect;
    protected SqlTypeMappingManager manager;

    public AbstractJdbc() {
        this(new SqlTypeMappingManager());
    }

    public AbstractJdbc(SqlTypeMappingManager manager) {
        this.manager = manager;
    }

    public AbstractJdbc(DataSource dataSource, Dialect dialect) {
        this(dataSource, dialect, new SqlTypeMappingManager());
    }

    public AbstractJdbc(DataSource dataSource, Dialect dialect, SqlTypeMappingManager manager) {
        this.setDataSource(dataSource);
        this.dialect = dialect;
        this.manager = manager;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public <T> T execute(ConnectionCallback<T> action) {
        AssertIllegalArgument.isNotNull(action, (String)"connectionCallback");
        Connection con = this.getConnection();
        try {
            T t = action.doInConnection(con, this.manager);
            return t;
        }
        catch (SQLException ex) {
            this.releaseConnection(con, this.getDataSource());
            con = null;
            throw new JdbcException("ConnectionCallback", (Throwable)ex);
        }
        finally {
            this.releaseConnection(con, this.getDataSource());
        }
    }

    @Override
    public int update(String sql, Map<String, Object> args) {
        this.logger.debug("sql -> {}, args -> {}", (Object)sql, args);
        Execution execution = SqlUtils.convertNamedParamSql((String)sql, args);
        return this.update(execution.getExecution(), execution.getParams());
    }

    @Override
    public int update(String sql, Object ... args) {
        this.logger.debug("sql -> {}, args -> {}", (Object)sql, (Object)args);
        if (Lang.isNotEmpty((String)sql)) {
            sql = sql.trim();
            return this.executeUpdate(sql, args);
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    private int executeUpdate(String sql, Object ... args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<Map<String, Object>> query(String sql, Map<String, Object> args) {
        this.logger.debug("sql -> {}, args -> {}", (Object)sql, args);
        Execution execution = SqlUtils.convertNamedParamSql((String)sql, args);
        return this.query(execution.getExecution(), execution.getParams());
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Map<String, Object>> query(String sql, Object ... args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public <T> List<T> query(String sql, RowMapper<T> rowMapper, Map<String, Object> args) {
        this.logger.debug("sql -> {}, args -> {}", (Object)sql, args);
        Execution execution = SqlUtils.convertNamedParamSql((String)sql, args);
        return this.query(execution.getExecution(), rowMapper, execution.getParams());
    }

    @Override
    public <T> List<T> query(String sql, Class<T> elementType, Map<String, Object> args) {
        this.logger.debug("sql -> {}, args -> {}, elementType -> {}", new Object[]{sql, args, elementType});
        Execution execution = SqlUtils.convertNamedParamSql((String)sql, args);
        return this.query(execution.getExecution(), elementType, execution.getParams());
    }

    @Override
    public <T> List<T> query(String sql, Class<T> elementType, Object ... args) {
        SQLType sqlType = this.manager.getSqlType(elementType);
        Object rowMapper = null;
        rowMapper = sqlType == null ? new NestedBeanPropertyRowMapper<T>(elementType, this.manager) : new SingleColumnRowMapper<T>(elementType, this.manager);
        return this.query(sql, (RowMapper<T>)rowMapper, args);
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T> List<T> query(String sql, RowMapper<T> rowMapper, Object ... args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Map<String, Object> querySingle(String sql, Map<String, Object> args) {
        return this.singleResult(this.query(sql, args));
    }

    @Override
    public Map<String, Object> querySingle(String sql, Object ... args) {
        return this.singleResult(this.query(sql, args));
    }

    @Override
    public <T> T querySingle(String sql, RowMapper<T> rowMapper, Object ... args) {
        return this.singleResult(this.query(sql, rowMapper, args));
    }

    @Override
    public <T> T querySingle(String sql, RowMapper<T> rowMapper, Map<String, Object> args) {
        return this.singleResult(this.query(sql, rowMapper, args));
    }

    @Override
    public <T> T querySingle(String sql, Class<T> elementType, Map<String, Object> args) {
        return this.singleResult(this.query(sql, elementType, args));
    }

    @Override
    public <T> T querySingle(String sql, Class<T> elementType, Object ... args) {
        return this.singleResult(this.query(sql, elementType, args));
    }

    private <T> T singleResult(Collection<T> results) {
        if (results == null || results.size() <= 0) {
            return null;
        }
        if (results.size() > 1) {
            throw new JdbcException(Strings.format((String)"results size must be 1, but is {0}", (Object)results.size()));
        }
        return results.iterator().next();
    }

    @Override
    public Map<String, Object> queryUnique(String sql, Map<String, Object> args) {
        return this.nullableSingleResult(this.query(sql, args));
    }

    @Override
    public Map<String, Object> queryUnique(String sql, Object ... args) {
        return this.nullableSingleResult(this.query(sql, args));
    }

    @Override
    public <T> T queryUnique(String sql, RowMapper<T> rowMapper, Object ... args) {
        return this.nullableSingleResult(this.query(sql, rowMapper, args));
    }

    @Override
    public <T> T queryUnique(String sql, RowMapper<T> rowMapper, Map<String, Object> args) {
        return this.nullableSingleResult(this.query(sql, rowMapper, args));
    }

    @Override
    public <T> T queryUnique(String sql, Class<T> elementType, Map<String, Object> args) {
        return this.nullableSingleResult(this.query(sql, elementType, args));
    }

    @Override
    public <T> T queryUnique(String sql, Class<T> elementType, Object ... args) {
        return this.nullableSingleResult(this.query(sql, elementType, args));
    }

    private <T> T nullableSingleResult(Collection<T> results) {
        if (Lang.isEmpty(results)) {
            throw new JdbcException("results is empty");
        }
        if (results.size() > 1) {
            throw new JdbcException(Strings.format((String)"results size must be 1, but is {0}", (Object)results.size()));
        }
        return results.iterator().next();
    }

    @Override
    public Integer queryInt(String sql, Object ... args) {
        return this.queryValue(sql, Integer.class, args);
    }

    @Override
    public Integer queryInt(String sql, Map<String, Object> args) {
        return this.queryValue(sql, Integer.class, args);
    }

    @Override
    public Long queryLong(String sql, Object ... args) {
        return this.queryValue(sql, Long.class, args);
    }

    @Override
    public Long queryLong(String sql, Map<String, Object> args) {
        return this.queryValue(sql, Long.class, args);
    }

    @Override
    public BigDecimal queryBigDecimal(String sql, Object ... args) {
        return this.queryValue(sql, BigDecimal.class, args);
    }

    @Override
    public BigDecimal queryBigDecimal(String sql, Map<String, Object> args) {
        return this.queryValue(sql, BigDecimal.class, args);
    }

    @Override
    public Double queryDouble(String sql, Object ... args) {
        return this.queryValue(sql, Double.class, args);
    }

    @Override
    public Double queryDouble(String sql, Map<String, Object> args) {
        return this.queryValue(sql, Double.class, args);
    }

    @Override
    public String queryString(String sql, Object ... args) {
        return this.queryValue(sql, String.class, args);
    }

    @Override
    public String queryString(String sql, Map<String, Object> args) {
        return this.queryValue(sql, String.class, args);
    }

    @Override
    public <T> T queryValue(String sql, Class<T> valueType, Map<String, Object> args) {
        return this.queryValue(sql, new SingleColumnRowMapper<T>(valueType, this.manager), args);
    }

    @Override
    public <T> T queryValue(String sql, Class<T> valueType, Object ... args) {
        return this.queryValue(sql, new SingleColumnRowMapper<T>(valueType, this.manager), args);
    }

    @Override
    public <T> T queryValue(String sql, RowMapper<T> rowMapper, Map<String, Object> args) {
        this.logger.debug("sql -> {}, args -> {}", (Object)sql, args);
        Execution execution = SqlUtils.convertNamedParamSql((String)sql, args);
        return this.queryValue(execution.getExecution(), rowMapper, execution.getParams());
    }

    @Override
    public <T> T queryValue(String sql, RowMapper<T> rowMapper, Object ... args) {
        List<T> results = this.query(sql, rowMapper, args);
        return this.nullableSingleResult(results);
    }

    protected void setParams(PreparedStatement prep, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            this.manager.set(prep, i + 1, args[i]);
        }
    }

    protected abstract void releaseConnection(Connection var1, DataSource var2);

    protected abstract Connection getConnection();
}

