/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.config;

import cn.featherfly.constant.ConstantConfigurator;
import cn.featherfly.constant.ConstantPool;
import cn.featherfly.hammer.Hammer;
import cn.featherfly.hammer.config.Configurator;
import cn.featherfly.hammer.sqldb.SqldbHammerImpl;
import cn.featherfly.hammer.sqldb.config.SqlDbConstant;
import cn.featherfly.hammer.sqldb.tpl.SqlDbTemplateEngine;
import cn.featherfly.hammer.sqldb.tpl.freemarker.SqldbFreemarkerTemplateEngine;
import cn.featherfly.hammer.tpl.TplConfigFactory;
import cn.featherfly.hammer.tpl.TplConfigFactoryImpl;

public class SqlDbConfigurator
implements Configurator {
    public static final String DEFAULT_FILE_NAME = "hammer.yaml";
    private static SqlDbConfigurator DEFAULT;
    private SqldbHammerImpl sqldbHammer;
    private SqlDbConstant constant;

    public static SqlDbConfigurator getDefault() {
        return SqlDbConfigurator.getDefault(DEFAULT_FILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SqlDbConfigurator getDefault(String fileName) {
        if (DEFAULT != null) return DEFAULT;
        Class<SqlDbConfigurator> clazz = SqlDbConfigurator.class;
        synchronized (SqlDbConfigurator.class) {
            SqlDbTemplateEngine templateEngine;
            SqlDbConstant constant;
            TplConfigFactory factory;
            if (DEFAULT != null) return DEFAULT;
            SqlDbConfigurator configuration = new SqlDbConfigurator();
            if (!ConstantPool.isInit()) {
                ConstantConfigurator.config((String)fileName);
            }
            if ((factory = (constant = (SqlDbConstant)((Object)ConstantPool.getDefault().getConstant(SqlDbConstant.class))).getTplConfigFactory()) == null) {
                factory = new TplConfigFactoryImpl(constant.getTplConfigPrefix(), constant.getTplConfigSuffix());
            }
            if ((templateEngine = constant.getTemplateEngine()) == null) {
                templateEngine = new SqldbFreemarkerTemplateEngine(factory);
            }
            configuration.sqldbHammer = new SqldbHammerImpl(constant.getJdbc(), constant.getMappingFactory(), factory, templateEngine);
            configuration.constant = constant;
            DEFAULT = configuration;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DEFAULT;
        }
    }

    public Hammer getHammer() {
        return this.sqldbHammer;
    }

    public SqlDbConstant getConstant() {
        return this.constant;
    }
}

