/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.mapping.JdbcMappingException;
import cn.featherfly.common.db.mapping.SqlResultSet;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.reflect.GenericClass;
import cn.featherfly.common.repository.mapping.ResultSet;
import java.sql.JDBCType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.jdbc.IncorrectResultSetColumnCountException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.NumberUtils;

public class SingleColumnRowMapper<T>
implements RowMapper<T>,
cn.featherfly.common.repository.mapping.RowMapper<T> {
    @Nullable
    private Class<?> requiredType;
    @Nullable
    private ConversionService conversionService = DefaultConversionService.getSharedInstance();
    @Nullable
    private SqlTypeMappingManager manager;

    public SingleColumnRowMapper(Class<T> requiredType, SqlTypeMappingManager manager) {
        this.setRequiredType(requiredType);
        this.manager = manager;
    }

    public void setRequiredType(Class<T> requiredType) {
        this.requiredType = ClassUtils.resolvePrimitiveIfNecessary(requiredType);
    }

    public void setConversionService(@Nullable ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public T mapRow(ResultSet res, int rowNum) {
        java.sql.ResultSet rs = null;
        if (!(res instanceof SqlResultSet)) {
            throw new JdbcMappingException("ResultSet is not type of SqlResultSet");
        }
        SqlResultSet sqlrs = (SqlResultSet)res;
        rs = sqlrs.getResultSet();
        AssertIllegalArgument.isNotNull((Object)rs, (String)"java.sql.ResultSet");
        try {
            return this.mapRow(rs, rowNum);
        }
        catch (SQLException e) {
            throw new JdbcException((Throwable)e);
        }
    }

    @Nullable
    public T mapRow(java.sql.ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int nrOfColumns = rsmd.getColumnCount();
        if (nrOfColumns != 1) {
            throw new IncorrectResultSetColumnCountException(1, nrOfColumns);
        }
        Object result = this.getColumnValue(rs, 1, this.requiredType);
        if (result != null && this.requiredType != null && !this.requiredType.isInstance(result)) {
            try {
                return (T)this.convertValueToRequiredType(result, this.requiredType);
            }
            catch (IllegalArgumentException ex) {
                throw new TypeMismatchDataAccessException("Type mismatch affecting row number " + rowNum + " and column type '" + rsmd.getColumnTypeName(1) + "': " + ex.getMessage());
            }
        }
        return (T)result;
    }

    @Nullable
    protected Object getColumnValue(java.sql.ResultSet rs, int index, @Nullable Class<?> requiredType) throws SQLException {
        if (requiredType != null) {
            return this.manager.get(rs, index, (GenericType)new GenericClass(requiredType));
        }
        JDBCType sqlType = JDBCType.valueOf(rs.getMetaData().getColumnType(index));
        Class type = this.manager.getJavaType((SQLType)sqlType);
        if (type != null) {
            return this.manager.get(rs, index, (GenericType)new GenericClass(type));
        }
        return this.getColumnValue(rs, index);
    }

    @Nullable
    protected Object getColumnValue(java.sql.ResultSet rs, int index) throws SQLException {
        return JdbcUtils.getResultSetValue((java.sql.ResultSet)rs, (int)index);
    }

    @Nullable
    protected Object convertValueToRequiredType(Object value, Class<?> requiredType) {
        if (String.class == requiredType) {
            return value.toString();
        }
        if (Number.class.isAssignableFrom(requiredType)) {
            if (value instanceof Number) {
                return NumberUtils.convertNumberToTargetClass((Number)((Number)value), requiredType);
            }
            return NumberUtils.parseNumber((String)value.toString(), requiredType);
        }
        if (this.conversionService != null && this.conversionService.canConvert(value.getClass(), requiredType)) {
            return this.conversionService.convert(value, requiredType);
        }
        throw new IllegalArgumentException("Value [" + value + "] is of type [" + value.getClass().getName() + "] and cannot be converted to required type [" + requiredType.getName() + "]");
    }
}

