/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.PropertyMapping;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractQueryOperate;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

public class GetOperate<T>
extends AbstractQueryOperate<T> {
    private List<PropertyMapping> pkPms;

    public GetOperate(Jdbc jdbc, ClassMapping<T> classMapping) {
        super(jdbc, classMapping);
    }

    public GetOperate(Jdbc jdbc, ClassMapping<T> classMapping, String dataBase) {
        super(jdbc, classMapping, dataBase);
    }

    public GetOperate(Jdbc jdbc, ClassMapping<T> classMapping, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, databaseMetadata);
    }

    public Serializable getId(T entity) {
        if (entity == null) {
            return null;
        }
        if (this.pkPms.size() == 1) {
            return (Serializable)BeanUtils.getProperty(entity, (String)this.pkPms.get(0).getPropertyName());
        }
        if (this.pkPms.size() > 1) {
            throw new SqldbHammerException("multy id defined in entity [" + entity.getClass().getName() + "], you can invoke getIds(entity) method instead");
        }
        this.logger.debug("no id defined in entity {}", (Object)entity.getClass().getName());
        return null;
    }

    public List<Serializable> getIds(T entity) {
        if (entity == null) {
            return null;
        }
        return this.pkPms.stream().map(p -> (Serializable)BeanUtils.getProperty((Object)entity, (String)ClassMappingUtils.getPropertyAliasName((PropertyMapping)p))).collect(Collectors.toList());
    }

    public T get(Serializable id) {
        if (id == null) {
            throw new SqldbHammerException("#get.id.null");
        }
        return this.jdbc.querySingle(this.sql, new Object[]{id}, (res, rowNum) -> this.mapRow(res, rowNum));
    }

    public T get(T entity) {
        if (entity == null) {
            throw new SqldbHammerException("#get.id.null");
        }
        List<Serializable> ids = this.getIds(entity);
        if (Lang.isEmpty(ids)) {
            throw new SqldbHammerException("#get.id.null");
        }
        return this.jdbc.querySingle(this.sql, ids.toArray(), (res, rowNum) -> this.mapRow(res, rowNum));
    }

    @Override
    protected void initSql() {
        this.sql = ClassMappingUtils.getSelectByIdSql((ClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        this.pkPms = this.classMapping.getPrivaryKeyPropertyMappings();
        this.logger.debug("sql: {}", (Object)this.sql);
    }

    @Override
    protected String initCondition() {
        return "";
    }
}

