/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.db.metadata.DatabaseMetadataManager;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.hammer.sqldb.Constants;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public abstract class AbstractOperate<T> {
    protected final Logger logger = Constants.LOGGER;
    protected String sql;
    protected Jdbc jdbc;
    protected ClassMapping<T> classMapping;
    protected DatabaseMetadata meta;
    protected Map<Integer, String> propertyPositions = new HashMap<Integer, String>(0);

    public AbstractOperate(Jdbc jdbc, ClassMapping<T> classMapping) {
        this(jdbc, classMapping, "");
    }

    public AbstractOperate(Jdbc jdbc, ClassMapping<T> classMapping, String dataBase) {
        this.meta = Lang.isEmpty((String)dataBase) ? DatabaseMetadataManager.getDefaultManager().create(jdbc.getDataSource()) : DatabaseMetadataManager.getDefaultManager().create(jdbc.getDataSource(), dataBase);
        this.jdbc = jdbc;
        this.classMapping = classMapping;
        this.initSql();
    }

    public AbstractOperate(Jdbc jdbc, ClassMapping<T> classMapping, DatabaseMetadata databaseMetadata) {
        this.jdbc = jdbc;
        this.classMapping = classMapping;
        this.meta = databaseMetadata;
        this.initSql();
    }

    public String getSql() {
        return this.sql;
    }

    protected void setParameter(PreparedStatement prep, T entity) {
        for (Map.Entry<Integer, String> propertyPosition : this.propertyPositions.entrySet()) {
            JdbcUtils.setParameter((PreparedStatement)prep, (int)propertyPosition.getKey(), (Object)BeanUtils.getProperty(entity, (String)propertyPosition.getValue()));
        }
    }

    protected void setParameter(PreparedStatement prep, T entity, int index) {
        int len = this.propertyPositions.size();
        for (Map.Entry<Integer, String> propertyPosition : this.propertyPositions.entrySet()) {
            int position = propertyPosition.getKey() + index * len;
            JdbcUtils.setParameter((PreparedStatement)prep, (int)position, (Object)BeanUtils.getProperty(entity, (String)propertyPosition.getValue()));
        }
    }

    public Object[] getParameters(T entity) {
        return this.getParameters(entity, this.propertyPositions);
    }

    public Object[] getBatchParameters(List<T> entities, Map<Integer, String> propertyPositions) {
        if (Lang.isEmpty(entities)) {
            return new Object[0];
        }
        Object[] params = new Object[propertyPositions.size()];
        int pkNum = propertyPositions.size() / entities.size();
        int i = 0;
        Object entity = null;
        for (Map.Entry<Integer, String> propertyPosition : propertyPositions.entrySet()) {
            if (i % pkNum == 0) {
                entity = entities.get(i / pkNum);
            }
            params[i] = BeanUtils.getProperty(entity, (String)propertyPosition.getValue());
            ++i;
        }
        return params;
    }

    protected Object[] getParameters(T entity, Map<Integer, String> propertyPositions) {
        Object[] params = new Object[propertyPositions.size()];
        int i = 0;
        for (Map.Entry<Integer, String> propertyPosition : propertyPositions.entrySet()) {
            params[i] = BeanUtils.getProperty(entity, (String)propertyPosition.getValue());
            ++i;
        }
        return params;
    }

    protected void setParameter(PreparedStatement prep, Serializable id) {
        JdbcUtils.setParameter((PreparedStatement)prep, (int)1, (Object)id);
    }

    protected void setParameter(PreparedStatement prep, List<Serializable> ids) {
        int i = 0;
        for (Serializable id : ids) {
            JdbcUtils.setParameter((PreparedStatement)prep, (int)(++i), (Object)id);
        }
    }

    protected abstract void initSql();
}

