/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.dsl.query;

import cn.featherfly.common.db.Column;
import cn.featherfly.common.db.Table;
import cn.featherfly.common.db.builder.dml.basic.SqlSelectBasicBuilder;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.LambdaUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.function.SerializableFunction;
import cn.featherfly.common.repository.builder.AliasManager;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.MappingFactory;
import cn.featherfly.common.repository.mapping.PropertyMapping;
import cn.featherfly.common.repository.operate.AggregateFunction;
import cn.featherfly.hammer.HammerException;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import com.speedment.common.tuple.Tuple2;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractSqlQueryEntityProperties<E extends AbstractSqlQueryEntityProperties<E>> {
    protected Jdbc jdbc;
    protected String idName;
    protected SqlSelectBasicBuilder selectBuilder;
    protected ClassMapping<?> classMapping;
    protected MappingFactory factory;
    protected AliasManager aliasManager;

    public AbstractSqlQueryEntityProperties(Jdbc jdbc, ClassMapping<?> classMapping, MappingFactory factory, AliasManager aliasManager) {
        this.jdbc = jdbc;
        this.classMapping = classMapping;
        this.factory = factory;
        this.aliasManager = aliasManager;
        String tableAlias = aliasManager.getAlias(classMapping.getRepositoryName());
        if (tableAlias == null) {
            tableAlias = aliasManager.put(classMapping.getRepositoryName());
        }
        if (classMapping.getPrivaryKeyPropertyMappings().size() == 1) {
            this.idName = ((PropertyMapping)classMapping.getPrivaryKeyPropertyMappings().get(0)).getRepositoryFieldName();
        }
        this.selectBuilder = new SqlSelectBasicBuilder(jdbc.getDialect(), classMapping, tableAlias, factory);
    }

    public AbstractSqlQueryEntityProperties(Jdbc jdbc, DatabaseMetadata databaseMetadata, String tableName, String tableAlias, MappingFactory factory, AliasManager aliasManager) {
        Table tableMetadata;
        this.jdbc = jdbc;
        this.factory = factory;
        this.aliasManager = aliasManager;
        if (tableAlias == null) {
            tableAlias = aliasManager.put(tableName);
        }
        if ((tableMetadata = databaseMetadata.getTable(tableName)).getPrimaryColumns().size() == 1) {
            this.idName = ((Column)tableMetadata.getPrimaryColumns().get(0)).getName();
        }
        this.selectBuilder = new SqlSelectBasicBuilder(jdbc.getDialect(), tableName, tableAlias);
    }

    public E property(String propertyName) {
        Tuple2 columnAndProperty = ClassMappingUtils.getColumnAndPropertyName((String)propertyName, this.classMapping);
        if (Lang.isEmpty((String)((String)columnAndProperty.get1()))) {
            this.selectBuilder.addSelectColumn((String)columnAndProperty.get0());
        } else {
            this.selectBuilder.addSelectColumn((String)columnAndProperty.get0(), (String)columnAndProperty.get1());
        }
        return (E)this;
    }

    public E property(String propertyName, AggregateFunction aggregateFunction) {
        Tuple2 columnAndProperty = ClassMappingUtils.getColumnAndPropertyName((String)propertyName, this.classMapping);
        if (Lang.isEmpty((String)((String)columnAndProperty.get1()))) {
            this.selectBuilder.addSelectColumn((String)columnAndProperty.get0(), aggregateFunction);
        } else {
            this.selectBuilder.addSelectColumn((String)columnAndProperty.get0(), aggregateFunction, (String)columnAndProperty.get1());
        }
        return (E)this;
    }

    public <T, R> E property(SerializableFunction<T, R> propertyName, AggregateFunction aggregateFunction) {
        return this.property(LambdaUtils.getLambdaPropertyName(propertyName), aggregateFunction);
    }

    public E property(String ... propertyNames) {
        for (String propertyName : propertyNames) {
            this.property(propertyName);
        }
        return (E)this;
    }

    public E property(Collection<String> propertyNames) {
        for (String propertyName : propertyNames) {
            this.property(propertyName);
        }
        return (E)this;
    }

    public <T, R> E property(SerializableFunction<T, R> ... propertyNames) {
        return this.property(Arrays.stream(propertyNames).map(LambdaUtils::getLambdaPropertyName).collect(Collectors.toList()));
    }

    public <T, R> E property(SerializableFunction<T, R> propertyName) {
        return this.property(LambdaUtils.getLambdaPropertyName(propertyName));
    }

    public <T, R> E propertyAlias(SerializableFunction<T, R> propertyName, String alias) {
        return this.propertyAlias(LambdaUtils.getLambdaPropertyName(propertyName), alias);
    }

    public E propertyAlias(String columnName, String alias) {
        this.selectBuilder.addSelectColumn(ClassMappingUtils.getColumnName((String)columnName, this.classMapping), alias);
        return (E)this;
    }

    public E propertyAlias(Map<String, String> columnNameMap) {
        columnNameMap.forEach((k, v) -> this.propertyAlias((String)k, (String)v));
        return (E)this;
    }

    public E id(String propertyName) {
        this.idName = ClassMappingUtils.getColumnName((String)propertyName, this.classMapping);
        return (E)this;
    }

    public <T, R> E id(SerializableFunction<T, R> propertyName) {
        return this.id(LambdaUtils.getLambdaPropertyName(propertyName));
    }

    protected String getIdName() {
        if (Lang.isEmpty((String)this.idName)) {
            throw new HammerException("privary key column name is null");
        }
        return this.idName;
    }

    SqlSelectBasicBuilder getSelectBuilder() {
        return this.selectBuilder;
    }
}

