/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.tpl.freemarker.directive;

import cn.featherfly.common.db.Table;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.WordUtils;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.MappingFactory;
import cn.featherfly.hammer.tpl.TplException;
import cn.featherfly.hammer.tpl.directive.PropertiesMappingDirective;
import cn.featherfly.hammer.tpl.freemarker.FreemarkerDirective;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;

public class PropertiesMappingDirectiveModel
extends PropertiesMappingDirective
implements FreemarkerDirective {
    private JdbcMappingFactory mappingFactory;

    public PropertiesMappingDirectiveModel(JdbcMappingFactory mappingFactory, Class<?> resultType) {
        this("repo", mappingFactory, resultType);
    }

    public PropertiesMappingDirectiveModel(String paramName, JdbcMappingFactory mappingFactory, Class<?> resultType) {
        super(paramName, (MappingFactory)mappingFactory, resultType);
        this.mappingFactory = mappingFactory;
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String nameParam = null;
        String aliasParam = null;
        Class<?> mappingType = null;
        Set entrySet = params.entrySet();
        for (Map.Entry ent : entrySet) {
            String paramName = (String)ent.getKey();
            TemplateModel paramValue = (TemplateModel)ent.getValue();
            if (paramName.equals(this.paramName)) {
                if (!(paramValue instanceof TemplateScalarModel)) {
                    throw new TplException("The \"" + paramName + "\" parameter " + "must be a String.");
                }
                nameParam = ((TemplateScalarModel)paramValue).getAsString();
                continue;
            }
            if (paramName.equals("alias")) {
                if (!(paramValue instanceof TemplateScalarModel)) {
                    throw new TplException("The \"alias\" parameter must be a String.");
                }
                aliasParam = ((TemplateScalarModel)paramValue).getAsString();
                continue;
            }
            if (paramName.equals("mapping")) {
                if (!(paramValue instanceof TemplateScalarModel)) {
                    throw new TplException("The \"mapping\" parameter must be a String.");
                }
                String mappingClassName = ((TemplateScalarModel)paramValue).getAsString();
                try {
                    mappingType = Class.forName(mappingClassName);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new TplException("The \"mapping\" parameter " + mappingClassName + " exception -> " + e.getMessage());
                }
            }
            throw new TplException("Unsupported parameter: " + paramName);
        }
        if (mappingType == null) {
            mappingType = this.resultType;
        }
        ClassMapping classMapping = null;
        if (mappingType == null) {
            if (Lang.isEmpty(nameParam)) {
                throw new TplException("The \"" + this.paramName + "\" parameter " + "can not be null when result type is not mapped");
            }
        } else {
            classMapping = this.mappingFactory.getClassMapping((Class)mappingType);
        }
        Writer out = env.getOut();
        boolean aliasIsEmpty = Lang.isEmpty(aliasParam);
        String alias = aliasParam;
        StringBuilder result = new StringBuilder();
        if (classMapping == null) {
            Table tableMetadata = this.mappingFactory.getMetadata().getTable(nameParam.toUpperCase());
            tableMetadata.getColumns().forEach(column -> {
                String propName = WordUtils.parseToUpperFirst((String)column.getName(), (char)'_');
                if (aliasIsEmpty) {
                    result.append(" " + column.getName() + " as " + propName + ",");
                } else {
                    result.append(" " + alias + "." + column.getName() + " as " + propName + ",");
                }
            });
            if (result.length() > 0) {
                result.deleteCharAt(result.length() - 1);
            }
            out.write(result.toString());
        } else {
            out.write(ClassMappingUtils.getSelectColumnsSql((ClassMapping)classMapping, (String)alias, (Dialect)this.mappingFactory.getDialect()));
        }
    }
}

