/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.tpl;

import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.structure.page.Limit;
import cn.featherfly.common.structure.page.Page;
import cn.featherfly.common.structure.page.PaginationResults;
import cn.featherfly.common.structure.page.SimplePaginationResults;
import cn.featherfly.hammer.sqldb.Constants;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.tpl.SqlDbTemplateEngine;
import cn.featherfly.hammer.sqldb.tpl.SqlDbTemplateProcessEnv;
import cn.featherfly.hammer.tpl.TplConfigFactory;
import cn.featherfly.hammer.tpl.TplExecuteConfig;
import cn.featherfly.hammer.tpl.TplExecuteId;
import cn.featherfly.hammer.tpl.TplExecuteIdFileImpl;
import cn.featherfly.hammer.tpl.TplExecutor;
import cn.featherfly.hammer.tpl.directive.TemplateDirective;
import cn.featherfly.hammer.tpl.method.TemplateMethod;
import cn.featherfly.hammer.tpl.supports.ConditionParamsManager;
import com.speedment.common.tuple.Tuple2;
import com.speedment.common.tuple.Tuple3;
import com.speedment.common.tuple.Tuple4;
import com.speedment.common.tuple.Tuples;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlTplExecutor
implements TplExecutor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private TplConfigFactory configFactory;
    private Jdbc jdbc;
    private JdbcMappingFactory mappingFactory;
    private SqlDbTemplateEngine<TemplateDirective, TemplateMethod> templateEngine;

    public SqlTplExecutor(@Nonnull TplConfigFactory configFactory, @Nonnull SqlDbTemplateEngine templateEngine, @Nonnull Jdbc jdbc, @Nonnull JdbcMappingFactory mappingFactory) {
        this.configFactory = configFactory;
        this.jdbc = jdbc;
        this.mappingFactory = mappingFactory;
        this.templateEngine = templateEngine;
    }

    public int execute(String tplExecuteId, Map<String, Object> params) {
        return this.execute((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), params);
    }

    public int execute(TplExecuteId tplExecuteId, Map<String, Object> params) {
        Tuple3<String, TplExecuteConfig, ConditionParamsManager> queryExecution = this.getQueryExecution(tplExecuteId, params, Integer.class);
        if (((ConditionParamsManager)queryExecution.get2()).getParamNamed() == null || ((ConditionParamsManager)queryExecution.get2()).getParamNamed().booleanValue()) {
            return this.jdbc.update((String)queryExecution.get0(), this.getEffectiveParamMap(params, (ConditionParamsManager)queryExecution.get2()));
        }
        return this.jdbc.update((String)queryExecution.get0(), this.getEffectiveParamArray(params, (ConditionParamsManager)queryExecution.get2()));
    }

    public Map<String, Object> single(String tplExecuteId, Map<String, Object> params) {
        return this.single((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), params);
    }

    public Map<String, Object> single(TplExecuteId tplExecuteId, Map<String, Object> params) {
        Tuple3<String, TplExecuteConfig, ConditionParamsManager> tuple3 = this.getQueryExecution(tplExecuteId, params, null);
        if (((ConditionParamsManager)tuple3.get2()).getParamNamed() == null || ((ConditionParamsManager)tuple3.get2()).getParamNamed().booleanValue()) {
            return this.jdbc.querySingle((String)tuple3.get0(), this.getEffectiveParamMap(params, (ConditionParamsManager)tuple3.get2()));
        }
        return this.jdbc.querySingle((String)tuple3.get0(), this.getEffectiveParamArray(params, (ConditionParamsManager)tuple3.get2()));
    }

    public <E> E single(String tplExecuteId, Class<E> entityType, Map<String, Object> params) {
        return this.single((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType, params);
    }

    public <E> E single(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params) {
        Tuple3<String, TplExecuteConfig, ConditionParamsManager> tuple3 = this.getQueryExecution(tplExecuteId, params, entityType);
        if (((ConditionParamsManager)tuple3.get2()).getParamNamed() == null || ((ConditionParamsManager)tuple3.get2()).getParamNamed().booleanValue()) {
            return this.jdbc.querySingle((String)tuple3.get0(), this.getEffectiveParamMap(params, (ConditionParamsManager)tuple3.get2()), entityType);
        }
        return this.jdbc.querySingle((String)tuple3.get0(), this.getEffectiveParamArray(params, (ConditionParamsManager)tuple3.get2()), entityType);
    }

    public List<Map<String, Object>> list(String tplExecuteId, Map<String, Object> params) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), params);
    }

    public List<Map<String, Object>> list(TplExecuteId tplExecuteId, Map<String, Object> params) {
        Tuple3<String, TplExecuteConfig, ConditionParamsManager> tuple3 = this.getQueryExecution(tplExecuteId, params, null);
        if (((ConditionParamsManager)tuple3.get2()).getParamNamed() == null || ((ConditionParamsManager)tuple3.get2()).getParamNamed().booleanValue()) {
            return this.jdbc.query((String)tuple3.get0(), this.getEffectiveParamMap(params, (ConditionParamsManager)tuple3.get2()));
        }
        return this.jdbc.query((String)tuple3.get0(), this.getEffectiveParamArray(params, (ConditionParamsManager)tuple3.get2()));
    }

    public <E> List<E> list(String tplExecuteId, Class<E> entityType, Map<String, Object> params) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType, params);
    }

    public <E> List<E> list(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params) {
        Tuple3<String, TplExecuteConfig, ConditionParamsManager> tuple3 = this.getQueryExecution(tplExecuteId, params, entityType);
        if (((ConditionParamsManager)tuple3.get2()).getParamNamed() == null || ((ConditionParamsManager)tuple3.get2()).getParamNamed().booleanValue()) {
            return this.jdbc.query((String)tuple3.get0(), this.getEffectiveParamMap(params, (ConditionParamsManager)tuple3.get2()), entityType);
        }
        return this.jdbc.query((String)tuple3.get0(), this.getEffectiveParamArray(params, (ConditionParamsManager)tuple3.get2()), entityType);
    }

    public List<Map<String, Object>> list(String tplExecuteId, Map<String, Object> params, int offset, int limit) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), params, offset, limit);
    }

    public List<Map<String, Object>> list(TplExecuteId tplExecuteId, Map<String, Object> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, params, offset, limit).get0();
    }

    public <E> List<E> list(String tplExecuteId, Class<E> entityType, Map<String, Object> params, int offset, int limit) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType, params, offset, limit);
    }

    public <E> List<E> list(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType, params, offset, limit).get0();
    }

    public List<Map<String, Object>> list(String tplExecuteId, Map<String, Object> params, Page page) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), params, page);
    }

    public List<Map<String, Object>> list(TplExecuteId tplExecuteId, Map<String, Object> params, Page page) {
        Limit limit = new Limit(page);
        return this.list(tplExecuteId, params, (int)limit.getOffset(), (int)limit.getLimit());
    }

    public <E> List<E> list(String tplExecuteId, Class<E> entityType, Map<String, Object> params, Page page) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType, params, page);
    }

    public <E> List<E> list(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params, Page page) {
        Limit limit = new Limit(page);
        return this.list(tplExecuteId, entityType, params, (int)limit.getOffset(), (int)limit.getLimit());
    }

    public PaginationResults<Map<String, Object>> pagination(String tplExecuteId, Map<String, Object> params, int offset, int limit) {
        return this.pagination((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), params, offset, limit);
    }

    public PaginationResults<Map<String, Object>> pagination(TplExecuteId tplExecuteId, Map<String, Object> params, int offset, int limit) {
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        Tuple4<List<Map<String, Object>>, String, TplExecuteConfig, ConditionParamsManager> listTuple = this.findList(tplExecuteId, params, offset, limit);
        pagination.setPageResults((List)listTuple.get0());
        String countSql = null;
        ConditionParamsManager manager = null;
        TplExecuteConfig config = (TplExecuteConfig)listTuple.get2();
        if (Lang.isEmpty((String)config.getCount())) {
            countSql = SqlUtils.convertSelectToCount((String)((String)listTuple.get1()));
            manager = (ConditionParamsManager)listTuple.get3();
        } else {
            Tuple2<String, ConditionParamsManager> countTuple = this.getCountExecution(tplExecuteId, params, config, null);
            countSql = (String)countTuple.get0();
            manager = (ConditionParamsManager)countTuple.get1();
        }
        if (manager.getParamNamed() == null || manager.getParamNamed().booleanValue()) {
            pagination.setTotal(this.jdbc.queryInt(countSql, this.getEffectiveParamMap(params, manager)));
        } else {
            pagination.setTotal(this.jdbc.queryInt(countSql, this.getEffectiveParamArray(params, manager)));
        }
        return pagination;
    }

    public PaginationResults<Map<String, Object>> pagination(String tplExecuteId, Map<String, Object> params, Page page) {
        return this.pagination((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), params, page);
    }

    public PaginationResults<Map<String, Object>> pagination(TplExecuteId tplExecuteId, Map<String, Object> params, Page page) {
        Limit limit = new Limit(page);
        return this.pagination(tplExecuteId, params, (int)limit.getOffset(), (int)limit.getLimit());
    }

    public <E> PaginationResults<E> pagination(String tplExecuteId, Class<E> entityType, Map<String, Object> params, int offset, int limit) {
        return this.pagination((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType, params, offset, limit);
    }

    public <E> PaginationResults<E> pagination(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params, int offset, int limit) {
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        Tuple4<List<E>, String, TplExecuteConfig, ConditionParamsManager> listTuple = this.findList(tplExecuteId, entityType, params, offset, limit);
        pagination.setPageResults((List)listTuple.get0());
        String countSql = null;
        ConditionParamsManager manager = null;
        TplExecuteConfig config = (TplExecuteConfig)listTuple.get2();
        if (Lang.isEmpty((String)config.getCount())) {
            countSql = SqlUtils.convertSelectToCount((String)((String)listTuple.get1()));
            manager = (ConditionParamsManager)listTuple.get3();
        } else {
            Tuple2<String, ConditionParamsManager> countTuple = this.getCountExecution(tplExecuteId, params, config, entityType);
            countSql = (String)countTuple.get0();
            manager = (ConditionParamsManager)countTuple.get1();
        }
        if (manager.getParamNamed() == null || manager.getParamNamed().booleanValue()) {
            pagination.setTotal(this.jdbc.queryInt(countSql, this.getEffectiveParamMap(params, manager)));
        } else {
            pagination.setTotal(this.jdbc.queryInt(countSql, this.getEffectiveParamArray(params, manager)));
        }
        return pagination;
    }

    public <E> PaginationResults<E> pagination(String tplExecuteId, Class<E> entityType, Map<String, Object> params, Page page) {
        return this.pagination((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType, params, page);
    }

    public <E> PaginationResults<E> pagination(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params, Page page) {
        Limit limit = new Limit(page);
        return this.pagination(tplExecuteId, entityType, params, (int)limit.getOffset(), (int)limit.getLimit());
    }

    public <E> E value(String tplExecuteId, Class<E> valueType, Map<String, Object> params) {
        return this.value((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), valueType, params);
    }

    public <E> E value(TplExecuteId tplExecuteId, Class<E> valueType, Map<String, Object> params) {
        Tuple3<String, TplExecuteConfig, ConditionParamsManager> tuple3 = this.getQueryExecution(tplExecuteId, params, valueType);
        if (((ConditionParamsManager)tuple3.get2()).getParamNamed() == null || ((ConditionParamsManager)tuple3.get2()).getParamNamed().booleanValue()) {
            return this.jdbc.queryValue((String)tuple3.get0(), this.getEffectiveParamMap(params, (ConditionParamsManager)tuple3.get2()), valueType);
        }
        return this.jdbc.queryValue((String)tuple3.get0(), this.getEffectiveParamArray(params, (ConditionParamsManager)tuple3.get2()), valueType);
    }

    public int intValue(String tplExecuteId, Map<String, Object> params) {
        return this.numberInt(tplExecuteId, params);
    }

    public int intValue(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.numberInt(tplExecuteId, params);
    }

    public long longValue(String tplExecuteId, Map<String, Object> params) {
        return this.numberLong(tplExecuteId, params);
    }

    public long longValue(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.numberLong(tplExecuteId, params);
    }

    public double doubleValue(String tplExecuteId, Map<String, Object> params) {
        return this.numberDouble(tplExecuteId, params);
    }

    public double doubleValue(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.numberDouble(tplExecuteId, params);
    }

    public <N extends Number> N number(String tplExecuteId, Class<N> numberType, Map<String, Object> params) {
        return (N)((Number)this.value(tplExecuteId, numberType, params));
    }

    public <N extends Number> N number(TplExecuteId tplExecuteId, Class<N> numberType, Map<String, Object> params) {
        return (N)((Number)this.value(tplExecuteId, numberType, params));
    }

    public Integer numberInt(String tplExecuteId, Map<String, Object> params) {
        return this.number(tplExecuteId, Integer.class, params);
    }

    public Integer numberInt(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.number(tplExecuteId, Integer.class, params);
    }

    public Long numberLong(String tplExecuteId, Map<String, Object> params) {
        return this.number(tplExecuteId, Long.class, params);
    }

    public Long numberLong(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.number(tplExecuteId, Long.class, params);
    }

    public Double numberDouble(String tplExecuteId, Map<String, Object> params) {
        return this.number(tplExecuteId, Double.class, params);
    }

    public Double numberDouble(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.number(tplExecuteId, Double.class, params);
    }

    public BigDecimal numberBigDecimal(String tplExecuteId, Map<String, Object> params) {
        return this.number(tplExecuteId, BigDecimal.class, params);
    }

    public BigDecimal numberBigDecimal(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.number(tplExecuteId, BigDecimal.class, params);
    }

    public String string(String tplExecuteId, Map<String, Object> params) {
        return this.value(tplExecuteId, String.class, params);
    }

    public String string(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.value(tplExecuteId, String.class, params);
    }

    private Tuple3<String, TplExecuteConfig, ConditionParamsManager> getQueryExecution(TplExecuteId tplExecuteId, Map<String, Object> params, Class<?> resultType) {
        TplExecuteConfig config = this.configFactory.getConfig(tplExecuteId);
        Tuple2<String, ConditionParamsManager> tuple2 = this.getExecution(tplExecuteId, config.getQuery(), params, resultType);
        Constants.LOGGER.debug("tplExecuteId -> {} \nexecuteQuerySql -> {} \nqueryTemplate -> {}", new Object[]{tplExecuteId, tuple2.get0(), config.getQuery()});
        return Tuples.of((Object)tuple2.get0(), (Object)config, (Object)tuple2.get1());
    }

    private Tuple2<String, ConditionParamsManager> getCountExecution(TplExecuteId tplExecuteId, Map<String, Object> params, TplExecuteConfig config, Class<?> resultType) {
        Tuple2<String, ConditionParamsManager> result = this.getExecution(tplExecuteId, config.getCount(), params, resultType);
        Constants.LOGGER.debug("tplExecuteId -> {}  \nexecuteCountSql -> {}  \ncountTemplate -> {}", new Object[]{tplExecuteId, result.get0(), config.getCount()});
        return result;
    }

    private Tuple2<String, ConditionParamsManager> getExecution(TplExecuteId tplExecuteId, String sql, Map<String, Object> params, Class<?> resultType) {
        String templateName = tplExecuteId.getId() + ".count";
        this.logger.debug("execute template name : {}", (Object)templateName);
        ConditionParamsManager manager = new ConditionParamsManager();
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.putAll(params);
        SqlDbTemplateProcessEnv<TemplateDirective, TemplateMethod> templateProcessEnv = this.createTemplateProcessEnv(manager, resultType);
        String result = this.templateEngine.process(templateName, sql, params, templateProcessEnv);
        return Tuples.of((Object)result, (Object)manager);
    }

    private SqlDbTemplateProcessEnv<TemplateDirective, TemplateMethod> createTemplateProcessEnv(ConditionParamsManager manager, Class<?> resultType) {
        SqlDbTemplateProcessEnv env = (SqlDbTemplateProcessEnv)this.templateEngine.createTemplateProcessEnv();
        env.setConfigFactory(this.configFactory);
        env.setDialect(this.jdbc.getDialect());
        env.setManager(manager);
        env.setMappingFactory(this.mappingFactory);
        env.setResultType(resultType);
        return env;
    }

    private Tuple4<List<Map<String, Object>>, String, TplExecuteConfig, ConditionParamsManager> findList(TplExecuteId tplExecuteId, Map<String, Object> params, int offset, int limit) {
        Tuple3<String, TplExecuteConfig, ConditionParamsManager> tuple3 = this.getQueryExecution(tplExecuteId, params, null);
        List<Map<String, Object>> list = null;
        String sql = (String)tuple3.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple3.get2();
        list = manager.getParamNamed() == null || manager.getParamNamed() != false ? this.jdbc.query(this.jdbc.getDialect().getParamNamedPaginationSql(sql, offset, limit), this.jdbc.getDialect().getPaginationSqlParameter(this.getEffectiveParamMap(params, manager), offset, limit)) : this.jdbc.query(this.jdbc.getDialect().getPaginationSql(sql, offset, limit), this.jdbc.getDialect().getPaginationSqlParameter(this.getEffectiveParamArray(params, (ConditionParamsManager)tuple3.get2()), offset, limit));
        return Tuples.of(list, (Object)sql, (Object)tuple3.get1(), (Object)manager);
    }

    private <E> Tuple4<List<E>, String, TplExecuteConfig, ConditionParamsManager> findList(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params, int offset, int limit) {
        Tuple3<String, TplExecuteConfig, ConditionParamsManager> tuple3 = this.getQueryExecution(tplExecuteId, params, entityType);
        List<E> list = null;
        String sql = (String)tuple3.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple3.get2();
        list = manager.getParamNamed() == null || manager.getParamNamed() != false ? this.jdbc.query(this.jdbc.getDialect().getParamNamedPaginationSql(sql, offset, limit), (Map<String, Object>)this.jdbc.getDialect().getPaginationSqlParameter(this.getEffectiveParamMap(params, manager), offset, limit), entityType) : this.jdbc.query(this.jdbc.getDialect().getPaginationSql(sql, offset, limit), this.jdbc.getDialect().getPaginationSqlParameter(this.getEffectiveParamArray(params, manager), offset, limit), entityType);
        return Tuples.of(list, (Object)sql, (Object)tuple3.get1(), (Object)manager);
    }

    private Object[] getEffectiveParamArray(Map<String, Object> params, ConditionParamsManager manager) {
        return manager.getParamNames().stream().filter(n -> params.containsKey(n)).map(n -> params.get(n)).collect(Collectors.toList()).toArray();
    }

    private Map<String, Object> getEffectiveParamMap(Map<String, Object> params, ConditionParamsManager manager) {
        if (manager.getAmount() == 0) {
            return params;
        }
        return params.entrySet().stream().filter(t -> manager.containsName((String)t.getKey())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()));
    }
}

