/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.tpl;

import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.hammer.tpl.TemplateDirectives;
import cn.featherfly.hammer.tpl.TemplateMethods;
import cn.featherfly.hammer.tpl.TemplateProcessEnv;
import cn.featherfly.hammer.tpl.TplConfigFactory;
import cn.featherfly.hammer.tpl.directive.PropertiesMappingDirective;
import cn.featherfly.hammer.tpl.directive.TemplateDirective;
import cn.featherfly.hammer.tpl.method.TemplateMethod;
import cn.featherfly.hammer.tpl.supports.ConditionParamsManager;

public abstract class SqlDbTemplateProcessEnv<D extends TemplateDirective, M extends TemplateMethod>
implements TemplateProcessEnv<D, M> {
    protected ConditionParamsManager manager;
    protected Class<?> resultType;
    protected JdbcMappingFactory mappingFactory;
    protected TplConfigFactory configFactory;
    protected Dialect dialect;

    public TplConfigFactory getConfigFactory() {
        return this.configFactory;
    }

    public void setConfigFactory(TplConfigFactory configFactory) {
        this.configFactory = configFactory;
    }

    public void setMappingFactory(JdbcMappingFactory mappingFactory) {
        this.mappingFactory = mappingFactory;
    }

    public ConditionParamsManager getManager() {
        return this.manager;
    }

    public void setManager(ConditionParamsManager manager) {
        this.manager = manager;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public JdbcMappingFactory getMappingFactory() {
        return this.mappingFactory;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public TemplateDirectives<D> createDirectives() {
        TemplateDirectives directives = new TemplateDirectives();
        directives.addWhereDirective(this.createWhereDirective());
        directives.addAndDirective(this.createAndDirective());
        directives.addOrDirective(this.createOrDirective());
        directives.addPropertiesDirective(this.createPropertiesDirective());
        directives.addTemplateIncludeDirective(this.createIncludeDirective());
        directives.addWrapDirective(this.createWrapDirective());
        directives.addDirective("sql", this.createIncludeDirective());
        D directive = this.createPropertiesDirective();
        if (directive instanceof PropertiesMappingDirective) {
            PropertiesMappingDirective p = (PropertiesMappingDirective)directive;
            p.setParamName("table");
            directives.addDirective("columns", directive);
        }
        return directives;
    }

    public TemplateMethods<M> createMethods() {
        TemplateMethods methods = new TemplateMethods();
        methods.addWrapMethode(this.createWrapMethode());
        return methods;
    }

    protected abstract D createWhereDirective();

    protected abstract D createAndDirective();

    protected abstract D createOrDirective();

    protected abstract D createPropertiesDirective();

    protected abstract D createIncludeDirective();

    protected abstract D createWrapDirective();

    protected abstract M createWrapMethode();
}

